"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayInstance = exports.PrepayInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "PrepayInstanceProperty", { enumerable: true, get: function () { return redis_generated_1.RosPrepayInstance; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::PrepayInstance`
 */
class PrepayInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::PrepayInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayInstance = new redis_generated_1.RosPrepayInstance(this, id, {
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            evictionPolicy: props.evictionPolicy,
            securityGroupId: props.securityGroupId,
            vSwitchId: props.vSwitchId,
            instanceMaintainTime: props.instanceMaintainTime,
            period: props.period ? props.period : 1,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            instanceConnection: props.instanceConnection,
            instanceName: props.instanceName,
            vpcId: props.vpcId,
            sslEnabled: props.sslEnabled,
            capacity: props.capacity,
            tags: props.tags,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayInstance;
        this.attrConnectionDomain = rosPrepayInstance.attrConnectionDomain;
        this.attrInstanceClass = rosPrepayInstance.attrInstanceClass;
        this.attrInstanceId = rosPrepayInstance.attrInstanceId;
        this.attrInstanceName = rosPrepayInstance.attrInstanceName;
        this.attrOrderId = rosPrepayInstance.attrOrderId;
        this.attrPort = rosPrepayInstance.attrPort;
    }
}
exports.PrepayInstance = PrepayInstance;
//# sourceMappingURL=data:application/json;base64,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