# Copyright (c) 2020, Digi International, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from typing import Optional, Callable


def callback(callback: Optional[Callable[[int], None]], /) -> None:
    """
    Register a callback method that is called whenever a modem status is
    generated by the XBee.

    This callback takes one parameter, the integer value of the modem status.

    **Note: This is only available on XBee 3 RF products with version
    ending in 0B or newer, and XBee 3 Cellular products with version
    ending in 1B or newer.**

    :param callback: A function that is called whenever a modem status is
        received.
        If ``callback`` is None, the registered callback will be
        unregistered, allowing for polling of modem_status.receive() again.
    """
    ...


def receive() -> Optional[int]:
    """
    Returns a modem status if one is available. This function can only
    be called if no callback is registered, otherwise it will raise an
    exception.

    **Note: This is only available on XBee 3 RF products with version
    ending in 0B or newer, and XBee Cellular and XBee 3 Cellular products
    with version ending in 1B or newer.**

    :return: The integer value of a modem status, if available.
    """
    ...
