"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_1 = require("typescript");
const jsii_diagnostic_1 = require("../lib/jsii-diagnostic");
describe('jsii diagnostics', () => {
    describe('configureCategories', () => {
        beforeEach(() => {
            const code = jsii_diagnostic_1.Code.lookup(1);
            code.category = typescript_1.DiagnosticCategory.Suggestion;
        });
        test('diagnostic by name', () => {
            (0, jsii_diagnostic_1.configureCategories)({
                'metadata/package-json-missing-description': typescript_1.DiagnosticCategory.Error,
            });
            expect(jsii_diagnostic_1.Code.lookup(1).category).toEqual(typescript_1.DiagnosticCategory.Error);
        });
        test('diagnostic by code', () => {
            (0, jsii_diagnostic_1.configureCategories)({
                JSII1: typescript_1.DiagnosticCategory.Error,
            });
            expect(jsii_diagnostic_1.Code.lookup(1).category).toEqual(typescript_1.DiagnosticCategory.Error);
        });
        test('diagnostic by code zero prefixed', () => {
            (0, jsii_diagnostic_1.configureCategories)({
                JSII001: typescript_1.DiagnosticCategory.Error,
            });
            expect(jsii_diagnostic_1.Code.lookup(1).category).toEqual(typescript_1.DiagnosticCategory.Error);
        });
        test('invalid diagnostic code - NaN', () => {
            expect(() => {
                (0, jsii_diagnostic_1.configureCategories)({
                    JSIIPP: typescript_1.DiagnosticCategory.Error,
                });
            }).toThrow(/number must follow code/);
        });
        test('invalid diagnostic code - number', () => {
            expect(() => {
                (0, jsii_diagnostic_1.configureCategories)({
                    JSII77778888: typescript_1.DiagnosticCategory.Error,
                });
            }).toThrow(/Unrecognized diagnostic code/);
        });
        test('invalid diagnostic code - string', () => {
            expect(() => {
                (0, jsii_diagnostic_1.configureCategories)({
                    'invalid/does-not-exist': typescript_1.DiagnosticCategory.Error,
                });
            }).toThrow(/Unrecognized diagnostic code/);
        });
    });
});
//# sourceMappingURL=jsii-diagnostic.test.js.map