"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseFor2647 = exports.EnumFromScopedModule = exports.Operation = exports.Number = exports.NumericValue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base = require("@scope/jsii-calc-base");
/**
 * Abstract class which represents a numeric value.
 */
class NumericValue extends base.Base {
    /**
     * String representation of the value.
     */
    toString() {
        return this.value.toString();
    }
}
exports.NumericValue = NumericValue;
_a = JSII_RTTI_SYMBOL_1;
NumericValue[_a] = { fqn: "@scope/jsii-calc-lib.NumericValue", version: "0.0.0" };
/**
 * Represents a concrete number.
 */
class Number extends NumericValue {
    /**
     * Creates a Number object.
     * @param value The number.
     */
    constructor(value) {
        super();
        this.value = value;
    }
    /**
     * The number multiplied by 2.
     */
    get doubleValue() {
        return 2 * this.value;
    }
}
exports.Number = Number;
_b = JSII_RTTI_SYMBOL_1;
Number[_b] = { fqn: "@scope/jsii-calc-lib.Number", version: "0.0.0" };
/**
 * Represents an operation on values.
 */
class Operation extends NumericValue {
}
exports.Operation = Operation;
_c = JSII_RTTI_SYMBOL_1;
Operation[_c] = { fqn: "@scope/jsii-calc-lib.Operation", version: "0.0.0" };
/**
 * Check that enums from \@scoped packages can be references.
 * See awslabs/jsii#138
 */
var EnumFromScopedModule;
(function (EnumFromScopedModule) {
    EnumFromScopedModule[EnumFromScopedModule["VALUE1"] = 0] = "VALUE1";
    EnumFromScopedModule[EnumFromScopedModule["VALUE2"] = 1] = "VALUE2";
})(EnumFromScopedModule = exports.EnumFromScopedModule || (exports.EnumFromScopedModule = {}));
/**
 * A base class for testing #2647. The method `foo` has a parameter that uses a type
 * from a dependent module. Since Go "reimplments" this method, it will also need
 * to include an "import" statement for the calc-base module.
 *
 * @see https://github.com/aws/jsii/issues/2647
 */
class BaseFor2647 {
    constructor(very) {
        very.hey();
    }
    foo(obj) {
        obj.bar();
    }
}
exports.BaseFor2647 = BaseFor2647;
_d = JSII_RTTI_SYMBOL_1;
BaseFor2647[_d] = { fqn: "@scope/jsii-calc-lib.BaseFor2647", version: "0.0.0" };
exports.submodule = require("./submodule");
__exportStar(require("./duplicate-inherited-prop"), exports);
exports.deprecationRemoval = require("./deprecation-removal");
