import * as base from '@scope/jsii-calc-base';
import { Very } from '@scope/jsii-calc-base-of-base';
/**
 * Abstract class which represents a numeric value.
 */
export declare abstract class NumericValue extends base.Base {
    /**
     * The value.
     */
    abstract readonly value: number;
    /**
     * String representation of the value.
     */
    toString(): string;
}
/**
 * The general contract for a concrete number.
 */
export interface IDoublable {
    readonly doubleValue: number;
}
/**
 * Represents a concrete number.
 */
export declare class Number extends NumericValue implements IDoublable {
    readonly value: number;
    /**
     * Creates a Number object.
     * @param value The number.
     */
    constructor(value: number);
    /**
     * The number multiplied by 2.
     */
    get doubleValue(): number;
}
/**
 * Represents an operation on values.
 */
export declare abstract class Operation extends NumericValue {
    abstract toString(): string;
}
/**
 * Applies to classes that are considered friendly. These classes can be greeted with
 * a "hello" or "goodbye" blessing and they will respond back in a fun and friendly manner.
 */
export interface IFriendly {
    /**
     * Say hello!
     */
    hello(): string;
}
/**
 * This is the first struct we have created in jsii
 */
export interface MyFirstStruct {
    /**
     * A string value
     */
    readonly astring: string;
    /**
     * An awesome number value
     */
    readonly anumber: number;
    readonly firstOptional?: string[];
}
/**
 * This is a struct with only optional properties.
 */
export interface StructWithOnlyOptionals {
    /**
     * The first optional!
     */
    readonly optional1?: string;
    readonly optional2?: number;
    readonly optional3?: boolean;
}
/**
 * Check that enums from \@scoped packages can be references.
 * See awslabs/jsii#138
 */
export declare enum EnumFromScopedModule {
    VALUE1 = 0,
    VALUE2 = 1
}
/**
 * Interface that inherits from packages 2 levels up the tree
 *
 * Their presence validates that .NET/Java/jsii-reflect can track all fields
 * far enough up the tree.
 */
export interface IThreeLevelsInterface extends base.IBaseInterface {
    baz(): void;
}
/**
 * A base class for testing #2647. The method `foo` has a parameter that uses a type
 * from a dependent module. Since Go "reimplments" this method, it will also need
 * to include an "import" statement for the calc-base module.
 *
 * @see https://github.com/aws/jsii/issues/2647
 */
export declare class BaseFor2647 {
    constructor(very: Very);
    foo(obj: base.IBaseInterface): void;
}
export * as submodule from './submodule';
export * from './duplicate-inherited-prop';
export * as deprecationRemoval from './deprecation-removal';
