"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compare = exports.expectError = exports.expectNoError = void 0;
const jsii_1 = require("jsii");
const reflect = require("jsii-reflect");
const lib_1 = require("../lib");
function expectNoError(original, updated) {
    const mms = compare(original, updated);
    for (const msg of mms.messages()) {
        console.error(`- ${msg}`);
    }
    expect(mms.count).toBe(0);
}
exports.expectNoError = expectNoError;
function expectError(error, original, updated) {
    if (error == null) {
        expectNoError(original, updated);
        return;
    }
    const mms = compare(original, updated);
    expect(mms.count).not.toBe(0);
    const msgs = Array.from(mms.messages());
    if (!msgs.some((m) => error.test(m))) {
        expect(msgs.join(',')).toMatch(error);
    }
}
exports.expectError = expectError;
function compare(original, updated) {
    const ass1 = (0, jsii_1.sourceToAssemblyHelper)(original);
    const ts1 = new reflect.TypeSystem();
    const originalAssembly = ts1.addAssembly(new reflect.Assembly(ts1, ass1));
    const ass2 = (0, jsii_1.sourceToAssemblyHelper)(updated);
    const ts2 = new reflect.TypeSystem();
    const updatedAssembly = ts2.addAssembly(new reflect.Assembly(ts2, ass2));
    return (0, lib_1.compareAssemblies)(originalAssembly, updatedAssembly);
}
exports.compare = compare;
//# sourceMappingURL=util.js.map