"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CdkPipeline=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),codepipeline=require("../../../aws-codepipeline"),iam=require("../../../aws-iam"),core_1=require("../../../core"),constructs_1=require("constructs"),actions_1=require("./actions"),stage_1=require("./stage"),synths_1=require("./synths"),asset_type_1=require("../blueprint/asset-type"),docker_credentials_1=require("../docker-credentials"),application_security_check_1=require("../private/application-security-check"),asset_singleton_role_1=require("../private/asset-singleton-role"),cached_fnsub_1=require("../private/cached-fnsub"),cli_version_1=require("../private/cli-version"),construct_internals_1=require("../private/construct-internals"),CODE_BUILD_LENGTH_LIMIT=100;class CdkPipeline extends constructs_1.Construct{constructor(scope,id,props){if(super(scope,id),this._stages=[],this._outputArtifacts={},this.cliVersion=props.cdkCliVersion??cli_version_1.preferredCliVersion(),!core_1.App.isApp(this.node.root))throw new Error("CdkPipeline must be created under an App");this._cloudAssemblyArtifact=props.cloudAssemblyArtifact,this._dockerCredentials=props.dockerCredentials??[];const pipelineStack=core_1.Stack.of(this);if(props.codePipeline){if(props.pipelineName)throw new Error("Cannot set 'pipelineName' if an existing CodePipeline is given using 'codePipeline'");if(props.crossAccountKeys!==void 0)throw new Error("Cannot set 'crossAccountKeys' if an existing CodePipeline is given using 'codePipeline'");if(props.enableKeyRotation!==void 0)throw new Error("Cannot set 'enableKeyRotation' if an existing CodePipeline is given using 'codePipeline'");this._pipeline=props.codePipeline}else this._pipeline=new codepipeline.Pipeline(this,"Pipeline",{pipelineName:props.pipelineName,crossAccountKeys:props.crossAccountKeys,enableKeyRotation:props.enableKeyRotation,restartExecutionOnUpdate:!0});if(props.sourceAction&&!props.synthAction)throw new Error("When passing a 'sourceAction' you must also pass a 'synthAction' (or a 'codePipeline' that already has both)");if(!props.sourceAction&&(!props.codePipeline||props.codePipeline.stages.length<1))throw new Error("You must pass a 'sourceAction' (or a 'codePipeline' that already has a Source stage)");props.sourceAction&&this._pipeline.addStage({stageName:"Source",actions:[props.sourceAction]}),props.synthAction&&(props.synthAction instanceof synths_1.SimpleSynthAction&&this._dockerCredentials.length>0&&props.synthAction._addDockerCredentials(this._dockerCredentials),this._pipeline.addStage({stageName:"Build",actions:[props.synthAction]})),(props.selfMutating??!0)&&this._pipeline.addStage({stageName:"UpdatePipeline",actions:[new actions_1.UpdatePipelineAction(this,"UpdatePipeline",{cloudAssemblyInput:this._cloudAssemblyArtifact,pipelineStackHierarchicalId:pipelineStack.node.path,cdkCliVersion:this.cliVersion,projectName:maybeSuffix(props.pipelineName,"-selfupdate"),privileged:props.supportDockerAssets,dockerCredentials:this._dockerCredentials,buildSpec:props.selfMutationBuildSpec})]}),this._assets=new AssetPublishing(this,"Assets",{cloudAssemblyInput:this._cloudAssemblyArtifact,cdkCliVersion:this.cliVersion,pipeline:this._pipeline,projectName:maybeSuffix(props.pipelineName,"-publish"),vpc:props.vpc,subnetSelection:props.subnetSelection,singlePublisherPerType:props.singlePublisherPerType,preInstallCommands:props.assetPreInstallCommands,buildSpec:props.assetBuildSpec,dockerCredentials:this._dockerCredentials}),this.node.addValidation({validate:()=>this.validatePipeline()})}get codePipeline(){return this._pipeline}stage(stageName){return this._pipeline.stage(stageName)}_getApplicationSecurityCheck(){return this._applicationSecurityCheck||(this._applicationSecurityCheck=new application_security_check_1.ApplicationSecurityCheck(this,"PipelineApplicationSecurityCheck",{codePipeline:this._pipeline})),this._applicationSecurityCheck}addApplicationStage(appStage,options={}){const stage=this.addStage(appStage.stageName,options);return stage.addApplication(appStage,options),stage}addStage(stageName,options){const pipelineStage=this._pipeline.addStage({stageName}),stage=new stage_1.CdkStage(this,stageName,{cloudAssemblyArtifact:this._cloudAssemblyArtifact,pipelineStage,stageName,host:{publishAsset:this._assets.addPublishAssetAction.bind(this._assets),stackOutputArtifact:artifactId=>this._outputArtifacts[artifactId]},...options});return this._stages.push(stage),stage}stackOutput(cfnOutput){const stack=core_1.Stack.of(cfnOutput);if(!this._outputArtifacts[stack.artifactId]){const artifactName=`${stack.artifactId}_Outputs`,compactName=artifactName.slice(artifactName.length-Math.min(artifactName.length,CODE_BUILD_LENGTH_LIMIT));this._outputArtifacts[stack.artifactId]=new codepipeline.Artifact(compactName)}return new stage_1.StackOutput(this._outputArtifacts[stack.artifactId].atPath("outputs.json"),cfnOutput.logicalId)}validatePipeline(){const ret=new Array;return ret.push(...this.validateDeployOrder()),ret.push(...this.validateRequestedOutputs()),ret}get stackActions(){return flatMap(this._pipeline.stages,s=>s.actions.filter(isDeployAction))}*validateDeployOrder(){const stackActions=this.stackActions;for(const stackAction of stackActions)for(const depId of stackAction.dependencyStackArtifactIds){const depAction=stackActions.find(s=>s.stackArtifactId===depId);depAction===void 0?core_1.Annotations.of(this).addWarning(`Stack '${stackAction.stackName}' depends on stack '${depId}', but that dependency is not deployed through the pipeline!`):depAction.executeRunOrder<stackAction.prepareRunOrder||(yield`Stack '${stackAction.stackName}' depends on stack '${depAction.stackName}', but is deployed before it in the pipeline!`)}}*validateRequestedOutputs(){const artifactIds=this.stackActions.map(s=>s.stackArtifactId);for(const artifactId of Object.keys(this._outputArtifacts))artifactIds.includes(artifactId)||(yield`Trying to use outputs for Stack '${artifactId}', but Stack is not deployed in this pipeline. Add it to the pipeline.`)}}exports.CdkPipeline=CdkPipeline,_a=JSII_RTTI_SYMBOL_1,CdkPipeline[_a]={fqn:"aws-cdk-lib.pipelines.CdkPipeline",version:"2.69.0"};function isDeployAction(a){return a instanceof actions_1.DeployCdkStackAction}function flatMap(xs,f){return Array.prototype.concat([],...xs.map(f))}class AssetPublishing extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),this.props=props,this.MAX_PUBLISHERS_PER_STAGE=50,this.publishers={},this.assetRoles=new Map,this.assetAttachedPolicies={},this.cachedFnSub=new cached_fnsub_1.CachedFnSub,this.stages=[],this._fileAssetCtr=0,this._dockerAssetCtr=0,this.myCxAsmRoot=path.resolve(construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(this)).outdir),this.pipeline=this.props.pipeline;const stages=this.props.pipeline._stages;this.lastStageBeforePublishing=stages.slice(-1)[0],this.dockerCredentials=props.dockerCredentials}addPublishAssetAction(command){const relativePath=path.relative(this.myCxAsmRoot,command.assetManifestPath);if(relativePath.startsWith(`..${path.sep}`))throw new Error(`The asset manifest (${command.assetManifestPath}) cannot be outside the Cloud Assembly directory (${this.myCxAsmRoot}). Please report this error at https://github.com/aws/aws-cdk/issues to help us debug why this is happening.`);this.generateAssetRole(command.assetType).addAssumeRole(this.cachedFnSub.fnSub(command.assetPublishingRoleArn));const publisherKey=this.props.singlePublisherPerType?command.assetType.toString():command.assetId;let action=this.publishers[publisherKey];if(!action){const stageIndex=this.props.singlePublisherPerType?0:Math.floor((this._fileAssetCtr+this._dockerAssetCtr)/this.MAX_PUBLISHERS_PER_STAGE);if(!this.props.singlePublisherPerType&&stageIndex>=this.stages.length){const previousStage=this.stages.slice(-1)[0]??this.lastStageBeforePublishing;this.stages.push(this.pipeline.addStage({stageName:`Assets${stageIndex>0?stageIndex+1:""}`,placement:{justAfter:previousStage}}))}else this.props.singlePublisherPerType&&this.stages.length==0&&this.stages.push(this.pipeline.addStage({stageName:"Assets",placement:{justAfter:this.lastStageBeforePublishing}}));const id=this.props.singlePublisherPerType?command.assetType===asset_type_1.AssetType.FILE?"FileAsset":"DockerAsset":command.assetType===asset_type_1.AssetType.FILE?`FileAsset${++this._fileAssetCtr}`:`DockerAsset${++this._dockerAssetCtr}`,credsInstallCommands=docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.ASSET_PUBLISHING,this.dockerCredentials);action=this.publishers[publisherKey]=new actions_1.PublishAssetsAction(this,id,{actionName:id,cloudAssemblyInput:this.props.cloudAssemblyInput,cdkCliVersion:this.props.cdkCliVersion,assetType:command.assetType,role:this.assetRoles.get(command.assetType),dependable:this.assetAttachedPolicies[command.assetType],vpc:this.props.vpc,subnetSelection:this.props.subnetSelection,buildSpec:this.props.buildSpec,createBuildspecFile:this.props.singlePublisherPerType,preInstallCommands:[...this.props.preInstallCommands??[],...credsInstallCommands]}),this.stages[stageIndex].addAction(action)}action.addPublishCommand(relativePath,command.assetSelector)}generateAssetRole(assetType){const existing=this.assetRoles.get(assetType);if(existing)return existing;const rolePrefix=assetType===asset_type_1.AssetType.DOCKER_IMAGE?"Docker":"File",assetRole=new asset_singleton_role_1.AssetSingletonRole(this,`${rolePrefix}Role`,{roleName:core_1.PhysicalName.GENERATE_IF_NEEDED,assumedBy:new iam.CompositePrincipal(new iam.ServicePrincipal("codebuild.amazonaws.com"),new iam.AccountPrincipal(core_1.Stack.of(this).account))});return assetType===asset_type_1.AssetType.DOCKER_IMAGE&&this.dockerCredentials.forEach(reg=>reg.grantRead(assetRole,docker_credentials_1.DockerCredentialUsage.ASSET_PUBLISHING)),this.assetRoles.set(assetType,assetRole),assetRole}}function maybeSuffix(x,suffix){if(x!==void 0)return`${x}${suffix}`}
