"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnInput=exports.CfnDetectorModel=exports.CfnAlarmModel=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnAlarmModelPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("alarmCapabilities",CfnAlarmModel_AlarmCapabilitiesPropertyValidator)(properties.alarmCapabilities)),errors.collect(cdk.propertyValidator("alarmEventActions",CfnAlarmModel_AlarmEventActionsPropertyValidator)(properties.alarmEventActions)),errors.collect(cdk.propertyValidator("alarmModelDescription",cdk.validateString)(properties.alarmModelDescription)),errors.collect(cdk.propertyValidator("alarmModelName",cdk.validateString)(properties.alarmModelName)),errors.collect(cdk.propertyValidator("alarmRule",cdk.requiredValidator)(properties.alarmRule)),errors.collect(cdk.propertyValidator("alarmRule",CfnAlarmModel_AlarmRulePropertyValidator)(properties.alarmRule)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("severity",cdk.validateNumber)(properties.severity)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnAlarmModelProps"')}function cfnAlarmModelPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModelPropsValidator(properties).assertSuccess(),{AlarmRule:cfnAlarmModelAlarmRulePropertyToCloudFormation(properties.alarmRule),RoleArn:cdk.stringToCloudFormation(properties.roleArn),AlarmCapabilities:cfnAlarmModelAlarmCapabilitiesPropertyToCloudFormation(properties.alarmCapabilities),AlarmEventActions:cfnAlarmModelAlarmEventActionsPropertyToCloudFormation(properties.alarmEventActions),AlarmModelDescription:cdk.stringToCloudFormation(properties.alarmModelDescription),AlarmModelName:cdk.stringToCloudFormation(properties.alarmModelName),Key:cdk.stringToCloudFormation(properties.key),Severity:cdk.numberToCloudFormation(properties.severity),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnAlarmModelPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("alarmRule","AlarmRule",CfnAlarmModelAlarmRulePropertyFromCloudFormation(properties.AlarmRule)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("alarmCapabilities","AlarmCapabilities",properties.AlarmCapabilities!=null?CfnAlarmModelAlarmCapabilitiesPropertyFromCloudFormation(properties.AlarmCapabilities):void 0),ret.addPropertyResult("alarmEventActions","AlarmEventActions",properties.AlarmEventActions!=null?CfnAlarmModelAlarmEventActionsPropertyFromCloudFormation(properties.AlarmEventActions):void 0),ret.addPropertyResult("alarmModelDescription","AlarmModelDescription",properties.AlarmModelDescription!=null?cfn_parse.FromCloudFormation.getString(properties.AlarmModelDescription):void 0),ret.addPropertyResult("alarmModelName","AlarmModelName",properties.AlarmModelName!=null?cfn_parse.FromCloudFormation.getString(properties.AlarmModelName):void 0),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addPropertyResult("severity","Severity",properties.Severity!=null?cfn_parse.FromCloudFormation.getNumber(properties.Severity):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnAlarmModel extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnAlarmModel.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotevents_CfnAlarmModelProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnAlarmModel),error}cdk.requireProperty(props,"alarmRule",this),cdk.requireProperty(props,"roleArn",this),this.alarmRule=props.alarmRule,this.roleArn=props.roleArn,this.alarmCapabilities=props.alarmCapabilities,this.alarmEventActions=props.alarmEventActions,this.alarmModelDescription=props.alarmModelDescription,this.alarmModelName=props.alarmModelName,this.key=props.key,this.severity=props.severity,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTEvents::AlarmModel",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnAlarmModelPropsFromCloudFormation(resourceProperties),ret=new CfnAlarmModel(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnAlarmModel.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{alarmRule:this.alarmRule,roleArn:this.roleArn,alarmCapabilities:this.alarmCapabilities,alarmEventActions:this.alarmEventActions,alarmModelDescription:this.alarmModelDescription,alarmModelName:this.alarmModelName,key:this.key,severity:this.severity,tags:this.tags.renderTags()}}renderProperties(props){return cfnAlarmModelPropsToCloudFormation(props)}}exports.CfnAlarmModel=CfnAlarmModel,_a=JSII_RTTI_SYMBOL_1,CfnAlarmModel[_a]={fqn:"aws-cdk-lib.aws_iotevents.CfnAlarmModel",version:"2.69.0"},CfnAlarmModel.CFN_RESOURCE_TYPE_NAME="AWS::IoTEvents::AlarmModel";function CfnAlarmModel_AcknowledgeFlowPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.wrap('supplied properties not correct for "AcknowledgeFlowProperty"')}function cfnAlarmModelAcknowledgeFlowPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AcknowledgeFlowPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled)}):properties}function CfnAlarmModelAcknowledgeFlowPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AlarmActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dynamoDb",CfnAlarmModel_DynamoDBPropertyValidator)(properties.dynamoDb)),errors.collect(cdk.propertyValidator("dynamoDBv2",CfnAlarmModel_DynamoDBv2PropertyValidator)(properties.dynamoDBv2)),errors.collect(cdk.propertyValidator("firehose",CfnAlarmModel_FirehosePropertyValidator)(properties.firehose)),errors.collect(cdk.propertyValidator("iotEvents",CfnAlarmModel_IotEventsPropertyValidator)(properties.iotEvents)),errors.collect(cdk.propertyValidator("iotSiteWise",CfnAlarmModel_IotSiteWisePropertyValidator)(properties.iotSiteWise)),errors.collect(cdk.propertyValidator("iotTopicPublish",CfnAlarmModel_IotTopicPublishPropertyValidator)(properties.iotTopicPublish)),errors.collect(cdk.propertyValidator("lambda",CfnAlarmModel_LambdaPropertyValidator)(properties.lambda)),errors.collect(cdk.propertyValidator("sns",CfnAlarmModel_SnsPropertyValidator)(properties.sns)),errors.collect(cdk.propertyValidator("sqs",CfnAlarmModel_SqsPropertyValidator)(properties.sqs)),errors.wrap('supplied properties not correct for "AlarmActionProperty"')}function cfnAlarmModelAlarmActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AlarmActionPropertyValidator(properties).assertSuccess(),{DynamoDB:cfnAlarmModelDynamoDBPropertyToCloudFormation(properties.dynamoDb),DynamoDBv2:cfnAlarmModelDynamoDBv2PropertyToCloudFormation(properties.dynamoDBv2),Firehose:cfnAlarmModelFirehosePropertyToCloudFormation(properties.firehose),IotEvents:cfnAlarmModelIotEventsPropertyToCloudFormation(properties.iotEvents),IotSiteWise:cfnAlarmModelIotSiteWisePropertyToCloudFormation(properties.iotSiteWise),IotTopicPublish:cfnAlarmModelIotTopicPublishPropertyToCloudFormation(properties.iotTopicPublish),Lambda:cfnAlarmModelLambdaPropertyToCloudFormation(properties.lambda),Sns:cfnAlarmModelSnsPropertyToCloudFormation(properties.sns),Sqs:cfnAlarmModelSqsPropertyToCloudFormation(properties.sqs)}):properties}function CfnAlarmModelAlarmActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dynamoDb","DynamoDB",properties.DynamoDB!=null?CfnAlarmModelDynamoDBPropertyFromCloudFormation(properties.DynamoDB):void 0),ret.addPropertyResult("dynamoDBv2","DynamoDBv2",properties.DynamoDBv2!=null?CfnAlarmModelDynamoDBv2PropertyFromCloudFormation(properties.DynamoDBv2):void 0),ret.addPropertyResult("firehose","Firehose",properties.Firehose!=null?CfnAlarmModelFirehosePropertyFromCloudFormation(properties.Firehose):void 0),ret.addPropertyResult("iotEvents","IotEvents",properties.IotEvents!=null?CfnAlarmModelIotEventsPropertyFromCloudFormation(properties.IotEvents):void 0),ret.addPropertyResult("iotSiteWise","IotSiteWise",properties.IotSiteWise!=null?CfnAlarmModelIotSiteWisePropertyFromCloudFormation(properties.IotSiteWise):void 0),ret.addPropertyResult("iotTopicPublish","IotTopicPublish",properties.IotTopicPublish!=null?CfnAlarmModelIotTopicPublishPropertyFromCloudFormation(properties.IotTopicPublish):void 0),ret.addPropertyResult("lambda","Lambda",properties.Lambda!=null?CfnAlarmModelLambdaPropertyFromCloudFormation(properties.Lambda):void 0),ret.addPropertyResult("sns","Sns",properties.Sns!=null?CfnAlarmModelSnsPropertyFromCloudFormation(properties.Sns):void 0),ret.addPropertyResult("sqs","Sqs",properties.Sqs!=null?CfnAlarmModelSqsPropertyFromCloudFormation(properties.Sqs):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AlarmCapabilitiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("acknowledgeFlow",CfnAlarmModel_AcknowledgeFlowPropertyValidator)(properties.acknowledgeFlow)),errors.collect(cdk.propertyValidator("initializationConfiguration",CfnAlarmModel_InitializationConfigurationPropertyValidator)(properties.initializationConfiguration)),errors.wrap('supplied properties not correct for "AlarmCapabilitiesProperty"')}function cfnAlarmModelAlarmCapabilitiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AlarmCapabilitiesPropertyValidator(properties).assertSuccess(),{AcknowledgeFlow:cfnAlarmModelAcknowledgeFlowPropertyToCloudFormation(properties.acknowledgeFlow),InitializationConfiguration:cfnAlarmModelInitializationConfigurationPropertyToCloudFormation(properties.initializationConfiguration)}):properties}function CfnAlarmModelAlarmCapabilitiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("acknowledgeFlow","AcknowledgeFlow",properties.AcknowledgeFlow!=null?CfnAlarmModelAcknowledgeFlowPropertyFromCloudFormation(properties.AcknowledgeFlow):void 0),ret.addPropertyResult("initializationConfiguration","InitializationConfiguration",properties.InitializationConfiguration!=null?CfnAlarmModelInitializationConfigurationPropertyFromCloudFormation(properties.InitializationConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AlarmEventActionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("alarmActions",cdk.listValidator(CfnAlarmModel_AlarmActionPropertyValidator))(properties.alarmActions)),errors.wrap('supplied properties not correct for "AlarmEventActionsProperty"')}function cfnAlarmModelAlarmEventActionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AlarmEventActionsPropertyValidator(properties).assertSuccess(),{AlarmActions:cdk.listMapper(cfnAlarmModelAlarmActionPropertyToCloudFormation)(properties.alarmActions)}):properties}function CfnAlarmModelAlarmEventActionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("alarmActions","AlarmActions",properties.AlarmActions!=null?cfn_parse.FromCloudFormation.getArray(CfnAlarmModelAlarmActionPropertyFromCloudFormation)(properties.AlarmActions):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AlarmRulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("simpleRule",CfnAlarmModel_SimpleRulePropertyValidator)(properties.simpleRule)),errors.wrap('supplied properties not correct for "AlarmRuleProperty"')}function cfnAlarmModelAlarmRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AlarmRulePropertyValidator(properties).assertSuccess(),{SimpleRule:cfnAlarmModelSimpleRulePropertyToCloudFormation(properties.simpleRule)}):properties}function CfnAlarmModelAlarmRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("simpleRule","SimpleRule",properties.SimpleRule!=null?CfnAlarmModelSimpleRulePropertyFromCloudFormation(properties.SimpleRule):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AssetPropertyTimestampPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("offsetInNanos",cdk.validateString)(properties.offsetInNanos)),errors.collect(cdk.propertyValidator("timeInSeconds",cdk.requiredValidator)(properties.timeInSeconds)),errors.collect(cdk.propertyValidator("timeInSeconds",cdk.validateString)(properties.timeInSeconds)),errors.wrap('supplied properties not correct for "AssetPropertyTimestampProperty"')}function cfnAlarmModelAssetPropertyTimestampPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AssetPropertyTimestampPropertyValidator(properties).assertSuccess(),{OffsetInNanos:cdk.stringToCloudFormation(properties.offsetInNanos),TimeInSeconds:cdk.stringToCloudFormation(properties.timeInSeconds)}):properties}function CfnAlarmModelAssetPropertyTimestampPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("offsetInNanos","OffsetInNanos",properties.OffsetInNanos!=null?cfn_parse.FromCloudFormation.getString(properties.OffsetInNanos):void 0),ret.addPropertyResult("timeInSeconds","TimeInSeconds",cfn_parse.FromCloudFormation.getString(properties.TimeInSeconds)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AssetPropertyValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("quality",cdk.validateString)(properties.quality)),errors.collect(cdk.propertyValidator("timestamp",CfnAlarmModel_AssetPropertyTimestampPropertyValidator)(properties.timestamp)),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",CfnAlarmModel_AssetPropertyVariantPropertyValidator)(properties.value)),errors.wrap('supplied properties not correct for "AssetPropertyValueProperty"')}function cfnAlarmModelAssetPropertyValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AssetPropertyValuePropertyValidator(properties).assertSuccess(),{Quality:cdk.stringToCloudFormation(properties.quality),Timestamp:cfnAlarmModelAssetPropertyTimestampPropertyToCloudFormation(properties.timestamp),Value:cfnAlarmModelAssetPropertyVariantPropertyToCloudFormation(properties.value)}):properties}function CfnAlarmModelAssetPropertyValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("quality","Quality",properties.Quality!=null?cfn_parse.FromCloudFormation.getString(properties.Quality):void 0),ret.addPropertyResult("timestamp","Timestamp",properties.Timestamp!=null?CfnAlarmModelAssetPropertyTimestampPropertyFromCloudFormation(properties.Timestamp):void 0),ret.addPropertyResult("value","Value",CfnAlarmModelAssetPropertyVariantPropertyFromCloudFormation(properties.Value)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_AssetPropertyVariantPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("booleanValue",cdk.validateString)(properties.booleanValue)),errors.collect(cdk.propertyValidator("doubleValue",cdk.validateString)(properties.doubleValue)),errors.collect(cdk.propertyValidator("integerValue",cdk.validateString)(properties.integerValue)),errors.collect(cdk.propertyValidator("stringValue",cdk.validateString)(properties.stringValue)),errors.wrap('supplied properties not correct for "AssetPropertyVariantProperty"')}function cfnAlarmModelAssetPropertyVariantPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_AssetPropertyVariantPropertyValidator(properties).assertSuccess(),{BooleanValue:cdk.stringToCloudFormation(properties.booleanValue),DoubleValue:cdk.stringToCloudFormation(properties.doubleValue),IntegerValue:cdk.stringToCloudFormation(properties.integerValue),StringValue:cdk.stringToCloudFormation(properties.stringValue)}):properties}function CfnAlarmModelAssetPropertyVariantPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("booleanValue","BooleanValue",properties.BooleanValue!=null?cfn_parse.FromCloudFormation.getString(properties.BooleanValue):void 0),ret.addPropertyResult("doubleValue","DoubleValue",properties.DoubleValue!=null?cfn_parse.FromCloudFormation.getString(properties.DoubleValue):void 0),ret.addPropertyResult("integerValue","IntegerValue",properties.IntegerValue!=null?cfn_parse.FromCloudFormation.getString(properties.IntegerValue):void 0),ret.addPropertyResult("stringValue","StringValue",properties.StringValue!=null?cfn_parse.FromCloudFormation.getString(properties.StringValue):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_DynamoDBPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("hashKeyField",cdk.requiredValidator)(properties.hashKeyField)),errors.collect(cdk.propertyValidator("hashKeyField",cdk.validateString)(properties.hashKeyField)),errors.collect(cdk.propertyValidator("hashKeyType",cdk.validateString)(properties.hashKeyType)),errors.collect(cdk.propertyValidator("hashKeyValue",cdk.requiredValidator)(properties.hashKeyValue)),errors.collect(cdk.propertyValidator("hashKeyValue",cdk.validateString)(properties.hashKeyValue)),errors.collect(cdk.propertyValidator("operation",cdk.validateString)(properties.operation)),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("payloadField",cdk.validateString)(properties.payloadField)),errors.collect(cdk.propertyValidator("rangeKeyField",cdk.validateString)(properties.rangeKeyField)),errors.collect(cdk.propertyValidator("rangeKeyType",cdk.validateString)(properties.rangeKeyType)),errors.collect(cdk.propertyValidator("rangeKeyValue",cdk.validateString)(properties.rangeKeyValue)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "DynamoDBProperty"')}function cfnAlarmModelDynamoDBPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_DynamoDBPropertyValidator(properties).assertSuccess(),{HashKeyField:cdk.stringToCloudFormation(properties.hashKeyField),HashKeyType:cdk.stringToCloudFormation(properties.hashKeyType),HashKeyValue:cdk.stringToCloudFormation(properties.hashKeyValue),Operation:cdk.stringToCloudFormation(properties.operation),Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload),PayloadField:cdk.stringToCloudFormation(properties.payloadField),RangeKeyField:cdk.stringToCloudFormation(properties.rangeKeyField),RangeKeyType:cdk.stringToCloudFormation(properties.rangeKeyType),RangeKeyValue:cdk.stringToCloudFormation(properties.rangeKeyValue),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnAlarmModelDynamoDBPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("hashKeyField","HashKeyField",cfn_parse.FromCloudFormation.getString(properties.HashKeyField)),ret.addPropertyResult("hashKeyType","HashKeyType",properties.HashKeyType!=null?cfn_parse.FromCloudFormation.getString(properties.HashKeyType):void 0),ret.addPropertyResult("hashKeyValue","HashKeyValue",cfn_parse.FromCloudFormation.getString(properties.HashKeyValue)),ret.addPropertyResult("operation","Operation",properties.Operation!=null?cfn_parse.FromCloudFormation.getString(properties.Operation):void 0),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("payloadField","PayloadField",properties.PayloadField!=null?cfn_parse.FromCloudFormation.getString(properties.PayloadField):void 0),ret.addPropertyResult("rangeKeyField","RangeKeyField",properties.RangeKeyField!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyField):void 0),ret.addPropertyResult("rangeKeyType","RangeKeyType",properties.RangeKeyType!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyType):void 0),ret.addPropertyResult("rangeKeyValue","RangeKeyValue",properties.RangeKeyValue!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyValue):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_DynamoDBv2PropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "DynamoDBv2Property"')}function cfnAlarmModelDynamoDBv2PropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_DynamoDBv2PropertyValidator(properties).assertSuccess(),{Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnAlarmModelDynamoDBv2PropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_FirehosePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("deliveryStreamName",cdk.requiredValidator)(properties.deliveryStreamName)),errors.collect(cdk.propertyValidator("deliveryStreamName",cdk.validateString)(properties.deliveryStreamName)),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("separator",cdk.validateString)(properties.separator)),errors.wrap('supplied properties not correct for "FirehoseProperty"')}function cfnAlarmModelFirehosePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_FirehosePropertyValidator(properties).assertSuccess(),{DeliveryStreamName:cdk.stringToCloudFormation(properties.deliveryStreamName),Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload),Separator:cdk.stringToCloudFormation(properties.separator)}):properties}function CfnAlarmModelFirehosePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("deliveryStreamName","DeliveryStreamName",cfn_parse.FromCloudFormation.getString(properties.DeliveryStreamName)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("separator","Separator",properties.Separator!=null?cfn_parse.FromCloudFormation.getString(properties.Separator):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_InitializationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("disabledOnInitialization",cdk.requiredValidator)(properties.disabledOnInitialization)),errors.collect(cdk.propertyValidator("disabledOnInitialization",cdk.validateBoolean)(properties.disabledOnInitialization)),errors.wrap('supplied properties not correct for "InitializationConfigurationProperty"')}function cfnAlarmModelInitializationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_InitializationConfigurationPropertyValidator(properties).assertSuccess(),{DisabledOnInitialization:cdk.booleanToCloudFormation(properties.disabledOnInitialization)}):properties}function CfnAlarmModelInitializationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("disabledOnInitialization","DisabledOnInitialization",cfn_parse.FromCloudFormation.getBoolean(properties.DisabledOnInitialization)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_IotEventsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputName",cdk.requiredValidator)(properties.inputName)),errors.collect(cdk.propertyValidator("inputName",cdk.validateString)(properties.inputName)),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "IotEventsProperty"')}function cfnAlarmModelIotEventsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_IotEventsPropertyValidator(properties).assertSuccess(),{InputName:cdk.stringToCloudFormation(properties.inputName),Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnAlarmModelIotEventsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputName","InputName",cfn_parse.FromCloudFormation.getString(properties.InputName)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_IotSiteWisePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("assetId",cdk.validateString)(properties.assetId)),errors.collect(cdk.propertyValidator("entryId",cdk.validateString)(properties.entryId)),errors.collect(cdk.propertyValidator("propertyAlias",cdk.validateString)(properties.propertyAlias)),errors.collect(cdk.propertyValidator("propertyId",cdk.validateString)(properties.propertyId)),errors.collect(cdk.propertyValidator("propertyValue",CfnAlarmModel_AssetPropertyValuePropertyValidator)(properties.propertyValue)),errors.wrap('supplied properties not correct for "IotSiteWiseProperty"')}function cfnAlarmModelIotSiteWisePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_IotSiteWisePropertyValidator(properties).assertSuccess(),{AssetId:cdk.stringToCloudFormation(properties.assetId),EntryId:cdk.stringToCloudFormation(properties.entryId),PropertyAlias:cdk.stringToCloudFormation(properties.propertyAlias),PropertyId:cdk.stringToCloudFormation(properties.propertyId),PropertyValue:cfnAlarmModelAssetPropertyValuePropertyToCloudFormation(properties.propertyValue)}):properties}function CfnAlarmModelIotSiteWisePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("assetId","AssetId",properties.AssetId!=null?cfn_parse.FromCloudFormation.getString(properties.AssetId):void 0),ret.addPropertyResult("entryId","EntryId",properties.EntryId!=null?cfn_parse.FromCloudFormation.getString(properties.EntryId):void 0),ret.addPropertyResult("propertyAlias","PropertyAlias",properties.PropertyAlias!=null?cfn_parse.FromCloudFormation.getString(properties.PropertyAlias):void 0),ret.addPropertyResult("propertyId","PropertyId",properties.PropertyId!=null?cfn_parse.FromCloudFormation.getString(properties.PropertyId):void 0),ret.addPropertyResult("propertyValue","PropertyValue",properties.PropertyValue!=null?CfnAlarmModelAssetPropertyValuePropertyFromCloudFormation(properties.PropertyValue):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_IotTopicPublishPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mqttTopic",cdk.requiredValidator)(properties.mqttTopic)),errors.collect(cdk.propertyValidator("mqttTopic",cdk.validateString)(properties.mqttTopic)),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "IotTopicPublishProperty"')}function cfnAlarmModelIotTopicPublishPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_IotTopicPublishPropertyValidator(properties).assertSuccess(),{MqttTopic:cdk.stringToCloudFormation(properties.mqttTopic),Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnAlarmModelIotTopicPublishPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mqttTopic","MqttTopic",cfn_parse.FromCloudFormation.getString(properties.MqttTopic)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_LambdaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("functionArn",cdk.requiredValidator)(properties.functionArn)),errors.collect(cdk.propertyValidator("functionArn",cdk.validateString)(properties.functionArn)),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "LambdaProperty"')}function cfnAlarmModelLambdaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_LambdaPropertyValidator(properties).assertSuccess(),{FunctionArn:cdk.stringToCloudFormation(properties.functionArn),Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnAlarmModelLambdaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("functionArn","FunctionArn",cfn_parse.FromCloudFormation.getString(properties.FunctionArn)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_PayloadPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("contentExpression",cdk.requiredValidator)(properties.contentExpression)),errors.collect(cdk.propertyValidator("contentExpression",cdk.validateString)(properties.contentExpression)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "PayloadProperty"')}function cfnAlarmModelPayloadPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_PayloadPropertyValidator(properties).assertSuccess(),{ContentExpression:cdk.stringToCloudFormation(properties.contentExpression),Type:cdk.stringToCloudFormation(properties.type)}):properties}function CfnAlarmModelPayloadPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("contentExpression","ContentExpression",cfn_parse.FromCloudFormation.getString(properties.ContentExpression)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_SimpleRulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("comparisonOperator",cdk.requiredValidator)(properties.comparisonOperator)),errors.collect(cdk.propertyValidator("comparisonOperator",cdk.validateString)(properties.comparisonOperator)),errors.collect(cdk.propertyValidator("inputProperty",cdk.requiredValidator)(properties.inputProperty)),errors.collect(cdk.propertyValidator("inputProperty",cdk.validateString)(properties.inputProperty)),errors.collect(cdk.propertyValidator("threshold",cdk.requiredValidator)(properties.threshold)),errors.collect(cdk.propertyValidator("threshold",cdk.validateString)(properties.threshold)),errors.wrap('supplied properties not correct for "SimpleRuleProperty"')}function cfnAlarmModelSimpleRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_SimpleRulePropertyValidator(properties).assertSuccess(),{ComparisonOperator:cdk.stringToCloudFormation(properties.comparisonOperator),InputProperty:cdk.stringToCloudFormation(properties.inputProperty),Threshold:cdk.stringToCloudFormation(properties.threshold)}):properties}function CfnAlarmModelSimpleRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("comparisonOperator","ComparisonOperator",cfn_parse.FromCloudFormation.getString(properties.ComparisonOperator)),ret.addPropertyResult("inputProperty","InputProperty",cfn_parse.FromCloudFormation.getString(properties.InputProperty)),ret.addPropertyResult("threshold","Threshold",cfn_parse.FromCloudFormation.getString(properties.Threshold)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_SnsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("targetArn",cdk.requiredValidator)(properties.targetArn)),errors.collect(cdk.propertyValidator("targetArn",cdk.validateString)(properties.targetArn)),errors.wrap('supplied properties not correct for "SnsProperty"')}function cfnAlarmModelSnsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_SnsPropertyValidator(properties).assertSuccess(),{Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload),TargetArn:cdk.stringToCloudFormation(properties.targetArn)}):properties}function CfnAlarmModelSnsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("targetArn","TargetArn",cfn_parse.FromCloudFormation.getString(properties.TargetArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAlarmModel_SqsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnAlarmModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("queueUrl",cdk.requiredValidator)(properties.queueUrl)),errors.collect(cdk.propertyValidator("queueUrl",cdk.validateString)(properties.queueUrl)),errors.collect(cdk.propertyValidator("useBase64",cdk.validateBoolean)(properties.useBase64)),errors.wrap('supplied properties not correct for "SqsProperty"')}function cfnAlarmModelSqsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAlarmModel_SqsPropertyValidator(properties).assertSuccess(),{Payload:cfnAlarmModelPayloadPropertyToCloudFormation(properties.payload),QueueUrl:cdk.stringToCloudFormation(properties.queueUrl),UseBase64:cdk.booleanToCloudFormation(properties.useBase64)}):properties}function CfnAlarmModelSqsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnAlarmModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("queueUrl","QueueUrl",cfn_parse.FromCloudFormation.getString(properties.QueueUrl)),ret.addPropertyResult("useBase64","UseBase64",properties.UseBase64!=null?cfn_parse.FromCloudFormation.getBoolean(properties.UseBase64):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModelPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("detectorModelDefinition",cdk.requiredValidator)(properties.detectorModelDefinition)),errors.collect(cdk.propertyValidator("detectorModelDefinition",CfnDetectorModel_DetectorModelDefinitionPropertyValidator)(properties.detectorModelDefinition)),errors.collect(cdk.propertyValidator("detectorModelDescription",cdk.validateString)(properties.detectorModelDescription)),errors.collect(cdk.propertyValidator("detectorModelName",cdk.validateString)(properties.detectorModelName)),errors.collect(cdk.propertyValidator("evaluationMethod",cdk.validateString)(properties.evaluationMethod)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDetectorModelProps"')}function cfnDetectorModelPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModelPropsValidator(properties).assertSuccess(),{DetectorModelDefinition:cfnDetectorModelDetectorModelDefinitionPropertyToCloudFormation(properties.detectorModelDefinition),RoleArn:cdk.stringToCloudFormation(properties.roleArn),DetectorModelDescription:cdk.stringToCloudFormation(properties.detectorModelDescription),DetectorModelName:cdk.stringToCloudFormation(properties.detectorModelName),EvaluationMethod:cdk.stringToCloudFormation(properties.evaluationMethod),Key:cdk.stringToCloudFormation(properties.key),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDetectorModelPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("detectorModelDefinition","DetectorModelDefinition",CfnDetectorModelDetectorModelDefinitionPropertyFromCloudFormation(properties.DetectorModelDefinition)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("detectorModelDescription","DetectorModelDescription",properties.DetectorModelDescription!=null?cfn_parse.FromCloudFormation.getString(properties.DetectorModelDescription):void 0),ret.addPropertyResult("detectorModelName","DetectorModelName",properties.DetectorModelName!=null?cfn_parse.FromCloudFormation.getString(properties.DetectorModelName):void 0),ret.addPropertyResult("evaluationMethod","EvaluationMethod",properties.EvaluationMethod!=null?cfn_parse.FromCloudFormation.getString(properties.EvaluationMethod):void 0),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDetectorModel extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnDetectorModel.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotevents_CfnDetectorModelProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDetectorModel),error}cdk.requireProperty(props,"detectorModelDefinition",this),cdk.requireProperty(props,"roleArn",this),this.detectorModelDefinition=props.detectorModelDefinition,this.roleArn=props.roleArn,this.detectorModelDescription=props.detectorModelDescription,this.detectorModelName=props.detectorModelName,this.evaluationMethod=props.evaluationMethod,this.key=props.key,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTEvents::DetectorModel",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDetectorModelPropsFromCloudFormation(resourceProperties),ret=new CfnDetectorModel(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDetectorModel.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{detectorModelDefinition:this.detectorModelDefinition,roleArn:this.roleArn,detectorModelDescription:this.detectorModelDescription,detectorModelName:this.detectorModelName,evaluationMethod:this.evaluationMethod,key:this.key,tags:this.tags.renderTags()}}renderProperties(props){return cfnDetectorModelPropsToCloudFormation(props)}}exports.CfnDetectorModel=CfnDetectorModel,_b=JSII_RTTI_SYMBOL_1,CfnDetectorModel[_b]={fqn:"aws-cdk-lib.aws_iotevents.CfnDetectorModel",version:"2.69.0"},CfnDetectorModel.CFN_RESOURCE_TYPE_NAME="AWS::IoTEvents::DetectorModel";function CfnDetectorModel_ActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("clearTimer",CfnDetectorModel_ClearTimerPropertyValidator)(properties.clearTimer)),errors.collect(cdk.propertyValidator("dynamoDb",CfnDetectorModel_DynamoDBPropertyValidator)(properties.dynamoDb)),errors.collect(cdk.propertyValidator("dynamoDBv2",CfnDetectorModel_DynamoDBv2PropertyValidator)(properties.dynamoDBv2)),errors.collect(cdk.propertyValidator("firehose",CfnDetectorModel_FirehosePropertyValidator)(properties.firehose)),errors.collect(cdk.propertyValidator("iotEvents",CfnDetectorModel_IotEventsPropertyValidator)(properties.iotEvents)),errors.collect(cdk.propertyValidator("iotSiteWise",CfnDetectorModel_IotSiteWisePropertyValidator)(properties.iotSiteWise)),errors.collect(cdk.propertyValidator("iotTopicPublish",CfnDetectorModel_IotTopicPublishPropertyValidator)(properties.iotTopicPublish)),errors.collect(cdk.propertyValidator("lambda",CfnDetectorModel_LambdaPropertyValidator)(properties.lambda)),errors.collect(cdk.propertyValidator("resetTimer",CfnDetectorModel_ResetTimerPropertyValidator)(properties.resetTimer)),errors.collect(cdk.propertyValidator("setTimer",CfnDetectorModel_SetTimerPropertyValidator)(properties.setTimer)),errors.collect(cdk.propertyValidator("setVariable",CfnDetectorModel_SetVariablePropertyValidator)(properties.setVariable)),errors.collect(cdk.propertyValidator("sns",CfnDetectorModel_SnsPropertyValidator)(properties.sns)),errors.collect(cdk.propertyValidator("sqs",CfnDetectorModel_SqsPropertyValidator)(properties.sqs)),errors.wrap('supplied properties not correct for "ActionProperty"')}function cfnDetectorModelActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_ActionPropertyValidator(properties).assertSuccess(),{ClearTimer:cfnDetectorModelClearTimerPropertyToCloudFormation(properties.clearTimer),DynamoDB:cfnDetectorModelDynamoDBPropertyToCloudFormation(properties.dynamoDb),DynamoDBv2:cfnDetectorModelDynamoDBv2PropertyToCloudFormation(properties.dynamoDBv2),Firehose:cfnDetectorModelFirehosePropertyToCloudFormation(properties.firehose),IotEvents:cfnDetectorModelIotEventsPropertyToCloudFormation(properties.iotEvents),IotSiteWise:cfnDetectorModelIotSiteWisePropertyToCloudFormation(properties.iotSiteWise),IotTopicPublish:cfnDetectorModelIotTopicPublishPropertyToCloudFormation(properties.iotTopicPublish),Lambda:cfnDetectorModelLambdaPropertyToCloudFormation(properties.lambda),ResetTimer:cfnDetectorModelResetTimerPropertyToCloudFormation(properties.resetTimer),SetTimer:cfnDetectorModelSetTimerPropertyToCloudFormation(properties.setTimer),SetVariable:cfnDetectorModelSetVariablePropertyToCloudFormation(properties.setVariable),Sns:cfnDetectorModelSnsPropertyToCloudFormation(properties.sns),Sqs:cfnDetectorModelSqsPropertyToCloudFormation(properties.sqs)}):properties}function CfnDetectorModelActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("clearTimer","ClearTimer",properties.ClearTimer!=null?CfnDetectorModelClearTimerPropertyFromCloudFormation(properties.ClearTimer):void 0),ret.addPropertyResult("dynamoDb","DynamoDB",properties.DynamoDB!=null?CfnDetectorModelDynamoDBPropertyFromCloudFormation(properties.DynamoDB):void 0),ret.addPropertyResult("dynamoDBv2","DynamoDBv2",properties.DynamoDBv2!=null?CfnDetectorModelDynamoDBv2PropertyFromCloudFormation(properties.DynamoDBv2):void 0),ret.addPropertyResult("firehose","Firehose",properties.Firehose!=null?CfnDetectorModelFirehosePropertyFromCloudFormation(properties.Firehose):void 0),ret.addPropertyResult("iotEvents","IotEvents",properties.IotEvents!=null?CfnDetectorModelIotEventsPropertyFromCloudFormation(properties.IotEvents):void 0),ret.addPropertyResult("iotSiteWise","IotSiteWise",properties.IotSiteWise!=null?CfnDetectorModelIotSiteWisePropertyFromCloudFormation(properties.IotSiteWise):void 0),ret.addPropertyResult("iotTopicPublish","IotTopicPublish",properties.IotTopicPublish!=null?CfnDetectorModelIotTopicPublishPropertyFromCloudFormation(properties.IotTopicPublish):void 0),ret.addPropertyResult("lambda","Lambda",properties.Lambda!=null?CfnDetectorModelLambdaPropertyFromCloudFormation(properties.Lambda):void 0),ret.addPropertyResult("resetTimer","ResetTimer",properties.ResetTimer!=null?CfnDetectorModelResetTimerPropertyFromCloudFormation(properties.ResetTimer):void 0),ret.addPropertyResult("setTimer","SetTimer",properties.SetTimer!=null?CfnDetectorModelSetTimerPropertyFromCloudFormation(properties.SetTimer):void 0),ret.addPropertyResult("setVariable","SetVariable",properties.SetVariable!=null?CfnDetectorModelSetVariablePropertyFromCloudFormation(properties.SetVariable):void 0),ret.addPropertyResult("sns","Sns",properties.Sns!=null?CfnDetectorModelSnsPropertyFromCloudFormation(properties.Sns):void 0),ret.addPropertyResult("sqs","Sqs",properties.Sqs!=null?CfnDetectorModelSqsPropertyFromCloudFormation(properties.Sqs):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_AssetPropertyTimestampPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("offsetInNanos",cdk.validateString)(properties.offsetInNanos)),errors.collect(cdk.propertyValidator("timeInSeconds",cdk.requiredValidator)(properties.timeInSeconds)),errors.collect(cdk.propertyValidator("timeInSeconds",cdk.validateString)(properties.timeInSeconds)),errors.wrap('supplied properties not correct for "AssetPropertyTimestampProperty"')}function cfnDetectorModelAssetPropertyTimestampPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_AssetPropertyTimestampPropertyValidator(properties).assertSuccess(),{OffsetInNanos:cdk.stringToCloudFormation(properties.offsetInNanos),TimeInSeconds:cdk.stringToCloudFormation(properties.timeInSeconds)}):properties}function CfnDetectorModelAssetPropertyTimestampPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("offsetInNanos","OffsetInNanos",properties.OffsetInNanos!=null?cfn_parse.FromCloudFormation.getString(properties.OffsetInNanos):void 0),ret.addPropertyResult("timeInSeconds","TimeInSeconds",cfn_parse.FromCloudFormation.getString(properties.TimeInSeconds)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_AssetPropertyValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("quality",cdk.validateString)(properties.quality)),errors.collect(cdk.propertyValidator("timestamp",CfnDetectorModel_AssetPropertyTimestampPropertyValidator)(properties.timestamp)),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",CfnDetectorModel_AssetPropertyVariantPropertyValidator)(properties.value)),errors.wrap('supplied properties not correct for "AssetPropertyValueProperty"')}function cfnDetectorModelAssetPropertyValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_AssetPropertyValuePropertyValidator(properties).assertSuccess(),{Quality:cdk.stringToCloudFormation(properties.quality),Timestamp:cfnDetectorModelAssetPropertyTimestampPropertyToCloudFormation(properties.timestamp),Value:cfnDetectorModelAssetPropertyVariantPropertyToCloudFormation(properties.value)}):properties}function CfnDetectorModelAssetPropertyValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("quality","Quality",properties.Quality!=null?cfn_parse.FromCloudFormation.getString(properties.Quality):void 0),ret.addPropertyResult("timestamp","Timestamp",properties.Timestamp!=null?CfnDetectorModelAssetPropertyTimestampPropertyFromCloudFormation(properties.Timestamp):void 0),ret.addPropertyResult("value","Value",CfnDetectorModelAssetPropertyVariantPropertyFromCloudFormation(properties.Value)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_AssetPropertyVariantPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("booleanValue",cdk.validateString)(properties.booleanValue)),errors.collect(cdk.propertyValidator("doubleValue",cdk.validateString)(properties.doubleValue)),errors.collect(cdk.propertyValidator("integerValue",cdk.validateString)(properties.integerValue)),errors.collect(cdk.propertyValidator("stringValue",cdk.validateString)(properties.stringValue)),errors.wrap('supplied properties not correct for "AssetPropertyVariantProperty"')}function cfnDetectorModelAssetPropertyVariantPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_AssetPropertyVariantPropertyValidator(properties).assertSuccess(),{BooleanValue:cdk.stringToCloudFormation(properties.booleanValue),DoubleValue:cdk.stringToCloudFormation(properties.doubleValue),IntegerValue:cdk.stringToCloudFormation(properties.integerValue),StringValue:cdk.stringToCloudFormation(properties.stringValue)}):properties}function CfnDetectorModelAssetPropertyVariantPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("booleanValue","BooleanValue",properties.BooleanValue!=null?cfn_parse.FromCloudFormation.getString(properties.BooleanValue):void 0),ret.addPropertyResult("doubleValue","DoubleValue",properties.DoubleValue!=null?cfn_parse.FromCloudFormation.getString(properties.DoubleValue):void 0),ret.addPropertyResult("integerValue","IntegerValue",properties.IntegerValue!=null?cfn_parse.FromCloudFormation.getString(properties.IntegerValue):void 0),ret.addPropertyResult("stringValue","StringValue",properties.StringValue!=null?cfn_parse.FromCloudFormation.getString(properties.StringValue):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_ClearTimerPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("timerName",cdk.requiredValidator)(properties.timerName)),errors.collect(cdk.propertyValidator("timerName",cdk.validateString)(properties.timerName)),errors.wrap('supplied properties not correct for "ClearTimerProperty"')}function cfnDetectorModelClearTimerPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_ClearTimerPropertyValidator(properties).assertSuccess(),{TimerName:cdk.stringToCloudFormation(properties.timerName)}):properties}function CfnDetectorModelClearTimerPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("timerName","TimerName",cfn_parse.FromCloudFormation.getString(properties.TimerName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_DetectorModelDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("initialStateName",cdk.requiredValidator)(properties.initialStateName)),errors.collect(cdk.propertyValidator("initialStateName",cdk.validateString)(properties.initialStateName)),errors.collect(cdk.propertyValidator("states",cdk.requiredValidator)(properties.states)),errors.collect(cdk.propertyValidator("states",cdk.listValidator(CfnDetectorModel_StatePropertyValidator))(properties.states)),errors.wrap('supplied properties not correct for "DetectorModelDefinitionProperty"')}function cfnDetectorModelDetectorModelDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_DetectorModelDefinitionPropertyValidator(properties).assertSuccess(),{InitialStateName:cdk.stringToCloudFormation(properties.initialStateName),States:cdk.listMapper(cfnDetectorModelStatePropertyToCloudFormation)(properties.states)}):properties}function CfnDetectorModelDetectorModelDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("initialStateName","InitialStateName",cfn_parse.FromCloudFormation.getString(properties.InitialStateName)),ret.addPropertyResult("states","States",cfn_parse.FromCloudFormation.getArray(CfnDetectorModelStatePropertyFromCloudFormation)(properties.States)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_DynamoDBPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("hashKeyField",cdk.requiredValidator)(properties.hashKeyField)),errors.collect(cdk.propertyValidator("hashKeyField",cdk.validateString)(properties.hashKeyField)),errors.collect(cdk.propertyValidator("hashKeyType",cdk.validateString)(properties.hashKeyType)),errors.collect(cdk.propertyValidator("hashKeyValue",cdk.requiredValidator)(properties.hashKeyValue)),errors.collect(cdk.propertyValidator("hashKeyValue",cdk.validateString)(properties.hashKeyValue)),errors.collect(cdk.propertyValidator("operation",cdk.validateString)(properties.operation)),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("payloadField",cdk.validateString)(properties.payloadField)),errors.collect(cdk.propertyValidator("rangeKeyField",cdk.validateString)(properties.rangeKeyField)),errors.collect(cdk.propertyValidator("rangeKeyType",cdk.validateString)(properties.rangeKeyType)),errors.collect(cdk.propertyValidator("rangeKeyValue",cdk.validateString)(properties.rangeKeyValue)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "DynamoDBProperty"')}function cfnDetectorModelDynamoDBPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_DynamoDBPropertyValidator(properties).assertSuccess(),{HashKeyField:cdk.stringToCloudFormation(properties.hashKeyField),HashKeyType:cdk.stringToCloudFormation(properties.hashKeyType),HashKeyValue:cdk.stringToCloudFormation(properties.hashKeyValue),Operation:cdk.stringToCloudFormation(properties.operation),Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload),PayloadField:cdk.stringToCloudFormation(properties.payloadField),RangeKeyField:cdk.stringToCloudFormation(properties.rangeKeyField),RangeKeyType:cdk.stringToCloudFormation(properties.rangeKeyType),RangeKeyValue:cdk.stringToCloudFormation(properties.rangeKeyValue),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnDetectorModelDynamoDBPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("hashKeyField","HashKeyField",cfn_parse.FromCloudFormation.getString(properties.HashKeyField)),ret.addPropertyResult("hashKeyType","HashKeyType",properties.HashKeyType!=null?cfn_parse.FromCloudFormation.getString(properties.HashKeyType):void 0),ret.addPropertyResult("hashKeyValue","HashKeyValue",cfn_parse.FromCloudFormation.getString(properties.HashKeyValue)),ret.addPropertyResult("operation","Operation",properties.Operation!=null?cfn_parse.FromCloudFormation.getString(properties.Operation):void 0),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("payloadField","PayloadField",properties.PayloadField!=null?cfn_parse.FromCloudFormation.getString(properties.PayloadField):void 0),ret.addPropertyResult("rangeKeyField","RangeKeyField",properties.RangeKeyField!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyField):void 0),ret.addPropertyResult("rangeKeyType","RangeKeyType",properties.RangeKeyType!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyType):void 0),ret.addPropertyResult("rangeKeyValue","RangeKeyValue",properties.RangeKeyValue!=null?cfn_parse.FromCloudFormation.getString(properties.RangeKeyValue):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_DynamoDBv2PropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "DynamoDBv2Property"')}function cfnDetectorModelDynamoDBv2PropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_DynamoDBv2PropertyValidator(properties).assertSuccess(),{Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnDetectorModelDynamoDBv2PropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_EventPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("actions",cdk.listValidator(CfnDetectorModel_ActionPropertyValidator))(properties.actions)),errors.collect(cdk.propertyValidator("condition",cdk.validateString)(properties.condition)),errors.collect(cdk.propertyValidator("eventName",cdk.requiredValidator)(properties.eventName)),errors.collect(cdk.propertyValidator("eventName",cdk.validateString)(properties.eventName)),errors.wrap('supplied properties not correct for "EventProperty"')}function cfnDetectorModelEventPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_EventPropertyValidator(properties).assertSuccess(),{Actions:cdk.listMapper(cfnDetectorModelActionPropertyToCloudFormation)(properties.actions),Condition:cdk.stringToCloudFormation(properties.condition),EventName:cdk.stringToCloudFormation(properties.eventName)}):properties}function CfnDetectorModelEventPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("actions","Actions",properties.Actions!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelActionPropertyFromCloudFormation)(properties.Actions):void 0),ret.addPropertyResult("condition","Condition",properties.Condition!=null?cfn_parse.FromCloudFormation.getString(properties.Condition):void 0),ret.addPropertyResult("eventName","EventName",cfn_parse.FromCloudFormation.getString(properties.EventName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_FirehosePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("deliveryStreamName",cdk.requiredValidator)(properties.deliveryStreamName)),errors.collect(cdk.propertyValidator("deliveryStreamName",cdk.validateString)(properties.deliveryStreamName)),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("separator",cdk.validateString)(properties.separator)),errors.wrap('supplied properties not correct for "FirehoseProperty"')}function cfnDetectorModelFirehosePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_FirehosePropertyValidator(properties).assertSuccess(),{DeliveryStreamName:cdk.stringToCloudFormation(properties.deliveryStreamName),Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload),Separator:cdk.stringToCloudFormation(properties.separator)}):properties}function CfnDetectorModelFirehosePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("deliveryStreamName","DeliveryStreamName",cfn_parse.FromCloudFormation.getString(properties.DeliveryStreamName)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("separator","Separator",properties.Separator!=null?cfn_parse.FromCloudFormation.getString(properties.Separator):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_IotEventsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputName",cdk.requiredValidator)(properties.inputName)),errors.collect(cdk.propertyValidator("inputName",cdk.validateString)(properties.inputName)),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "IotEventsProperty"')}function cfnDetectorModelIotEventsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_IotEventsPropertyValidator(properties).assertSuccess(),{InputName:cdk.stringToCloudFormation(properties.inputName),Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnDetectorModelIotEventsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputName","InputName",cfn_parse.FromCloudFormation.getString(properties.InputName)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_IotSiteWisePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("assetId",cdk.validateString)(properties.assetId)),errors.collect(cdk.propertyValidator("entryId",cdk.validateString)(properties.entryId)),errors.collect(cdk.propertyValidator("propertyAlias",cdk.validateString)(properties.propertyAlias)),errors.collect(cdk.propertyValidator("propertyId",cdk.validateString)(properties.propertyId)),errors.collect(cdk.propertyValidator("propertyValue",cdk.requiredValidator)(properties.propertyValue)),errors.collect(cdk.propertyValidator("propertyValue",CfnDetectorModel_AssetPropertyValuePropertyValidator)(properties.propertyValue)),errors.wrap('supplied properties not correct for "IotSiteWiseProperty"')}function cfnDetectorModelIotSiteWisePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_IotSiteWisePropertyValidator(properties).assertSuccess(),{AssetId:cdk.stringToCloudFormation(properties.assetId),EntryId:cdk.stringToCloudFormation(properties.entryId),PropertyAlias:cdk.stringToCloudFormation(properties.propertyAlias),PropertyId:cdk.stringToCloudFormation(properties.propertyId),PropertyValue:cfnDetectorModelAssetPropertyValuePropertyToCloudFormation(properties.propertyValue)}):properties}function CfnDetectorModelIotSiteWisePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("assetId","AssetId",properties.AssetId!=null?cfn_parse.FromCloudFormation.getString(properties.AssetId):void 0),ret.addPropertyResult("entryId","EntryId",properties.EntryId!=null?cfn_parse.FromCloudFormation.getString(properties.EntryId):void 0),ret.addPropertyResult("propertyAlias","PropertyAlias",properties.PropertyAlias!=null?cfn_parse.FromCloudFormation.getString(properties.PropertyAlias):void 0),ret.addPropertyResult("propertyId","PropertyId",properties.PropertyId!=null?cfn_parse.FromCloudFormation.getString(properties.PropertyId):void 0),ret.addPropertyResult("propertyValue","PropertyValue",CfnDetectorModelAssetPropertyValuePropertyFromCloudFormation(properties.PropertyValue)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_IotTopicPublishPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mqttTopic",cdk.requiredValidator)(properties.mqttTopic)),errors.collect(cdk.propertyValidator("mqttTopic",cdk.validateString)(properties.mqttTopic)),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "IotTopicPublishProperty"')}function cfnDetectorModelIotTopicPublishPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_IotTopicPublishPropertyValidator(properties).assertSuccess(),{MqttTopic:cdk.stringToCloudFormation(properties.mqttTopic),Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnDetectorModelIotTopicPublishPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mqttTopic","MqttTopic",cfn_parse.FromCloudFormation.getString(properties.MqttTopic)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_LambdaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("functionArn",cdk.requiredValidator)(properties.functionArn)),errors.collect(cdk.propertyValidator("functionArn",cdk.validateString)(properties.functionArn)),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.wrap('supplied properties not correct for "LambdaProperty"')}function cfnDetectorModelLambdaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_LambdaPropertyValidator(properties).assertSuccess(),{FunctionArn:cdk.stringToCloudFormation(properties.functionArn),Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload)}):properties}function CfnDetectorModelLambdaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("functionArn","FunctionArn",cfn_parse.FromCloudFormation.getString(properties.FunctionArn)),ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_OnEnterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("events",cdk.listValidator(CfnDetectorModel_EventPropertyValidator))(properties.events)),errors.wrap('supplied properties not correct for "OnEnterProperty"')}function cfnDetectorModelOnEnterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_OnEnterPropertyValidator(properties).assertSuccess(),{Events:cdk.listMapper(cfnDetectorModelEventPropertyToCloudFormation)(properties.events)}):properties}function CfnDetectorModelOnEnterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("events","Events",properties.Events!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelEventPropertyFromCloudFormation)(properties.Events):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_OnExitPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("events",cdk.listValidator(CfnDetectorModel_EventPropertyValidator))(properties.events)),errors.wrap('supplied properties not correct for "OnExitProperty"')}function cfnDetectorModelOnExitPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_OnExitPropertyValidator(properties).assertSuccess(),{Events:cdk.listMapper(cfnDetectorModelEventPropertyToCloudFormation)(properties.events)}):properties}function CfnDetectorModelOnExitPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("events","Events",properties.Events!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelEventPropertyFromCloudFormation)(properties.Events):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_OnInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("events",cdk.listValidator(CfnDetectorModel_EventPropertyValidator))(properties.events)),errors.collect(cdk.propertyValidator("transitionEvents",cdk.listValidator(CfnDetectorModel_TransitionEventPropertyValidator))(properties.transitionEvents)),errors.wrap('supplied properties not correct for "OnInputProperty"')}function cfnDetectorModelOnInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_OnInputPropertyValidator(properties).assertSuccess(),{Events:cdk.listMapper(cfnDetectorModelEventPropertyToCloudFormation)(properties.events),TransitionEvents:cdk.listMapper(cfnDetectorModelTransitionEventPropertyToCloudFormation)(properties.transitionEvents)}):properties}function CfnDetectorModelOnInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("events","Events",properties.Events!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelEventPropertyFromCloudFormation)(properties.Events):void 0),ret.addPropertyResult("transitionEvents","TransitionEvents",properties.TransitionEvents!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelTransitionEventPropertyFromCloudFormation)(properties.TransitionEvents):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_PayloadPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("contentExpression",cdk.requiredValidator)(properties.contentExpression)),errors.collect(cdk.propertyValidator("contentExpression",cdk.validateString)(properties.contentExpression)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "PayloadProperty"')}function cfnDetectorModelPayloadPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_PayloadPropertyValidator(properties).assertSuccess(),{ContentExpression:cdk.stringToCloudFormation(properties.contentExpression),Type:cdk.stringToCloudFormation(properties.type)}):properties}function CfnDetectorModelPayloadPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("contentExpression","ContentExpression",cfn_parse.FromCloudFormation.getString(properties.ContentExpression)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_ResetTimerPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("timerName",cdk.requiredValidator)(properties.timerName)),errors.collect(cdk.propertyValidator("timerName",cdk.validateString)(properties.timerName)),errors.wrap('supplied properties not correct for "ResetTimerProperty"')}function cfnDetectorModelResetTimerPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_ResetTimerPropertyValidator(properties).assertSuccess(),{TimerName:cdk.stringToCloudFormation(properties.timerName)}):properties}function CfnDetectorModelResetTimerPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("timerName","TimerName",cfn_parse.FromCloudFormation.getString(properties.TimerName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_SetTimerPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("durationExpression",cdk.validateString)(properties.durationExpression)),errors.collect(cdk.propertyValidator("seconds",cdk.validateNumber)(properties.seconds)),errors.collect(cdk.propertyValidator("timerName",cdk.requiredValidator)(properties.timerName)),errors.collect(cdk.propertyValidator("timerName",cdk.validateString)(properties.timerName)),errors.wrap('supplied properties not correct for "SetTimerProperty"')}function cfnDetectorModelSetTimerPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_SetTimerPropertyValidator(properties).assertSuccess(),{DurationExpression:cdk.stringToCloudFormation(properties.durationExpression),Seconds:cdk.numberToCloudFormation(properties.seconds),TimerName:cdk.stringToCloudFormation(properties.timerName)}):properties}function CfnDetectorModelSetTimerPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("durationExpression","DurationExpression",properties.DurationExpression!=null?cfn_parse.FromCloudFormation.getString(properties.DurationExpression):void 0),ret.addPropertyResult("seconds","Seconds",properties.Seconds!=null?cfn_parse.FromCloudFormation.getNumber(properties.Seconds):void 0),ret.addPropertyResult("timerName","TimerName",cfn_parse.FromCloudFormation.getString(properties.TimerName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_SetVariablePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.collect(cdk.propertyValidator("variableName",cdk.requiredValidator)(properties.variableName)),errors.collect(cdk.propertyValidator("variableName",cdk.validateString)(properties.variableName)),errors.wrap('supplied properties not correct for "SetVariableProperty"')}function cfnDetectorModelSetVariablePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_SetVariablePropertyValidator(properties).assertSuccess(),{Value:cdk.stringToCloudFormation(properties.value),VariableName:cdk.stringToCloudFormation(properties.variableName)}):properties}function CfnDetectorModelSetVariablePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("value","Value",cfn_parse.FromCloudFormation.getString(properties.Value)),ret.addPropertyResult("variableName","VariableName",cfn_parse.FromCloudFormation.getString(properties.VariableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_SnsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("targetArn",cdk.requiredValidator)(properties.targetArn)),errors.collect(cdk.propertyValidator("targetArn",cdk.validateString)(properties.targetArn)),errors.wrap('supplied properties not correct for "SnsProperty"')}function cfnDetectorModelSnsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_SnsPropertyValidator(properties).assertSuccess(),{Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload),TargetArn:cdk.stringToCloudFormation(properties.targetArn)}):properties}function CfnDetectorModelSnsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("targetArn","TargetArn",cfn_parse.FromCloudFormation.getString(properties.TargetArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_SqsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("payload",CfnDetectorModel_PayloadPropertyValidator)(properties.payload)),errors.collect(cdk.propertyValidator("queueUrl",cdk.requiredValidator)(properties.queueUrl)),errors.collect(cdk.propertyValidator("queueUrl",cdk.validateString)(properties.queueUrl)),errors.collect(cdk.propertyValidator("useBase64",cdk.validateBoolean)(properties.useBase64)),errors.wrap('supplied properties not correct for "SqsProperty"')}function cfnDetectorModelSqsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_SqsPropertyValidator(properties).assertSuccess(),{Payload:cfnDetectorModelPayloadPropertyToCloudFormation(properties.payload),QueueUrl:cdk.stringToCloudFormation(properties.queueUrl),UseBase64:cdk.booleanToCloudFormation(properties.useBase64)}):properties}function CfnDetectorModelSqsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("payload","Payload",properties.Payload!=null?CfnDetectorModelPayloadPropertyFromCloudFormation(properties.Payload):void 0),ret.addPropertyResult("queueUrl","QueueUrl",cfn_parse.FromCloudFormation.getString(properties.QueueUrl)),ret.addPropertyResult("useBase64","UseBase64",properties.UseBase64!=null?cfn_parse.FromCloudFormation.getBoolean(properties.UseBase64):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_StatePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("onEnter",CfnDetectorModel_OnEnterPropertyValidator)(properties.onEnter)),errors.collect(cdk.propertyValidator("onExit",CfnDetectorModel_OnExitPropertyValidator)(properties.onExit)),errors.collect(cdk.propertyValidator("onInput",CfnDetectorModel_OnInputPropertyValidator)(properties.onInput)),errors.collect(cdk.propertyValidator("stateName",cdk.requiredValidator)(properties.stateName)),errors.collect(cdk.propertyValidator("stateName",cdk.validateString)(properties.stateName)),errors.wrap('supplied properties not correct for "StateProperty"')}function cfnDetectorModelStatePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_StatePropertyValidator(properties).assertSuccess(),{OnEnter:cfnDetectorModelOnEnterPropertyToCloudFormation(properties.onEnter),OnExit:cfnDetectorModelOnExitPropertyToCloudFormation(properties.onExit),OnInput:cfnDetectorModelOnInputPropertyToCloudFormation(properties.onInput),StateName:cdk.stringToCloudFormation(properties.stateName)}):properties}function CfnDetectorModelStatePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("onEnter","OnEnter",properties.OnEnter!=null?CfnDetectorModelOnEnterPropertyFromCloudFormation(properties.OnEnter):void 0),ret.addPropertyResult("onExit","OnExit",properties.OnExit!=null?CfnDetectorModelOnExitPropertyFromCloudFormation(properties.OnExit):void 0),ret.addPropertyResult("onInput","OnInput",properties.OnInput!=null?CfnDetectorModelOnInputPropertyFromCloudFormation(properties.OnInput):void 0),ret.addPropertyResult("stateName","StateName",cfn_parse.FromCloudFormation.getString(properties.StateName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDetectorModel_TransitionEventPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("actions",cdk.listValidator(CfnDetectorModel_ActionPropertyValidator))(properties.actions)),errors.collect(cdk.propertyValidator("condition",cdk.requiredValidator)(properties.condition)),errors.collect(cdk.propertyValidator("condition",cdk.validateString)(properties.condition)),errors.collect(cdk.propertyValidator("eventName",cdk.requiredValidator)(properties.eventName)),errors.collect(cdk.propertyValidator("eventName",cdk.validateString)(properties.eventName)),errors.collect(cdk.propertyValidator("nextState",cdk.requiredValidator)(properties.nextState)),errors.collect(cdk.propertyValidator("nextState",cdk.validateString)(properties.nextState)),errors.wrap('supplied properties not correct for "TransitionEventProperty"')}function cfnDetectorModelTransitionEventPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDetectorModel_TransitionEventPropertyValidator(properties).assertSuccess(),{Actions:cdk.listMapper(cfnDetectorModelActionPropertyToCloudFormation)(properties.actions),Condition:cdk.stringToCloudFormation(properties.condition),EventName:cdk.stringToCloudFormation(properties.eventName),NextState:cdk.stringToCloudFormation(properties.nextState)}):properties}function CfnDetectorModelTransitionEventPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("actions","Actions",properties.Actions!=null?cfn_parse.FromCloudFormation.getArray(CfnDetectorModelActionPropertyFromCloudFormation)(properties.Actions):void 0),ret.addPropertyResult("condition","Condition",cfn_parse.FromCloudFormation.getString(properties.Condition)),ret.addPropertyResult("eventName","EventName",cfn_parse.FromCloudFormation.getString(properties.EventName)),ret.addPropertyResult("nextState","NextState",cfn_parse.FromCloudFormation.getString(properties.NextState)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnInputPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputDefinition",cdk.requiredValidator)(properties.inputDefinition)),errors.collect(cdk.propertyValidator("inputDefinition",CfnInput_InputDefinitionPropertyValidator)(properties.inputDefinition)),errors.collect(cdk.propertyValidator("inputDescription",cdk.validateString)(properties.inputDescription)),errors.collect(cdk.propertyValidator("inputName",cdk.validateString)(properties.inputName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnInputProps"')}function cfnInputPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnInputPropsValidator(properties).assertSuccess(),{InputDefinition:cfnInputInputDefinitionPropertyToCloudFormation(properties.inputDefinition),InputDescription:cdk.stringToCloudFormation(properties.inputDescription),InputName:cdk.stringToCloudFormation(properties.inputName),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnInputPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputDefinition","InputDefinition",CfnInputInputDefinitionPropertyFromCloudFormation(properties.InputDefinition)),ret.addPropertyResult("inputDescription","InputDescription",properties.InputDescription!=null?cfn_parse.FromCloudFormation.getString(properties.InputDescription):void 0),ret.addPropertyResult("inputName","InputName",properties.InputName!=null?cfn_parse.FromCloudFormation.getString(properties.InputName):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnInput extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnInput.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotevents_CfnInputProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnInput),error}cdk.requireProperty(props,"inputDefinition",this),this.inputDefinition=props.inputDefinition,this.inputDescription=props.inputDescription,this.inputName=props.inputName,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTEvents::Input",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnInputPropsFromCloudFormation(resourceProperties),ret=new CfnInput(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnInput.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{inputDefinition:this.inputDefinition,inputDescription:this.inputDescription,inputName:this.inputName,tags:this.tags.renderTags()}}renderProperties(props){return cfnInputPropsToCloudFormation(props)}}exports.CfnInput=CfnInput,_c=JSII_RTTI_SYMBOL_1,CfnInput[_c]={fqn:"aws-cdk-lib.aws_iotevents.CfnInput",version:"2.69.0"},CfnInput.CFN_RESOURCE_TYPE_NAME="AWS::IoTEvents::Input";function CfnInput_AttributePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("jsonPath",cdk.requiredValidator)(properties.jsonPath)),errors.collect(cdk.propertyValidator("jsonPath",cdk.validateString)(properties.jsonPath)),errors.wrap('supplied properties not correct for "AttributeProperty"')}function cfnInputAttributePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnInput_AttributePropertyValidator(properties).assertSuccess(),{JsonPath:cdk.stringToCloudFormation(properties.jsonPath)}):properties}function CfnInputAttributePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("jsonPath","JsonPath",cfn_parse.FromCloudFormation.getString(properties.JsonPath)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnInput_InputDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributes",cdk.requiredValidator)(properties.attributes)),errors.collect(cdk.propertyValidator("attributes",cdk.listValidator(CfnInput_AttributePropertyValidator))(properties.attributes)),errors.wrap('supplied properties not correct for "InputDefinitionProperty"')}function cfnInputInputDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnInput_InputDefinitionPropertyValidator(properties).assertSuccess(),{Attributes:cdk.listMapper(cfnInputAttributePropertyToCloudFormation)(properties.attributes)}):properties}function CfnInputInputDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributes","Attributes",cfn_parse.FromCloudFormation.getArray(CfnInputAttributePropertyFromCloudFormation)(properties.Attributes)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
