"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NetworkLoadBalancer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../../aws-cloudwatch"),ec2=require("../../../aws-ec2"),cxschema=require("../../../cloud-assembly-schema"),core_1=require("../../../core"),network_listener_1=require("./network-listener"),elasticloadbalancingv2_canned_metrics_generated_1=require("../elasticloadbalancingv2-canned-metrics.generated"),base_load_balancer_1=require("../shared/base-load-balancer"),util_1=require("../shared/util");class NetworkLoadBalancerMetrics{constructor(scope,loadBalancerFullName){this.scope=scope,this.loadBalancerFullName=loadBalancerFullName}custom(metricName,props){return new cloudwatch.Metric({namespace:"AWS/NetworkELB",metricName,dimensionsMap:{LoadBalancer:this.loadBalancerFullName},...props}).attachTo(this.scope)}activeFlowCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.activeFlowCountAverage,props)}consumedLCUs(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.consumedLcUsAverage,{statistic:"Sum",...props})}newFlowCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.newFlowCountSum,props)}processedBytes(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.processedBytesSum,props)}tcpClientResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.tcpClientResetCountSum,props)}tcpElbResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.tcpElbResetCountSum,props)}tcpTargetResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.NetworkELBMetrics.tcpTargetResetCountSum,props)}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({LoadBalancer:this.loadBalancerFullName}),...props}).attachTo(this.scope)}}class NetworkLoadBalancer extends base_load_balancer_1.BaseLoadBalancer{constructor(scope,id,props){super(scope,id,props,{type:"network"});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NetworkLoadBalancer),error}this.metrics=new NetworkLoadBalancerMetrics(this,this.loadBalancerFullName),props.crossZoneEnabled&&this.setAttribute("load_balancing.cross_zone.enabled","true")}static fromLookup(scope,id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}const props=base_load_balancer_1.BaseLoadBalancer._queryContextProvider(scope,{userOptions:options,loadBalancerType:cxschema.LoadBalancerType.NETWORK});return new LookedUpNetworkLoadBalancer(scope,id,props)}static fromNetworkLoadBalancerAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromNetworkLoadBalancerAttributes),error}class Import extends core_1.Resource{constructor(){super(...arguments),this.loadBalancerArn=attrs.loadBalancerArn,this.vpc=attrs.vpc,this.metrics=new NetworkLoadBalancerMetrics(this,util_1.parseLoadBalancerFullName(attrs.loadBalancerArn))}addListener(lid,props){return new network_listener_1.NetworkListener(this,lid,{loadBalancer:this,...props})}get loadBalancerCanonicalHostedZoneId(){if(attrs.loadBalancerCanonicalHostedZoneId)return attrs.loadBalancerCanonicalHostedZoneId;throw new Error(`'loadBalancerCanonicalHostedZoneId' was not provided when constructing Network Load Balancer ${this.node.path} from attributes`)}get loadBalancerDnsName(){if(attrs.loadBalancerDnsName)return attrs.loadBalancerDnsName;throw new Error(`'loadBalancerDnsName' was not provided when constructing Network Load Balancer ${this.node.path} from attributes`)}}return new Import(scope,id,{environmentFromArn:attrs.loadBalancerArn})}addListener(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_BaseNetworkListenerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addListener),error}return new network_listener_1.NetworkListener(this,id,{loadBalancer:this,...props})}metric(metricName,props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metric","Use ``NetworkLoadBalancer.metrics.custom`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/NetworkELB",metricName,dimensions:{LoadBalancer:this.loadBalancerFullName},...props}).attachTo(this)}metricActiveFlowCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricActiveFlowCount","Use ``NetworkLoadBalancer.metrics.activeFlowCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricActiveFlowCount),error}return this.metrics.activeFlowCount(props)}metricConsumedLCUs(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricConsumedLCUs","Use ``NetworkLoadBalancer.metrics.activeFlowCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricConsumedLCUs),error}return this.metrics.consumedLCUs(props)}metricHealthyHostCount(props){return this.metric("HealthyHostCount",{statistic:"Average",...props})}metricUnHealthyHostCount(props){return this.metric("UnHealthyHostCount",{statistic:"Average",...props})}metricNewFlowCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricNewFlowCount","Use ``NetworkLoadBalancer.metrics.newFlowCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricNewFlowCount),error}return this.metrics.newFlowCount(props)}metricProcessedBytes(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricProcessedBytes","Use ``NetworkLoadBalancer.metrics.processedBytes`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricProcessedBytes),error}return this.metrics.processedBytes(props)}metricTcpClientResetCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpClientResetCount","Use ``NetworkLoadBalancer.metrics.tcpClientResetCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpClientResetCount),error}return this.metrics.tcpClientResetCount(props)}metricTcpElbResetCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpElbResetCount","Use ``NetworkLoadBalancer.metrics.tcpElbResetCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpElbResetCount),error}return this.metrics.tcpElbResetCount(props)}metricTcpTargetResetCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpTargetResetCount","Use ``NetworkLoadBalancer.metrics.tcpTargetResetCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpTargetResetCount),error}return this.metrics.tcpTargetResetCount(props)}}exports.NetworkLoadBalancer=NetworkLoadBalancer,_a=JSII_RTTI_SYMBOL_1,NetworkLoadBalancer[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer",version:"2.69.0"};class LookedUpNetworkLoadBalancer extends core_1.Resource{constructor(scope,id,props){super(scope,id,{environmentFromArn:props.loadBalancerArn}),this.loadBalancerArn=props.loadBalancerArn,this.loadBalancerCanonicalHostedZoneId=props.loadBalancerCanonicalHostedZoneId,this.loadBalancerDnsName=props.loadBalancerDnsName,this.metrics=new NetworkLoadBalancerMetrics(this,util_1.parseLoadBalancerFullName(props.loadBalancerArn)),this.vpc=ec2.Vpc.fromLookup(this,"Vpc",{vpcId:props.vpcId})}addListener(lid,props){return new network_listener_1.NetworkListener(this,lid,{loadBalancer:this,...props})}}
