"use strict";var _a,_b,_c,_d,_e,_f,_g;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LookupMachineImage=exports.OperatingSystemType=exports.GenericWindowsImage=exports.GenericLinuxImage=exports.AmazonLinuxStorage=exports.AmazonLinuxVirt=exports.AmazonLinuxEdition=exports.AmazonLinuxKernel=exports.AmazonLinuxGeneration=exports.AmazonLinuxImage=exports.AmazonLinuxCpuType=exports.WindowsImage=exports.GenericSSMParameterImage=exports.MachineImage=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ssm=require("../../aws-ssm"),cxschema=require("../../cloud-assembly-schema"),core_1=require("../../core"),user_data_1=require("./user-data"),windows_versions_1=require("./windows-versions");class MachineImage{static latestWindows(version,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_WindowsVersion(version),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_WindowsImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.latestWindows),error}return new WindowsImage(version,props)}static latestAmazonLinux(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_AmazonLinuxImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.latestAmazonLinux),error}return new AmazonLinuxImage(props)}static genericLinux(amiMap,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GenericLinuxImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.genericLinux),error}return new GenericLinuxImage(amiMap,props)}static genericWindows(amiMap,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GenericWindowsImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.genericWindows),error}return new GenericWindowsImage(amiMap,props)}static fromSSMParameter(parameterName,os,userData){return new GenericSSMParameterImage(parameterName,os,userData)}static fromSsmParameter(parameterName,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_SsmParameterImageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSsmParameter),error}return new GenericSsmParameterImage(parameterName,options)}static lookup(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LookupMachineImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.lookup),error}return new LookupMachineImage(props)}}exports.MachineImage=MachineImage,_a=JSII_RTTI_SYMBOL_1,MachineImage[_a]={fqn:"aws-cdk-lib.aws_ec2.MachineImage",version:"2.69.0"};class GenericSSMParameterImage{constructor(parameterName,os,userData){this.os=os,this.userData=userData;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_OperatingSystemType(os),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_UserData(userData)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,GenericSSMParameterImage),error}this.parameterName=parameterName}getImage(scope){return{imageId:ssm.StringParameter.valueForTypedStringParameterV2(scope,this.parameterName,ssm.ParameterValueType.AWS_EC2_IMAGE_ID),osType:this.os,userData:this.userData??(this.os===OperatingSystemType.WINDOWS?user_data_1.UserData.forWindows():user_data_1.UserData.forLinux())}}}exports.GenericSSMParameterImage=GenericSSMParameterImage,_b=JSII_RTTI_SYMBOL_1,GenericSSMParameterImage[_b]={fqn:"aws-cdk-lib.aws_ec2.GenericSSMParameterImage",version:"2.69.0"};class GenericSsmParameterImage{constructor(parameterName,props={}){this.parameterName=parameterName,this.props=props}getImage(scope){const imageId=lookupImage(scope,this.props.cachedInContext,this.parameterName),osType=this.props.os??OperatingSystemType.LINUX;return{imageId,osType,userData:this.props.userData??(osType===OperatingSystemType.WINDOWS?user_data_1.UserData.forWindows():user_data_1.UserData.forLinux())}}}class WindowsImage extends GenericSSMParameterImage{constructor(version,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_WindowsVersion(version),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_WindowsImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,WindowsImage),error}const nonDeprecatedVersionName=WindowsImage.DEPRECATED_VERSION_NAME_MAP[version]??version;super("/aws/service/ami-windows-latest/"+nonDeprecatedVersionName,OperatingSystemType.WINDOWS,props.userData)}}exports.WindowsImage=WindowsImage,_c=JSII_RTTI_SYMBOL_1,WindowsImage[_c]={fqn:"aws-cdk-lib.aws_ec2.WindowsImage",version:"2.69.0"},WindowsImage.DEPRECATED_VERSION_NAME_MAP={[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_GERMAL_FULL_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_GERMAN_FULL_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_SP1_PORTUGESE_BRAZIL_64BIT_CORE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_SP1_PORTUGUESE_BRAZIL_64BIT_CORE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_PORTUGESE_PORTUGAL_FULL_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_PORTUGUESE_PORTUGAL_FULL_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_RTM_PORTUGESE_BRAZIL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_BRAZIL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_RTM_PORTUGESE_PORTUGAL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_PORTUGESE_BRAZIL_FULL_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2016_PORTUGUESE_BRAZIL_FULL_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_SP2_PORTUGESE_BRAZIL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_SP2_PORTUGUESE_BRAZIL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_RTM_PORTUGESE_BRAZIL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_RTM_PORTUGUESE_BRAZIL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2008_R2_SP1_PORTUGESE_BRAZIL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2008_R2_SP1_PORTUGUESE_BRAZIL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2008_SP2_PORTUGESE_BRAZIL_32BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2008_SP2_PORTUGUESE_BRAZIL_32BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_RTM_PORTUGESE_PORTUGAL_64BIT_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2012_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2019_PORTUGESE_BRAZIL_FULL_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2019_PORTUGUESE_BRAZIL_FULL_BASE,[windows_versions_1.WindowsVersion.WINDOWS_SERVER_2019_PORTUGESE_PORTUGAL_FULL_BASE]:windows_versions_1.WindowsVersion.WINDOWS_SERVER_2019_PORTUGUESE_PORTUGAL_FULL_BASE};var AmazonLinuxCpuType;(function(AmazonLinuxCpuType2){AmazonLinuxCpuType2.ARM_64="arm64",AmazonLinuxCpuType2.X86_64="x86_64"})(AmazonLinuxCpuType=exports.AmazonLinuxCpuType||(exports.AmazonLinuxCpuType={}));class AmazonLinuxImage extends GenericSSMParameterImage{constructor(props={}){super(AmazonLinuxImage.ssmParameterName(props),OperatingSystemType.LINUX,props.userData),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_AmazonLinuxImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AmazonLinuxImage),error}this.cachedInContext=props.cachedInContext??!1}static ssmParameterName(props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_AmazonLinuxImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.ssmParameterName),error}const generation=props&&props.generation||AmazonLinuxGeneration.AMAZON_LINUX,edition=props&&props.edition||AmazonLinuxEdition.STANDARD,cpu=props&&props.cpuType||AmazonLinuxCpuType.X86_64;let kernel=props&&props.kernel||void 0,virtualization,storage;if(generation===AmazonLinuxGeneration.AMAZON_LINUX_2022){if(kernel=AmazonLinuxKernel.KERNEL5_X,props&&props.storage)throw new Error("Storage parameter does not exist in smm parameter name for Amazon Linux 2022.");if(props&&props.virtualization)throw new Error("Virtualization parameter does not exist in smm parameter name for Amazon Linux 2022.")}else virtualization=props&&props.virtualization||AmazonLinuxVirt.HVM,storage=props&&props.storage||AmazonLinuxStorage.GENERAL_PURPOSE;return"/aws/service/ami-amazon-linux-latest/"+[generation,"ami",edition!==AmazonLinuxEdition.STANDARD?edition:void 0,kernel,virtualization,cpu,storage].filter(x=>x!==void 0).join("-")}getImage(scope){const imageId=lookupImage(scope,this.cachedInContext,this.parameterName),osType=OperatingSystemType.LINUX;return{imageId,osType,userData:this.props.userData??user_data_1.UserData.forLinux()}}}exports.AmazonLinuxImage=AmazonLinuxImage,_d=JSII_RTTI_SYMBOL_1,AmazonLinuxImage[_d]={fqn:"aws-cdk-lib.aws_ec2.AmazonLinuxImage",version:"2.69.0"};var AmazonLinuxGeneration;(function(AmazonLinuxGeneration2){AmazonLinuxGeneration2.AMAZON_LINUX="amzn",AmazonLinuxGeneration2.AMAZON_LINUX_2="amzn2",AmazonLinuxGeneration2.AMAZON_LINUX_2022="al2022"})(AmazonLinuxGeneration=exports.AmazonLinuxGeneration||(exports.AmazonLinuxGeneration={}));var AmazonLinuxKernel;(function(AmazonLinuxKernel2){AmazonLinuxKernel2.KERNEL5_X="kernel-5.10"})(AmazonLinuxKernel=exports.AmazonLinuxKernel||(exports.AmazonLinuxKernel={}));var AmazonLinuxEdition;(function(AmazonLinuxEdition2){AmazonLinuxEdition2.STANDARD="standard",AmazonLinuxEdition2.MINIMAL="minimal"})(AmazonLinuxEdition=exports.AmazonLinuxEdition||(exports.AmazonLinuxEdition={}));var AmazonLinuxVirt;(function(AmazonLinuxVirt2){AmazonLinuxVirt2.HVM="hvm",AmazonLinuxVirt2.PV="pv"})(AmazonLinuxVirt=exports.AmazonLinuxVirt||(exports.AmazonLinuxVirt={}));var AmazonLinuxStorage;(function(AmazonLinuxStorage2){AmazonLinuxStorage2.EBS="ebs",AmazonLinuxStorage2.S3="s3",AmazonLinuxStorage2.GENERAL_PURPOSE="gp2"})(AmazonLinuxStorage=exports.AmazonLinuxStorage||(exports.AmazonLinuxStorage={}));class GenericLinuxImage{constructor(amiMap,props={}){this.amiMap=amiMap,this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GenericLinuxImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,GenericLinuxImage),error}}getImage(scope){const userData=this.props.userData??user_data_1.UserData.forLinux(),osType=OperatingSystemType.LINUX,region=core_1.Stack.of(scope).region;if(core_1.Token.isUnresolved(region)){const mapping={};for(const[rgn,ami]of Object.entries(this.amiMap))mapping[rgn]={ami};return{imageId:new core_1.CfnMapping(scope,"AmiMap",{mapping}).findInMap(core_1.Aws.REGION,"ami"),userData,osType}}const imageId=region!=="test-region"?this.amiMap[region]:"ami-12345";if(!imageId)throw new Error(`Unable to find AMI in AMI map: no AMI specified for region '${region}'`);return{imageId,userData,osType}}}exports.GenericLinuxImage=GenericLinuxImage,_e=JSII_RTTI_SYMBOL_1,GenericLinuxImage[_e]={fqn:"aws-cdk-lib.aws_ec2.GenericLinuxImage",version:"2.69.0"};class GenericWindowsImage{constructor(amiMap,props={}){this.amiMap=amiMap,this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GenericWindowsImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,GenericWindowsImage),error}}getImage(scope){const userData=this.props.userData??user_data_1.UserData.forWindows(),osType=OperatingSystemType.WINDOWS,region=core_1.Stack.of(scope).region;if(core_1.Token.isUnresolved(region)){const mapping={};for(const[rgn,ami]of Object.entries(this.amiMap))mapping[rgn]={ami};return{imageId:new core_1.CfnMapping(scope,"AmiMap",{mapping}).findInMap(core_1.Aws.REGION,"ami"),userData,osType}}const imageId=region!=="test-region"?this.amiMap[region]:"ami-12345";if(!imageId)throw new Error(`Unable to find AMI in AMI map: no AMI specified for region '${region}'`);return{imageId,userData,osType}}}exports.GenericWindowsImage=GenericWindowsImage,_f=JSII_RTTI_SYMBOL_1,GenericWindowsImage[_f]={fqn:"aws-cdk-lib.aws_ec2.GenericWindowsImage",version:"2.69.0"};var OperatingSystemType;(function(OperatingSystemType2){OperatingSystemType2[OperatingSystemType2.LINUX=0]="LINUX",OperatingSystemType2[OperatingSystemType2.WINDOWS=1]="WINDOWS",OperatingSystemType2[OperatingSystemType2.UNKNOWN=2]="UNKNOWN"})(OperatingSystemType=exports.OperatingSystemType||(exports.OperatingSystemType={}));class LookupMachineImage{constructor(props){this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_LookupMachineImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LookupMachineImage),error}}getImage(scope){const filters={name:[this.props.name],state:["available"],"image-type":["machine"],platform:this.props.windows?["windows"]:void 0};Object.assign(filters,this.props.filters);const value=core_1.ContextProvider.getValue(scope,{provider:cxschema.ContextProvider.AMI_PROVIDER,props:{owners:this.props.owners,filters},dummyValue:"ami-1234"}).value;if(typeof value!="string")throw new Error(`Response to AMI lookup invalid, got: ${value}`);const osType=this.props.windows?OperatingSystemType.WINDOWS:OperatingSystemType.LINUX;return{imageId:value,osType,userData:this.props.userData??user_data_1.UserData.forOperatingSystem(osType)}}}exports.LookupMachineImage=LookupMachineImage,_g=JSII_RTTI_SYMBOL_1,LookupMachineImage[_g]={fqn:"aws-cdk-lib.aws_ec2.LookupMachineImage",version:"2.69.0"};function lookupImage(scope,cachedInContext,parameterName){return cachedInContext?ssm.StringParameter.valueFromLookup(scope,parameterName):ssm.StringParameter.valueForTypedStringParameterV2(scope,parameterName,ssm.ParameterValueType.AWS_EC2_IMAGE_ID)}
