"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.resolvedOr=exports.StringSpecializer=exports.assertBound=exports.contentHash=exports.addStackArtifactToAssembly=void 0;const crypto=require("crypto"),cxschema=require("../../../cloud-assembly-schema"),cxapi=require("../../../cx-api"),constructs_1=require("constructs"),stack_1=require("../stack"),token_1=require("../token");function addStackArtifactToAssembly(session,stack,stackProps,additionalStackDependencies){stack.tags.hasTags()&&stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.STACK_TAGS,stack.tags.renderTags());const deps=[...stack.dependencies.map(s=>s.artifactId),...additionalStackDependencies],meta=collectStackMetadata(stack),stackNameProperty=stack.stackName===stack.artifactId?{}:{stackName:stack.stackName},properties={templateFile:stack.templateFile,terminationProtection:stack.terminationProtection,tags:nonEmptyDict(stack.tags.tagValues()),validateOnSynth:session.validateOnSynth,...stackProps,...stackNameProperty};session.assembly.addArtifact(stack.artifactId,{type:cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK,environment:stack.environment,properties,dependencies:deps.length>0?deps:void 0,metadata:Object.keys(meta).length>0?meta:void 0,displayName:stack.node.path})}exports.addStackArtifactToAssembly=addStackArtifactToAssembly;function collectStackMetadata(stack){const output={};return visit(stack),output;function visit(node){if(findParentStack(node)===stack){node.node.metadata.length>0&&(output[constructs_1.Node.PATH_SEP+node.node.path]=node.node.metadata.map(md=>stack.resolve(md)));for(const child of node.node.children)visit(child)}}function findParentStack(node){if(stack_1.Stack.isStack(node)&&node.nestedStackParent===void 0)return node;if(node.node.scope)return findParentStack(node.node.scope)}}function contentHash(content){return crypto.createHash("sha256").update(content).digest("hex")}exports.contentHash=contentHash;function assertBound(x){if(x===null&&x===void 0)throw new Error("You must call bindStack() first")}exports.assertBound=assertBound;function nonEmptyDict(xs){return Object.keys(xs).length>0?xs:void 0}function replaceAll(s,search,replace){return s.split(search).join(replace)}class StringSpecializer{constructor(stack,qualifier){this.stack=stack,this.qualifier=qualifier}specialize(s){return s=replaceAll(s,"${Qualifier}",this.qualifier),cxapi.EnvironmentPlaceholders.replace(s,{region:resolvedOr(this.stack.region,cxapi.EnvironmentPlaceholders.CURRENT_REGION),accountId:resolvedOr(this.stack.account,cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT),partition:cxapi.EnvironmentPlaceholders.CURRENT_PARTITION})}qualifierOnly(s){return replaceAll(s,"${Qualifier}",this.qualifier)}}exports.StringSpecializer=StringSpecializer;function resolvedOr(x,def){return token_1.Token.isUnresolved(x)?def:x}exports.resolvedOr=resolvedOr;
