"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EmrContainersCreateVirtualCluster=exports.EksClusterInput=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),core_1=require("../../../core"),task_utils_1=require("../private/task-utils");var ContainerProviderTypes;(function(ContainerProviderTypes2){ContainerProviderTypes2.EKS="EKS"})(ContainerProviderTypes||(ContainerProviderTypes={}));class EksClusterInput{constructor(clusterName){this.clusterName=clusterName}static fromCluster(cluster){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_ICluster(cluster)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCluster),error}return new EksClusterInput(cluster.clusterName)}static fromTaskInput(taskInput){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_TaskInput(taskInput)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTaskInput),error}return new EksClusterInput(taskInput.value)}}exports.EksClusterInput=EksClusterInput,_a=JSII_RTTI_SYMBOL_1,EksClusterInput[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.EksClusterInput",version:"2.69.0"};class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EmrContainersCreateVirtualCluster),error}this.integrationPattern=props.integrationPattern??sfn.IntegrationPattern.REQUEST_RESPONSE,task_utils_1.validatePatternSupported(this.integrationPattern,EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS),this.taskPolicies=this.createPolicyStatements()}_renderTask(){return{Resource:task_utils_1.integrationResourceArn("emr-containers","createVirtualCluster",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject({Name:this.props.virtualClusterName??sfn.JsonPath.stringAt("States.Format('{}/{}', $$.Execution.Name, $$.State.Name)"),ContainerProvider:{Id:this.props.eksCluster.clusterName,Info:{EksInfo:{Namespace:this.props.eksNamespace??"default"}},Type:ContainerProviderTypes.EKS},Tags:this.props.tags})}}createPolicyStatements(){return[new iam.PolicyStatement({resources:["*"],actions:["emr-containers:CreateVirtualCluster"]}),new iam.PolicyStatement({resources:[core_1.Stack.of(this).formatArn({service:"iam",region:"",resource:"role/aws-service-role/emr-containers.amazonaws.com",resourceName:"AWSServiceRoleForAmazonEMRContainers"})],actions:["iam:CreateServiceLinkedRole"],conditions:{StringLike:{"iam:AWSServiceName":"emr-containers.amazonaws.com"}}})]}}exports.EmrContainersCreateVirtualCluster=EmrContainersCreateVirtualCluster,_b=JSII_RTTI_SYMBOL_1,EmrContainersCreateVirtualCluster[_b]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.EmrContainersCreateVirtualCluster",version:"2.69.0"},EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE];
