"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Source=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path_1=require("path"),s3_assets=require("../../aws-s3-assets"),core_1=require("../../core"),render_data_1=require("./render-data");class Source{constructor(){}static bucket(bucket,zipObjectKey){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bucket),error}return{bind:(_,context)=>{if(!context)throw new Error("To use a Source.bucket(), context must be provided");return bucket.grantRead(context.handlerRole),{bucket,zipObjectKey}}}}static asset(path,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_AssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.asset),error}return{bind(scope,context){if(!context)throw new Error("To use a Source.asset(), context must be provided");let id=1;for(;scope.node.tryFindChild(`Asset${id}`);)id++;const asset=new s3_assets.Asset(scope,`Asset${id}`,{path,...options});if(!asset.isZipArchive)throw new Error("Asset path must be either a .zip file or a directory");return asset.grantRead(context.handlerRole),{bucket:asset.bucket,zipObjectKey:asset.s3ObjectKey}}}}static data(objectKey,data){return{bind:(scope,context)=>{const workdir=core_1.FileSystem.mkdtemp("s3-deployment"),outputPath=path_1.join(workdir,objectKey),rendered=render_data_1.renderData(scope,data);fs.mkdirSync(path_1.dirname(outputPath),{recursive:!0}),fs.writeFileSync(outputPath,rendered.text);const asset=this.asset(workdir).bind(scope,context);return{bucket:asset.bucket,zipObjectKey:asset.zipObjectKey,markers:rendered.markers}}}}static jsonData(objectKey,obj){return{bind:(scope,context)=>Source.data(objectKey,core_1.Stack.of(scope).toJsonString(obj)).bind(scope,context)}}}exports.Source=Source,_a=JSII_RTTI_SYMBOL_1,Source[_a]={fqn:"aws-cdk-lib.aws_s3_deployment.Source",version:"2.69.0"};
