"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NodejsFunction=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),lambda=require("../../aws-lambda"),aws_lambda_1=require("../../aws-lambda"),bundling_1=require("./bundling"),package_manager_1=require("./package-manager"),util_1=require("./util");class NodejsFunction extends lambda.Function{constructor(scope,id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_nodejs_NodejsFunctionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NodejsFunction),error}if(props.runtime&&props.runtime.family!==lambda.RuntimeFamily.NODEJS)throw new Error("Only `NODEJS` runtimes are supported.");const entry=path.resolve(findEntry(id,props.entry)),handler=props.handler??"handler",runtime=props.runtime??lambda.Runtime.NODEJS_14_X,architecture=props.architecture??aws_lambda_1.Architecture.X86_64,depsLockFilePath=findLockFile(props.depsLockFilePath),projectRoot=props.projectRoot??path.dirname(depsLockFilePath);super(scope,id,{...props,runtime,code:bundling_1.Bundling.bundle({...props.bundling??{},entry,runtime,architecture,depsLockFilePath,projectRoot}),handler:handler.indexOf(".")!==-1?`${handler}`:`index.${handler}`}),(props.awsSdkConnectionReuse??!0)&&this.addEnvironment("AWS_NODEJS_CONNECTION_REUSE_ENABLED","1",{removeInEdge:!0})}}exports.NodejsFunction=NodejsFunction,_a=JSII_RTTI_SYMBOL_1,NodejsFunction[_a]={fqn:"aws-cdk-lib.aws_lambda_nodejs.NodejsFunction",version:"2.69.0"};function findLockFile(depsLockFilePath){if(depsLockFilePath){if(!fs.existsSync(depsLockFilePath))throw new Error(`Lock file at ${depsLockFilePath} doesn't exist`);if(!fs.statSync(depsLockFilePath).isFile())throw new Error("`depsLockFilePath` should point to a file");return path.resolve(depsLockFilePath)}const lockFiles=util_1.findUpMultiple([package_manager_1.LockFile.PNPM,package_manager_1.LockFile.YARN,package_manager_1.LockFile.NPM]);if(lockFiles.length===0)throw new Error("Cannot find a package lock file (`pnpm-lock.yaml`, `yarn.lock` or `package-lock.json`). Please specify it with `depsLockFilePath`.");if(lockFiles.length>1)throw new Error(`Multiple package lock files found: ${lockFiles.join(", ")}. Please specify the desired one with \`depsLockFilePath\`.`);return lockFiles[0]}function findEntry(id,entry){if(entry){if(!/\.(jsx?|tsx?|mjs)$/.test(entry))throw new Error("Only JavaScript or TypeScript entry files are supported.");if(!fs.existsSync(entry))throw new Error(`Cannot find entry file at ${entry}`);return entry}const definingFile=findDefiningFile(),extname=path.extname(definingFile),tsHandlerFile=definingFile.replace(new RegExp(`${extname}$`),`.${id}.ts`);if(fs.existsSync(tsHandlerFile))return tsHandlerFile;const jsHandlerFile=definingFile.replace(new RegExp(`${extname}$`),`.${id}.js`);if(fs.existsSync(jsHandlerFile))return jsHandlerFile;const mjsHandlerFile=definingFile.replace(new RegExp(`${extname}$`),`.${id}.mjs`);if(fs.existsSync(mjsHandlerFile))return mjsHandlerFile;throw new Error(`Cannot find handler file ${tsHandlerFile}, ${jsHandlerFile} or ${mjsHandlerFile}`)}function findDefiningFile(){let definingIndex;const sites=util_1.callsites();for(const[index,site]of sites.entries())if(site.getFunctionName()==="NodejsFunction"){definingIndex=index+1;break}if(!definingIndex||!sites[definingIndex])throw new Error("Cannot find defining file.");return sites[definingIndex].getFileName()}
