"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StreamMode=exports.StreamEncryption=exports.Stream=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),kms=require("../../aws-kms"),core_1=require("../../core"),kinesis_fixed_canned_metrics_1=require("./kinesis-fixed-canned-metrics"),kinesis_generated_1=require("./kinesis.generated"),READ_OPERATIONS=["kinesis:DescribeStreamSummary","kinesis:GetRecords","kinesis:GetShardIterator","kinesis:ListShards","kinesis:SubscribeToShard","kinesis:DescribeStream","kinesis:ListStreams","kinesis:DescribeStreamConsumer"],WRITE_OPERATIONS=["kinesis:ListShards","kinesis:PutRecord","kinesis:PutRecords"];class StreamBase extends core_1.Resource{grantRead(grantee){const ret=this.grant(grantee,...READ_OPERATIONS);return this.encryptionKey&&this.encryptionKey.grantDecrypt(grantee),ret}grantWrite(grantee){const ret=this.grant(grantee,...WRITE_OPERATIONS);return this.encryptionKey?.grantEncrypt(grantee),ret}grantReadWrite(grantee){const ret=this.grant(grantee,...Array.from(new Set([...READ_OPERATIONS,...WRITE_OPERATIONS])));return this.encryptionKey?.grantEncryptDecrypt(grantee),ret}grant(grantee,...actions){return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[this.streamArn],scope:this})}metric(metricName,props){return new cloudwatch.Metric({namespace:"AWS/Kinesis",metricName,dimensionsMap:{StreamName:this.streamName},...props}).attachTo(this)}metricGetRecordsBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.getRecordsBytesAverage,props)}metricGetRecordsIteratorAgeMilliseconds(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.getRecordsIteratorAgeMillisecondsMaximum,props)}metricGetRecordsSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.getRecordsSuccessAverage,props)}metricGetRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.getRecordsRecordsAverage,props)}metricGetRecordsLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.getRecordsLatencyAverage,props)}metricPutRecordBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordBytesAverage,props)}metricPutRecordLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordLatencyAverage,props)}metricPutRecordSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordSuccessAverage,props)}metricPutRecordsBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsBytesAverage,props)}metricPutRecordsLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsLatencyAverage,props)}metricPutRecordsSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsSuccessAverage,props)}metricPutRecordsTotalRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsTotalRecordsAverage,props)}metricPutRecordsSuccessfulRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsSuccessfulRecordsAverage,props)}metricPutRecordsFailedRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsFailedRecordsAverage,props)}metricPutRecordsThrottledRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.putRecordsThrottledRecordsAverage,props)}metricIncomingBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.incomingBytesAverage,props)}metricIncomingRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.incomingRecordsAverage,props)}metricReadProvisionedThroughputExceeded(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.readProvisionedThroughputExceededAverage,props)}metricWriteProvisionedThroughputExceeded(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1.KinesisMetrics.writeProvisionedThroughputExceededAverage,props)}metricFromCannedFunction(createCannedProps,props){return new cloudwatch.Metric({...createCannedProps({StreamName:this.streamName}),...props}).attachTo(this)}}class Stream extends StreamBase{constructor(scope,id,props={}){super(scope,id,{physicalName:props.streamName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesis_StreamProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Stream),error}let shardCount=props.shardCount;const streamMode=props.streamMode??StreamMode.PROVISIONED;if(streamMode===StreamMode.ON_DEMAND&&shardCount!==void 0)throw new Error(`streamMode must be set to ${StreamMode.PROVISIONED} (default) when specifying shardCount`);streamMode===StreamMode.PROVISIONED&&shardCount===void 0&&(shardCount=1);const retentionPeriodHours=props.retentionPeriod?.toHours()??24;if(!core_1.Token.isUnresolved(retentionPeriodHours)&&(retentionPeriodHours<24||retentionPeriodHours>8760))throw new Error(`retentionPeriod must be between 24 and 8760 hours. Received ${retentionPeriodHours}`);const{streamEncryption,encryptionKey}=this.parseEncryption(props);this.stream=new kinesis_generated_1.CfnStream(this,"Resource",{name:this.physicalName,retentionPeriodHours,shardCount,streamEncryption,streamModeDetails:streamMode?{streamMode}:void 0}),this.streamArn=this.getResourceArnAttribute(this.stream.attrArn,{service:"kinesis",resource:"stream",resourceName:this.physicalName}),this.streamName=this.getResourceNameAttribute(this.stream.ref),this.encryptionKey=encryptionKey}static fromStreamArn(scope,id,streamArn){return Stream.fromStreamAttributes(scope,id,{streamArn})}static fromStreamAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesis_StreamAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStreamAttributes),error}class Import extends StreamBase{constructor(){super(...arguments),this.streamArn=attrs.streamArn,this.streamName=core_1.Stack.of(scope).splitArn(attrs.streamArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName,this.encryptionKey=attrs.encryptionKey}}return new Import(scope,id)}parseEncryption(props){if(!props.encryption&&!props.encryptionKey){const conditionName="AwsCdkKinesisEncryptedStreamsUnsupportedRegions";return core_1.Stack.of(this).node.tryFindChild(conditionName)||new core_1.CfnCondition(core_1.Stack.of(this),conditionName,{expression:core_1.Fn.conditionOr(core_1.Fn.conditionEquals(core_1.Aws.REGION,"cn-north-1"),core_1.Fn.conditionEquals(core_1.Aws.REGION,"cn-northwest-1"))}),{streamEncryption:core_1.Fn.conditionIf(conditionName,core_1.Aws.NO_VALUE,{EncryptionType:"KMS",KeyId:"alias/aws/kinesis"})}}const encryptionType=props.encryption??(props.encryptionKey?StreamEncryption.KMS:StreamEncryption.UNENCRYPTED);if(encryptionType!==StreamEncryption.KMS&&props.encryptionKey)throw new Error(`encryptionKey is specified, so 'encryption' must be set to KMS (value: ${encryptionType})`);if(encryptionType===StreamEncryption.UNENCRYPTED)return{};if(encryptionType===StreamEncryption.MANAGED)return{streamEncryption:{encryptionType:"KMS",keyId:"alias/aws/kinesis"}};if(encryptionType===StreamEncryption.KMS){const encryptionKey=props.encryptionKey||new kms.Key(this,"Key",{description:`Created by ${this.node.path}`}),streamEncryption={encryptionType:"KMS",keyId:encryptionKey.keyArn};return{encryptionKey,streamEncryption}}throw new Error(`Unexpected 'encryptionType': ${encryptionType}`)}}exports.Stream=Stream,_a=JSII_RTTI_SYMBOL_1,Stream[_a]={fqn:"aws-cdk-lib.aws_kinesis.Stream",version:"2.69.0"};var StreamEncryption;(function(StreamEncryption2){StreamEncryption2.UNENCRYPTED="NONE",StreamEncryption2.KMS="KMS",StreamEncryption2.MANAGED="MANAGED"})(StreamEncryption=exports.StreamEncryption||(exports.StreamEncryption={}));var StreamMode;(function(StreamMode2){StreamMode2.PROVISIONED="PROVISIONED",StreamMode2.ON_DEMAND="ON_DEMAND"})(StreamMode=exports.StreamMode||(exports.StreamMode={}));
