"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateName=exports.renderAutoRollbackConfiguration=exports.deploymentConfig=exports.renderAlarmConfiguration=exports.arnForDeploymentConfig=exports.nameFromDeploymentGroupArn=exports.arnForApplication=void 0;const core_1=require("../../../core");function arnForApplication(stack,applicationName){return stack.formatArn({service:"codedeploy",resource:"application",resourceName:applicationName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}exports.arnForApplication=arnForApplication;function nameFromDeploymentGroupArn(deploymentGroupArn){const components=core_1.Arn.split(deploymentGroupArn,core_1.ArnFormat.COLON_RESOURCE_NAME);return core_1.Fn.select(1,core_1.Fn.split("/",components.resourceName??""))}exports.nameFromDeploymentGroupArn=nameFromDeploymentGroupArn;function arnForDeploymentConfig(name,resource){return core_1.Arn.format({partition:core_1.Aws.PARTITION,account:resource?.env.account??core_1.Aws.ACCOUNT_ID,region:resource?.env.region??core_1.Aws.REGION,service:"codedeploy",resource:"deploymentconfig",resourceName:name,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}exports.arnForDeploymentConfig=arnForDeploymentConfig;function renderAlarmConfiguration(alarms,ignorePollAlarmFailure,removeAlarms=!0){return removeAlarms?{alarms:alarms.length>0?alarms.map(a=>({name:a.alarmName})):void 0,enabled:alarms.length>0,ignorePollAlarmFailure}:alarms.length===0?void 0:{alarms:alarms.map(a=>({name:a.alarmName})),enabled:!0,ignorePollAlarmFailure}}exports.renderAlarmConfiguration=renderAlarmConfiguration;function deploymentConfig(name){return{deploymentConfigName:name,deploymentConfigArn:arnForDeploymentConfig(name),bindEnvironment:resource=>({deploymentConfigName:name,deploymentConfigArn:arnForDeploymentConfig(name,resource)})}}exports.deploymentConfig=deploymentConfig;var AutoRollbackEvent;(function(AutoRollbackEvent2){AutoRollbackEvent2.DEPLOYMENT_FAILURE="DEPLOYMENT_FAILURE",AutoRollbackEvent2.DEPLOYMENT_STOP_ON_ALARM="DEPLOYMENT_STOP_ON_ALARM",AutoRollbackEvent2.DEPLOYMENT_STOP_ON_REQUEST="DEPLOYMENT_STOP_ON_REQUEST"})(AutoRollbackEvent||(AutoRollbackEvent={}));function renderAutoRollbackConfiguration(alarms,autoRollbackConfig={}){const events=new Array;if(autoRollbackConfig.failedDeployment!==!1&&events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE),autoRollbackConfig.stoppedDeployment===!0&&events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST),autoRollbackConfig.deploymentInAlarm!==!1){if(alarms.length>0)events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);else if(autoRollbackConfig.deploymentInAlarm===!0)throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate at least one CloudWatch alarm with the Deployment Group")}return autoRollbackConfig.failedDeployment===!1&&autoRollbackConfig.stoppedDeployment!==!0&&autoRollbackConfig.deploymentInAlarm===!1?{enabled:!1}:events.length>0?{enabled:!0,events}:void 0}exports.renderAutoRollbackConfiguration=renderAutoRollbackConfiguration;function validateName(type,name){const ret=[];return!core_1.Token.isUnresolved(name)&&name!==void 0&&(name.length>100&&ret.push(`${type} name: "${name}" can be a max of 100 characters.`),/^[a-z0-9._+=,@-]+$/i.test(name)||ret.push(`${type} name: "${name}" can only contain letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), + (plus signs), = (equals signs), , (commas), @ (at signs), - (minus signs).`)),ret}exports.validateName=validateName;
