"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateGrpcGatewayRouteMatch=exports.validateGrpcRouteMatch=exports.validateGrpcMatchArrayLength=exports.validateHttpMatchArrayLength=exports.renderMeshOwner=exports.renderListenerTlsOptions=exports.renderTlsClientPolicy=void 0;const core_1=require("../../../core");function renderTlsClientPolicy(scope,tlsClientPolicy){const certificate=tlsClientPolicy?.mutualTlsCertificate?.bind(scope).tlsCertificate,sans=tlsClientPolicy?.validation.subjectAlternativeNames;return tlsClientPolicy?{certificate,ports:tlsClientPolicy.ports,enforce:tlsClientPolicy.enforce,validation:{subjectAlternativeNames:sans?{match:sans.bind(scope).subjectAlternativeNamesMatch}:void 0,trust:tlsClientPolicy.validation.trust.bind(scope).tlsValidationTrust}}:void 0}exports.renderTlsClientPolicy=renderTlsClientPolicy;function renderListenerTlsOptions(scope,listenerTls){const tlsValidation=listenerTls?.mutualTlsValidation;return listenerTls?{certificate:listenerTls.certificate.bind(scope).tlsCertificate,mode:listenerTls.mode,validation:tlsValidation?{subjectAlternativeNames:tlsValidation.subjectAlternativeNames?{match:tlsValidation.subjectAlternativeNames.bind(scope).subjectAlternativeNamesMatch}:void 0,trust:tlsValidation.trust.bind(scope).tlsValidationTrust}:void 0}:void 0}exports.renderListenerTlsOptions=renderListenerTlsOptions;function renderMeshOwner(resourceAccount,meshAccount){const comparison=core_1.Token.compareStrings(resourceAccount,meshAccount);return comparison===core_1.TokenComparison.DIFFERENT||comparison===core_1.TokenComparison.ONE_UNRESOLVED?meshAccount:void 0}exports.renderMeshOwner=renderMeshOwner;function validateHttpMatchArrayLength(headers,queryParameters){if(headers&&(headers.length<1||headers.length>10))throw new Error(`Number of headers provided for matching must be between 1 and 10, got: ${headers.length}`);if(queryParameters&&(queryParameters.length<1||queryParameters.length>10))throw new Error(`Number of query parameters provided for matching must be between 1 and 10, got: ${queryParameters.length}`)}exports.validateHttpMatchArrayLength=validateHttpMatchArrayLength;function validateGrpcMatchArrayLength(metadata){if(metadata&&(metadata.length<1||metadata.length>10))throw new Error(`Number of metadata provided for matching must be between 1 and 10, got: ${metadata.length}`)}exports.validateGrpcMatchArrayLength=validateGrpcMatchArrayLength;function validateGrpcRouteMatch(match){if(match.serviceName===void 0&&match.metadata===void 0&&match.methodName===void 0)throw new Error("At least one gRPC route match property must be provided")}exports.validateGrpcRouteMatch=validateGrpcRouteMatch;function validateGrpcGatewayRouteMatch(match){if(match.serviceName===void 0&&match.metadata===void 0&&match.hostname===void 0)throw new Error("At least one gRPC gateway route match property beside rewriteRequestHostname must be provided")}exports.validateGrpcGatewayRouteMatch=validateGrpcGatewayRouteMatch;
