"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnAnalyzer=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnAnalyzerPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("analyzerName",cdk.validateString)(properties.analyzerName)),errors.collect(cdk.propertyValidator("archiveRules",cdk.listValidator(CfnAnalyzer_ArchiveRulePropertyValidator))(properties.archiveRules)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "CfnAnalyzerProps"')}function cfnAnalyzerPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAnalyzerPropsValidator(properties).assertSuccess(),{Type:cdk.stringToCloudFormation(properties.type),AnalyzerName:cdk.stringToCloudFormation(properties.analyzerName),ArchiveRules:cdk.listMapper(cfnAnalyzerArchiveRulePropertyToCloudFormation)(properties.archiveRules),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnAnalyzerPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addPropertyResult("analyzerName","AnalyzerName",properties.AnalyzerName!=null?cfn_parse.FromCloudFormation.getString(properties.AnalyzerName):void 0),ret.addPropertyResult("archiveRules","ArchiveRules",properties.ArchiveRules!=null?cfn_parse.FromCloudFormation.getArray(CfnAnalyzerArchiveRulePropertyFromCloudFormation)(properties.ArchiveRules):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnAnalyzer extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnAnalyzer.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_accessanalyzer_CfnAnalyzerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnAnalyzer),error}cdk.requireProperty(props,"type",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.type=props.type,this.analyzerName=props.analyzerName,this.archiveRules=props.archiveRules,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::AccessAnalyzer::Analyzer",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnAnalyzerPropsFromCloudFormation(resourceProperties),ret=new CfnAnalyzer(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnAnalyzer.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{type:this.type,analyzerName:this.analyzerName,archiveRules:this.archiveRules,tags:this.tags.renderTags()}}renderProperties(props){return cfnAnalyzerPropsToCloudFormation(props)}}exports.CfnAnalyzer=CfnAnalyzer,_a=JSII_RTTI_SYMBOL_1,CfnAnalyzer[_a]={fqn:"aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer",version:"2.69.0"},CfnAnalyzer.CFN_RESOURCE_TYPE_NAME="AWS::AccessAnalyzer::Analyzer";function CfnAnalyzer_ArchiveRulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("filter",cdk.requiredValidator)(properties.filter)),errors.collect(cdk.propertyValidator("filter",cdk.listValidator(CfnAnalyzer_FilterPropertyValidator))(properties.filter)),errors.collect(cdk.propertyValidator("ruleName",cdk.requiredValidator)(properties.ruleName)),errors.collect(cdk.propertyValidator("ruleName",cdk.validateString)(properties.ruleName)),errors.wrap('supplied properties not correct for "ArchiveRuleProperty"')}function cfnAnalyzerArchiveRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAnalyzer_ArchiveRulePropertyValidator(properties).assertSuccess(),{Filter:cdk.listMapper(cfnAnalyzerFilterPropertyToCloudFormation)(properties.filter),RuleName:cdk.stringToCloudFormation(properties.ruleName)}):properties}function CfnAnalyzerArchiveRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("filter","Filter",cfn_parse.FromCloudFormation.getArray(CfnAnalyzerFilterPropertyFromCloudFormation)(properties.Filter)),ret.addPropertyResult("ruleName","RuleName",cfn_parse.FromCloudFormation.getString(properties.RuleName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnAnalyzer_FilterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("contains",cdk.listValidator(cdk.validateString))(properties.contains)),errors.collect(cdk.propertyValidator("eq",cdk.listValidator(cdk.validateString))(properties.eq)),errors.collect(cdk.propertyValidator("exists",cdk.validateBoolean)(properties.exists)),errors.collect(cdk.propertyValidator("neq",cdk.listValidator(cdk.validateString))(properties.neq)),errors.collect(cdk.propertyValidator("property",cdk.requiredValidator)(properties.property)),errors.collect(cdk.propertyValidator("property",cdk.validateString)(properties.property)),errors.wrap('supplied properties not correct for "FilterProperty"')}function cfnAnalyzerFilterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnAnalyzer_FilterPropertyValidator(properties).assertSuccess(),{Contains:cdk.listMapper(cdk.stringToCloudFormation)(properties.contains),Eq:cdk.listMapper(cdk.stringToCloudFormation)(properties.eq),Exists:cdk.booleanToCloudFormation(properties.exists),Neq:cdk.listMapper(cdk.stringToCloudFormation)(properties.neq),Property:cdk.stringToCloudFormation(properties.property)}):properties}function CfnAnalyzerFilterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("contains","Contains",properties.Contains!=null?cfn_parse.FromCloudFormation.getStringArray(properties.Contains):void 0),ret.addPropertyResult("eq","Eq",properties.Eq!=null?cfn_parse.FromCloudFormation.getStringArray(properties.Eq):void 0),ret.addPropertyResult("exists","Exists",properties.Exists!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Exists):void 0),ret.addPropertyResult("neq","Neq",properties.Neq!=null?cfn_parse.FromCloudFormation.getStringArray(properties.Neq):void 0),ret.addPropertyResult("property","Property",cfn_parse.FromCloudFormation.getString(properties.Property)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
