# coding: utf-8

"""
    Oliver API

    Oliver API in the cloud service  # noqa: E501

    OpenAPI spec version: 3.10.1
    Contact: api@behavioralsignals.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from behavioral_signals_swagger_client_3.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def client_auth(self, x_auth_client, **kwargs):  # noqa: E501
        """client_auth  # noqa: E501

        Authenticates a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.client_auth(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int x_auth_client: id of the requested client (required)
        :return: Authorized
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.client_auth_with_http_info(x_auth_client, **kwargs)  # noqa: E501
        else:
            (data) = self.client_auth_with_http_info(x_auth_client, **kwargs)  # noqa: E501
            return data

    def client_auth_with_http_info(self, x_auth_client, **kwargs):  # noqa: E501
        """client_auth  # noqa: E501

        Authenticates a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.client_auth_with_http_info(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int x_auth_client: id of the requested client (required)
        :return: Authorized
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method client_auth" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_auth_client' is set
        if ('x_auth_client' not in params or
                params['x_auth_client'] is None):
            raise ValueError("Missing the required parameter `x_auth_client` when calling `client_auth`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_auth_client' in params:
            header_params['X-Auth-Client'] = params['x_auth_client']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/auth', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Authorized',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_client(self, x_auth_client, **kwargs):  # noqa: E501
        """create_client  # noqa: E501

        Create a new client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :param Client client: The client to create
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_with_http_info(x_auth_client, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_with_http_info(x_auth_client, **kwargs)  # noqa: E501
            return data

    def create_client_with_http_info(self, x_auth_client, **kwargs):  # noqa: E501
        """create_client  # noqa: E501

        Create a new client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_with_http_info(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :param Client client: The client to create
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_client', 'client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_auth_client' is set
        if ('x_auth_client' not in params or
                params['x_auth_client'] is None):
            raise ValueError("Missing the required parameter `x_auth_client` when calling `create_client`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_auth_client' in params:
            header_params['X-Auth-Client'] = params['x_auth_client']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client' in params:
            body_params = params['client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_client(self, cid, x_auth_client, **kwargs):  # noqa: E501
        """delete_client  # noqa: E501

        Delete a client with given cid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client(cid, x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: id of the requested client (required)
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :return: GenericResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_client_with_http_info(cid, x_auth_client, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_client_with_http_info(cid, x_auth_client, **kwargs)  # noqa: E501
            return data

    def delete_client_with_http_info(self, cid, x_auth_client, **kwargs):  # noqa: E501
        """delete_client  # noqa: E501

        Delete a client with given cid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_with_http_info(cid, x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: id of the requested client (required)
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :return: GenericResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'x_auth_client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `delete_client`")  # noqa: E501
        # verify the required parameter 'x_auth_client' is set
        if ('x_auth_client' not in params or
                params['x_auth_client'] is None):
            raise ValueError("Missing the required parameter `x_auth_client` when calling `delete_client`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_auth_client' in params:
            header_params['X-Auth-Client'] = params['x_auth_client']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_info  # noqa: E501

        Returns process info for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_info_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_info_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_info_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_info  # noqa: E501

        Returns process info for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_info_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_info`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Process',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results  # noqa: E501

        Returns process results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results  # noqa: E501

        Returns process results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/result', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results_asr(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_asr  # noqa: E501

        Returns speech-to-text transcription in JSON for process  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_asr(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONASR
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_asr_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_asr_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_asr_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_asr  # noqa: E501

        Returns speech-to-text transcription in JSON for process  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_asr_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONASR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results_asr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results_asr`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results_asr`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/resultasr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSONASR',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results_demo(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_demo  # noqa: E501

        Returns process results for demo in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_demo(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFrames
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_demo_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_demo_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_demo_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_demo  # noqa: E501

        Returns process results for demo in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_demo_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFrames
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results_demo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results_demo`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results_demo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/resultdemo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSONFrames',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results_diarization(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_diarization  # noqa: E501

        Returns diarization in JSON for process  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_diarization(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONDiarization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_diarization_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_diarization_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_diarization_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_diarization  # noqa: E501

        Returns diarization in JSON for process  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_diarization_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONDiarization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results_diarization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results_diarization`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results_diarization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/resultdiarization', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSONDiarization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results_features(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_features  # noqa: E501

        Returns process features results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_features(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFeatures
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_features_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_features_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_features_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_features  # noqa: E501

        Returns process features results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_features_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFeatures
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results_features`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/resultfeatures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSONFeatures',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_results_frames(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_frames  # noqa: E501

        Returns process frames results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_frames(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFrames
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_results_frames_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_results_frames_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_results_frames_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_results_frames  # noqa: E501

        Returns process frames results in JSON for pid by client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_results_frames_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ResultJSONFrames
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_results_frames" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_results_frames`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_results_frames`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/resultframes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultJSONFrames',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_stats(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_stats  # noqa: E501

        Returns statistics for process on client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_stats(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ProcessStats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_process_stats_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_process_stats_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_process_stats_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """get_process_stats  # noqa: E501

        Returns statistics for process on client request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_stats_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int pid: ID of the process request (required)
        :return: ProcessStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_process_stats`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_process_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/{pid}/stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcessStats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def info_client(self, cid, **kwargs):  # noqa: E501
        """info_client  # noqa: E501

        Return a client's details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.info_client(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: id of the requested client (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.info_client_with_http_info(cid, **kwargs)  # noqa: E501
        else:
            (data) = self.info_client_with_http_info(cid, **kwargs)  # noqa: E501
            return data

    def info_client_with_http_info(self, cid, **kwargs):  # noqa: E501
        """info_client  # noqa: E501

        Return a client's details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.info_client_with_http_info(cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: id of the requested client (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method info_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `info_client`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_token(self, x_auth_client, **kwargs):  # noqa: E501
        """modify_token  # noqa: E501

        Inserts/Updates a token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_token(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :param Token token: The token to add/update
        :return: Token
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_token_with_http_info(x_auth_client, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_token_with_http_info(x_auth_client, **kwargs)  # noqa: E501
            return data

    def modify_token_with_http_info(self, x_auth_client, **kwargs):  # noqa: E501
        """modify_token  # noqa: E501

        Inserts/Updates a token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_token_with_http_info(x_auth_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_auth_client: The client id that is authorized to do this task (required)
        :param Token token: The token to add/update
        :return: Token
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_client', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_auth_client' is set
        if ('x_auth_client' not in params or
                params['x_auth_client'] is None):
            raise ValueError("Missing the required parameter `x_auth_client` when calling `modify_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_auth_client' in params:
            header_params['X-Auth-Client'] = params['x_auth_client']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'token' in params:
            body_params = params['token']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/token', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Token',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_feedback(self, cid, in_json, **kwargs):  # noqa: E501
        """post_feedback  # noqa: E501

        Post feedback request for a process. It returns a URL with the form to fill in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_feedback(cid, in_json, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param InputFeedback in_json: The input JSON (required)
        :return: ResponseFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_feedback_with_http_info(cid, in_json, **kwargs)  # noqa: E501
        else:
            (data) = self.post_feedback_with_http_info(cid, in_json, **kwargs)  # noqa: E501
            return data

    def post_feedback_with_http_info(self, cid, in_json, **kwargs):  # noqa: E501
        """post_feedback  # noqa: E501

        Post feedback request for a process. It returns a URL with the form to fill in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_feedback_with_http_info(cid, in_json, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param InputFeedback in_json: The input JSON (required)
        :return: ResponseFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'in_json']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_feedback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `post_feedback`")  # noqa: E501
        # verify the required parameter 'in_json' is set
        if ('in_json' not in params or
                params['in_json'] is None):
            raise ValueError("Missing the required parameter `in_json` when calling `post_feedback`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'in_json' in params:
            body_params = params['in_json']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/feedback', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseFeedback',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_feedback(self, cid, form_code, in_json, **kwargs):  # noqa: E501
        """put_feedback  # noqa: E501

        Sets the feedback JSON for a request with given formCode  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_feedback(cid, form_code, in_json, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str form_code: Form code to update the feedback JSON (required)
        :param str in_json: the input JSON read as string (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_feedback_with_http_info(cid, form_code, in_json, **kwargs)  # noqa: E501
        else:
            (data) = self.put_feedback_with_http_info(cid, form_code, in_json, **kwargs)  # noqa: E501
            return data

    def put_feedback_with_http_info(self, cid, form_code, in_json, **kwargs):  # noqa: E501
        """put_feedback  # noqa: E501

        Sets the feedback JSON for a request with given formCode  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_feedback_with_http_info(cid, form_code, in_json, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str form_code: Form code to update the feedback JSON (required)
        :param str in_json: the input JSON read as string (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'form_code', 'in_json']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_feedback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `put_feedback`")  # noqa: E501
        # verify the required parameter 'form_code' is set
        if ('form_code' not in params or
                params['form_code'] is None):
            raise ValueError("Missing the required parameter `form_code` when calling `put_feedback`")  # noqa: E501
        # verify the required parameter 'in_json' is set
        if ('in_json' not in params or
                params['in_json'] is None):
            raise ValueError("Missing the required parameter `in_json` when calling `put_feedback`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'form_code' in params:
            path_params['formCode'] = params['form_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'in_json' in params:
            body_params = params['in_json']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/feedback/{formCode}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_process_audio(self, cid, channels, calldirection, file, **kwargs):  # noqa: E501
        """send_process_audio  # noqa: E501

        Sends a new request with audio file upload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_audio(cid, channels, calldirection, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param file file: Audio file to process (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param str data: Stringified data object conforming to RequestProcessBody
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_process_audio_with_http_info(cid, channels, calldirection, file, **kwargs)  # noqa: E501
        else:
            (data) = self.send_process_audio_with_http_info(cid, channels, calldirection, file, **kwargs)  # noqa: E501
            return data

    def send_process_audio_with_http_info(self, cid, channels, calldirection, file, **kwargs):  # noqa: E501
        """send_process_audio  # noqa: E501

        Sends a new request with audio file upload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_audio_with_http_info(cid, channels, calldirection, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param file file: Audio file to process (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param str data: Stringified data object conforming to RequestProcessBody
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'channels', 'calldirection', 'file', 'name', 'customer_id', 'customer_ind', 'agent_team', 'agent_id', 'campaign_id', 'calltype', 'ani', 'calltime', 'timezone', 'storedata', 'tag', 'meta', 'predictionmode', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_process_audio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `send_process_audio`")  # noqa: E501
        # verify the required parameter 'channels' is set
        if ('channels' not in params or
                params['channels'] is None):
            raise ValueError("Missing the required parameter `channels` when calling `send_process_audio`")  # noqa: E501
        # verify the required parameter 'calldirection' is set
        if ('calldirection' not in params or
                params['calldirection'] is None):
            raise ValueError("Missing the required parameter `calldirection` when calling `send_process_audio`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `send_process_audio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'customer_id' in params:
            query_params.append(('customerId', params['customer_id']))  # noqa: E501
        if 'customer_ind' in params:
            query_params.append(('customerInd', params['customer_ind']))  # noqa: E501
        if 'agent_team' in params:
            query_params.append(('agentTeam', params['agent_team']))  # noqa: E501
        if 'agent_id' in params:
            query_params.append(('agentId', params['agent_id']))  # noqa: E501
        if 'campaign_id' in params:
            query_params.append(('campaignId', params['campaign_id']))  # noqa: E501
        if 'calltype' in params:
            query_params.append(('calltype', params['calltype']))  # noqa: E501
        if 'ani' in params:
            query_params.append(('ANI', params['ani']))  # noqa: E501
        if 'calltime' in params:
            query_params.append(('calltime', params['calltime']))  # noqa: E501
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'channels' in params:
            query_params.append(('channels', params['channels']))  # noqa: E501
        if 'calldirection' in params:
            query_params.append(('calldirection', params['calldirection']))  # noqa: E501
        if 'storedata' in params:
            query_params.append(('storedata', params['storedata']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'meta' in params:
            query_params.append(('meta', params['meta']))  # noqa: E501
        if 'predictionmode' in params:
            query_params.append(('predictionmode', params['predictionmode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'data' in params:
            form_params.append(('data', params['data']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/audio', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Process',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_process_tcp(self, cid, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_tcp  # noqa: E501

        Sends a new request in stream mode  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_tcp(cid, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str tasks: Call tasks json with properties not covered in query parameters
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_process_tcp_with_http_info(cid, channels, calldirection, **kwargs)  # noqa: E501
        else:
            (data) = self.send_process_tcp_with_http_info(cid, channels, calldirection, **kwargs)  # noqa: E501
            return data

    def send_process_tcp_with_http_info(self, cid, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_tcp  # noqa: E501

        Sends a new request in stream mode  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_tcp_with_http_info(cid, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str tasks: Call tasks json with properties not covered in query parameters
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'channels', 'calldirection', 'name', 'customer_id', 'customer_ind', 'agent_team', 'agent_id', 'campaign_id', 'calltype', 'ani', 'calltime', 'timezone', 'storedata', 'tag', 'meta', 'tasks']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_process_tcp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `send_process_tcp`")  # noqa: E501
        # verify the required parameter 'channels' is set
        if ('channels' not in params or
                params['channels'] is None):
            raise ValueError("Missing the required parameter `channels` when calling `send_process_tcp`")  # noqa: E501
        # verify the required parameter 'calldirection' is set
        if ('calldirection' not in params or
                params['calldirection'] is None):
            raise ValueError("Missing the required parameter `calldirection` when calling `send_process_tcp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'customer_id' in params:
            query_params.append(('customerId', params['customer_id']))  # noqa: E501
        if 'customer_ind' in params:
            query_params.append(('customerInd', params['customer_ind']))  # noqa: E501
        if 'agent_team' in params:
            query_params.append(('agentTeam', params['agent_team']))  # noqa: E501
        if 'agent_id' in params:
            query_params.append(('agentId', params['agent_id']))  # noqa: E501
        if 'campaign_id' in params:
            query_params.append(('campaignId', params['campaign_id']))  # noqa: E501
        if 'calltype' in params:
            query_params.append(('calltype', params['calltype']))  # noqa: E501
        if 'ani' in params:
            query_params.append(('ANI', params['ani']))  # noqa: E501
        if 'calltime' in params:
            query_params.append(('calltime', params['calltime']))  # noqa: E501
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'channels' in params:
            query_params.append(('channels', params['channels']))  # noqa: E501
        if 'calldirection' in params:
            query_params.append(('calldirection', params['calldirection']))  # noqa: E501
        if 'storedata' in params:
            query_params.append(('storedata', params['storedata']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'meta' in params:
            query_params.append(('meta', params['meta']))  # noqa: E501
        if 'tasks' in params:
            query_params.append(('tasks', params['tasks']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/stream', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Process',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_process_url(self, cid, url, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_url  # noqa: E501

        Sends a new request with a url for data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_url(cid, url, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str url: Audio url to process (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param RequestProcessBody data:
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_process_url_with_http_info(cid, url, channels, calldirection, **kwargs)  # noqa: E501
        else:
            (data) = self.send_process_url_with_http_info(cid, url, channels, calldirection, **kwargs)  # noqa: E501
            return data

    def send_process_url_with_http_info(self, cid, url, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_url  # noqa: E501

        Sends a new request with a url for data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_url_with_http_info(cid, url, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str url: Audio url to process (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param RequestProcessBody data:
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'url', 'channels', 'calldirection', 'name', 'customer_id', 'customer_ind', 'agent_team', 'agent_id', 'campaign_id', 'calltype', 'ani', 'calltime', 'timezone', 'storedata', 'tag', 'meta', 'predictionmode', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_process_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `send_process_url`")  # noqa: E501
        # verify the required parameter 'url' is set
        if ('url' not in params or
                params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `send_process_url`")  # noqa: E501
        # verify the required parameter 'channels' is set
        if ('channels' not in params or
                params['channels'] is None):
            raise ValueError("Missing the required parameter `channels` when calling `send_process_url`")  # noqa: E501
        # verify the required parameter 'calldirection' is set
        if ('calldirection' not in params or
                params['calldirection'] is None):
            raise ValueError("Missing the required parameter `calldirection` when calling `send_process_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'customer_id' in params:
            query_params.append(('customerId', params['customer_id']))  # noqa: E501
        if 'customer_ind' in params:
            query_params.append(('customerInd', params['customer_ind']))  # noqa: E501
        if 'agent_team' in params:
            query_params.append(('agentTeam', params['agent_team']))  # noqa: E501
        if 'agent_id' in params:
            query_params.append(('agentId', params['agent_id']))  # noqa: E501
        if 'campaign_id' in params:
            query_params.append(('campaignId', params['campaign_id']))  # noqa: E501
        if 'calltype' in params:
            query_params.append(('calltype', params['calltype']))  # noqa: E501
        if 'ani' in params:
            query_params.append(('ANI', params['ani']))  # noqa: E501
        if 'calltime' in params:
            query_params.append(('calltime', params['calltime']))  # noqa: E501
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'channels' in params:
            query_params.append(('channels', params['channels']))  # noqa: E501
        if 'calldirection' in params:
            query_params.append(('calldirection', params['calldirection']))  # noqa: E501
        if 'storedata' in params:
            query_params.append(('storedata', params['storedata']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'meta' in params:
            query_params.append(('meta', params['meta']))  # noqa: E501
        if 'predictionmode' in params:
            query_params.append(('predictionmode', params['predictionmode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Process',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_process_video(self, cid, url, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_video  # noqa: E501

        Sends a new request to process a video file from url  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_video(cid, url, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str url: Video url to process (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param RequestProcessBody data:
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_process_video_with_http_info(cid, url, channels, calldirection, **kwargs)  # noqa: E501
        else:
            (data) = self.send_process_video_with_http_info(cid, url, channels, calldirection, **kwargs)  # noqa: E501
            return data

    def send_process_video_with_http_info(self, cid, url, channels, calldirection, **kwargs):  # noqa: E501
        """send_process_video  # noqa: E501

        Sends a new request to process a video file from url  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_process_video_with_http_info(cid, url, channels, calldirection, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cid: ID of client giving request (required)
        :param str url: Video url to process (required)
        :param int channels: number of channels (required)
        :param int calldirection: 1 for incoming,2 for outgoing (required)
        :param str name: Optionally, a name for the job request
        :param str customer_id: The Customer's ID
        :param str customer_ind: The Customer's Industry Index
        :param str agent_team: Agent’s team ID
        :param str agent_id: Agent's ID
        :param str campaign_id: Campaign's ID
        :param str calltype: The type of call: LA (live answer), AM (answering machine)
        :param str ani: ANI information
        :param datetime calltime: The date and time the call took place
        :param int timezone: The timezone of the call as integer value
        :param int storedata: Request to store incoming process data on a per job basis. If the client has not enabled the datastore option or enabled for all requests (per client basis) then this value is ignored. Can take values 0=no storage, 1=yes.
        :param list[str] tag: Client defined tagging of processing job
        :param str meta: Call metadata json with properties not covered in query parameters
        :param str predictionmode: Sets the prediction mode on process, whether to get predictions based on audio or transcription or both of them.
        :param RequestProcessBody data:
        :return: Process
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'url', 'channels', 'calldirection', 'name', 'customer_id', 'customer_ind', 'agent_team', 'agent_id', 'campaign_id', 'calltype', 'ani', 'calltime', 'timezone', 'storedata', 'tag', 'meta', 'predictionmode', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_process_video" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `send_process_video`")  # noqa: E501
        # verify the required parameter 'url' is set
        if ('url' not in params or
                params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `send_process_video`")  # noqa: E501
        # verify the required parameter 'channels' is set
        if ('channels' not in params or
                params['channels'] is None):
            raise ValueError("Missing the required parameter `channels` when calling `send_process_video`")  # noqa: E501
        # verify the required parameter 'calldirection' is set
        if ('calldirection' not in params or
                params['calldirection'] is None):
            raise ValueError("Missing the required parameter `calldirection` when calling `send_process_video`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'customer_id' in params:
            query_params.append(('customerId', params['customer_id']))  # noqa: E501
        if 'customer_ind' in params:
            query_params.append(('customerInd', params['customer_ind']))  # noqa: E501
        if 'agent_team' in params:
            query_params.append(('agentTeam', params['agent_team']))  # noqa: E501
        if 'agent_id' in params:
            query_params.append(('agentId', params['agent_id']))  # noqa: E501
        if 'campaign_id' in params:
            query_params.append(('campaignId', params['campaign_id']))  # noqa: E501
        if 'calltype' in params:
            query_params.append(('calltype', params['calltype']))  # noqa: E501
        if 'ani' in params:
            query_params.append(('ANI', params['ani']))  # noqa: E501
        if 'calltime' in params:
            query_params.append(('calltime', params['calltime']))  # noqa: E501
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'channels' in params:
            query_params.append(('channels', params['channels']))  # noqa: E501
        if 'calldirection' in params:
            query_params.append(('calldirection', params['calldirection']))  # noqa: E501
        if 'storedata' in params:
            query_params.append(('storedata', params['storedata']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
            collection_formats['tag'] = 'csv'  # noqa: E501
        if 'meta' in params:
            query_params.append(('meta', params['meta']))  # noqa: E501
        if 'predictionmode' in params:
            query_params.append(('predictionmode', params['predictionmode']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/client/{cid}/process/video', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Process',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_status(self, **kwargs):  # noqa: E501
        """service_status  # noqa: E501

        Return status of the service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.service_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.service_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def service_status_with_http_info(self, **kwargs):  # noqa: E501
        """service_status  # noqa: E501

        Return status of the service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Status',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
