import cython
import numpy as np
import nss_c as nss
from scipy.optimize import minimize


# Regras das relações entre as variáveis
cons = ({'type': 'ineq', 'fun': lambda x: x[0] + x[1]},
        {'type': 'ineq', 'fun': lambda x: x[5] - x[4]})


@cython.cdivision(False)
@cython.boundscheck(False)
@cython.wraparound(False)
@cython.nonecheck(False)
cpdef double nss_sse(double[:] params, double[:,:] neg):
    # Encontra a soma do erro ao quadrado ponderado pelo volume
    cdef int i
    cdef double y
    cdef double sse = 0
    for i in range(len(neg)):
        y = nss.nss(params[0], params[1], params[2], params[3], params[4], params[5], neg[i, 0] / 252)
        sse = sse + nss.sse(y, neg[i, 1], neg[i, 2])

    return sse


@cython.cdivision(False)
@cython.boundscheck(False)
@cython.wraparound(False)
@cython.nonecheck(False)
cpdef min_sse(double[:,:] neg):

    cdef int i

    # Encontra o valor da taxa referente ao DU mais longo e mais curto
    tx1 = [0, 0]
    tx2 = [0, 0]
    for i in range(len(neg)):
        if neg[i, 0] > tx1[0]:
            tx1[0] = neg[i, 0]
            tx1[1] = neg[i, 1]
        if neg[i, 0] < tx2[0] or tx2[0] == 0:
            tx2[0] = neg[i, 0]
            tx2[1] = neg[i, 1]

    tx1 = round(tx1[1]/0.0005, 0) * 0.0005
    tx2 = round(tx2[1]/0.0005, 0) * 0.0005

    # Encontra a taxa mímina
    minimo = np.min(neg, axis=0)
    minimo = round(minimo[1]/0.0005, 0) * 0.0005

    # Encontra a taxa máxima
    maximo = np.max(neg, axis=0)
    maximo = round(maximo[1]/0.0005, 0) * 0.0005

    # limites das váriáveis do problema
    if minimo > 0:
        bounds = ((0.8 * minimo, 1.2 * maximo), (-2.0, 2.0), (-2.0, 2.0), (-2.0, 2.0), (0.0, 4.0), (0.0, 30.0))
    else:
        if maximo > 0:
            bounds = ((1.2 * minimo, 1.2 * maximo), (-2.0, 2.0), (-2.0, 2.0), (-2.0, 2.0), (0.0, 4.0), (0.0, 30.0))
        else:
            bounds = ((1.2 * minimo, 0.8 * maximo), (-2.0, 2.0), (-2.0, 2.0), (-2.0, 2.0), (0.0, 4.0), (0.0, 30.0))

    # Caso informe valor de inicio (ex.: param de d-1), utiliza ele
    ini_param = np.array([[tx1, (tx2-tx1), 0.0, 0.0, 1.0, 3.0],[tx1, (tx2-tx1), 0.0, 0.0, 1.0, 6.0],[tx1, (tx2-tx1), 0.0, 0.0, 1.0, 10.0],[tx1, (tx2-tx1), 0.0, 0.0, 1.0, 15.0],[tx1, (tx2-tx1), 0.0, 0.0, 1.0, 20.0],[tx1, (tx2-tx1), 0.0, 0.0, 3.0, 3.0],[tx1, (tx2-tx1), 0.0, 0.0, 3.0, 6.0],[tx1, (tx2-tx1), 0.0, 0.0, 3.0, 10.0],[tx1, (tx2-tx1), 0.0, 0.0, 3.0, 15.0],[tx1, (tx2-tx1), 0.0, 0.0, 3.0, 20.0]])

    for i in range(len(ini_param)):
        result = minimize(nss_sse, ini_param[i, :], args=neg, method='trust-constr', bounds=bounds, constraints=cons, options={'maxiter': 1000})

        # Salva o valor da função de minimização
        if i == 0:
            out = result

        else:
            if float(out.fun) > float(result.fun):
                out = result

    return out
