#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import os
import sys

tests = ['test_air_cooler', 'test_boiling_flow', 'test_boiling_nucleic', 'test_boiling_plate', 'test_condensation', 'test_conduction', 'test_conv_external', 'test_conv_free_immersed', 'test_conv_free_enclosed', 'test_conv_internal', 'test_conv_jacket', 'test_conv_packed_bed', 'test_conv_plate', 'test_conv_supercritical', 'test_conv_tube_bank', 'test_conv_two_phase', 'test_core', 'test_hx', 'test_radiation']
try:
    os.remove("monkeytype.sqlite3")
except:
    pass

for t in tests:
    os.system("python3 -m monkeytype run manual_runner.py %s" %t)
for t in tests:
    mod = t[5:]
    os.system("python3 -m monkeytype stub ht.%s > ../ht/%s.pyi" %(mod, mod))
    type_hit_path = "../ht/%s.pyi" %mod
    dat = open(type_hit_path, 'r').read()
    imports = 'from typing import List\n'
    dat = '# DO NOT EDIT - AUTOMATICALLY GENERATED BY tests/make_test_stubs.py!\n' + imports + dat
    dat = dat.replace('Union[int, float]', 'float')
    dat = dat.replace('Union[float, int]', 'float')
    dat += '\n__all__: List[str]'
    open(type_hit_path, 'w').write(dat)

try:
    os.remove("monkeytype.sqlite3")
except:
    pass
