# -*- coding: utf-8 -*-
# Copyright (c) 2016, 2017, 2018 Sqreen. All rights reserved.
# Please refer to our terms for more information:
#
#     https://www.sqreen.io/terms.html
#
""" Pyramid hook strategy
"""

from logging import getLogger

from ..middlewares import PyramidMiddleware
from .framework import FrameworkStrategy

LOGGER = getLogger(__name__)


def tween_call_insert(original, middleware):

    def wrapped_tween_call(self, handler, *args, **kwargs):
        LOGGER.debug("Execute tween_call_insert")
        new_handler = middleware(handler)

        return original(self, new_handler, *args, **kwargs)

    return wrapped_tween_call


class PyramidStrategy(FrameworkStrategy):
    """ Strategy for Pyramid peripheric callbacks.

    It injects a custom DjangoFramework that calls callbacks for each
    lifecycle method
    """

    MODULE_NAME = "pyramid.config.tweens"
    HOOK_CLASS = "Tweens"
    HOOK_METHOD = "__call__"

    def __init__(self, strategy_key, observation_queue, queue, import_hook, before_hook_point=None):
        super(PyramidStrategy, self).__init__(strategy_key, observation_queue, queue,
                                              import_hook, before_hook_point)

        self.middleware = PyramidMiddleware(self, observation_queue, queue)
        self.wrapper = tween_call_insert
