#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Aug  6 18:13:17 2020

@author: seangao
"""

from nltk.tokenize import TweetTokenizer

emoticon_lst = [':)',
 ':-)',
 ':)',
 ':-]',
 ':]',
 ':-3',
 ':3',
 ':->',
 ':>',
 '8-)',
 '8)',
 ':-}',
 ':}',
 ':o)',
 ':c)',
 ':^)',
 '=]',
 '=)',
 ':-D',
 ':D',
 '8-D',
 '8D',
 'x-D',
 'xD',
 'X-D',
 'XD',
 '=D',
 '=3',
 'B^D',
 ':-))',
 ':-(',
 ':(',
 ':-c',
 ':c',
 ':-<',
 ':<',
 ':-[',
 ':[',
 ':-||',
 '>:[',
 ':{',
 ':@',
 '>:(',
 "('_')",
 '(/_;)',
 '(T_T)',
 '(;_;)',
 '(;_;',
 '(;_:)',
 '(;O;)',
 '(:_;)',
 '(ToT)',
 '(Ｔ▽Ｔ)',
 ';_;',
 ';-;',
 ';n;',
 ';;',
 'Q.Q',
 'T.T',
 'TnT',
 'QQ',
 'Q_Q',
 '(ー_ー)!!',
 '(-.-)',
 '(-_-)',
 '(一一)',
 '(；一_一)',
 '＼(~o~)／',
 '＼(^o^)／',
 '＼(-o-)／',
 'ヽ(^。^)ノ',
 'ヽ(^o^)丿',
 '(*^0^*)',
 ":'-(",
 ":'(",
 ":'-)",
 ":')",
 "D-':",
 'D:<',
 'D:',
 'D8',
 'D;',
 'D=',
 'DX',
 ':-O',
 ':O',
 ':-o',
 ':o',
 ':-0',
 '8-0',
 '>:O',
 '(￣□￣;)',
 '°o°',
 '°O°',
 ':O',
 'o_0',
 'o.O',
 '(o.o)',
 'oO',
 ':-*',
 ':*',
 ':×',
 ';-)',
 ';)',
 '*-)',
 '*)',
 ';-]',
 ';]',
 ';^)',
 ':-,',
 ';D',
 ':-P',
 ':P',
 'X-P',
 'XP',
 'x-p',
 'xp',
 ':-p',
 ':p',
 ':-Þ',
 ':Þ',
 ':-þ',
 ':þ',
 ':-b',
 ':b',
 'd:',
 '=p',
 '>:P',
 ':-/',
 ':/',
 ':-.',
 '>:\\',
 '>:/',
 ':\\',
 '=/',
 '=\\',
 ':L',
 '=L',
 ':S',
 ':-|',
 ':|',
 ':$',
 '://)',
 '://3',
 '(^^ゞ',
 '(^_^;)',
 '(-_-;)',
 '(~_~;)',
 '(・.・;)',
 '(・_・;)',
 '(・・;)^^',
 ';^_^;',
 '(#^.^#)',
 '(^^;)',
 ':-X',
 ':X',
 ':-#',
 ':#',
 ':-&',
 ':&',
 'O:-)',
 'O:)',
 '0:-3',
 '0:3',
 '0:-)',
 '0:)',
 '0;^)',
 '>:-)',
 '>:)',
 '}:-)',
 '}:)',
 '3:-)',
 '3:)',
 '>;)',
 '>:3',
 '>;3',
 ':‑J',
 '#‑)',
 '|;-)',
 '|-O',
 '%-)',
 '%)',
 ':-###..',
 ':###.',
 '<:-|',
 '(>_<)',
 '(>_<)>',
 '((+_+))',
 '(+o+)',
 '(°°)',
 '(°-°)',
 '(°.°)',
 '(°_°)',
 '(°_°>)',
 '(°レ°)',
 '^_^',
 '(°o°)',
 '(^_^)/',
 '(^O^)／',
 '(^o^)／',
 '(^^)/',
 '(-∇-)/',
 '(/-ヮ-)/',
 '(^o^)丿',
 '∩(·ω·)∩',
 '(·ω·)',
 '^ω^',
 '"(-""-)"',
 '(ーー゛)',
 '(^_^メ)',
 '(-_-メ)',
 '(~_~メ)',
 '(－－〆)',
 '(・へ・)',
 '(｀´)',
 '<`～´>',
 '<`ヘ´>',
 '(ーー;)']

meaning_lst = ['Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Smile',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Laugh',
 'Very Happy',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Sad',
 'Shame',
 'Shame',
 'Shame',
 'Shame',
 'Shame',
 'Exited',
 'Exited',
 'Exited',
 'Exited',
 'Exited',
 'Exited',
 'Crying',
 'Crying',
 'Tears Happiness',
 'Tears Happiness',
 'Disgust',
 'Disgust',
 'Disgust',
 'Disgust',
 'Disgust',
 'Disgust',
 'Disgust',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'o_O Shock',
 'Shock',
 'Shock',
 'Shock',
 'Shock',
 'Kiss',
 'Kiss',
 'Kiss',
 'Smirk',
 'Smirk',
 'Smirk',
 'Smirk',
 'Smirk',
 'Smirk',
 'Smirk',
 'Smirk Smirk',
 'Smirk Smirk',
 'Cheeky Smirk',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Cheeky',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Annoyed',
 'Indecision Annoyed',
 'Indecision',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Embarrassed',
 'Shut',
 'Shut',
 'Shut',
 'Shut',
 'Shut',
 'Shut',
 'Innocent',
 'Innocent',
 'Innocent',
 'Innocent',
 'Innocent',
 'Innocent',
 'Innocent',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Evil',
 'Tongue in Cheek Evil',
 'Party all night Evil',
 'Cool',
 'Cool',
 'Drunk',
 'Drunk',
 'Sick',
 'Sick',
 'Dumb',
 'Troubled',
 'Troubled',
 'Confused',
 'Confused',
 'Confused',
 'Confused',
 'Confused',
 'Confused',
 'Confused',
 'Confused',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Joyful',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried',
 'Worried']

def emoticon_fix(input_string):
    input_string_lst = TweetTokenizer().tokenize(input_string)
    
    output_lst = []
    for w in input_string_lst:
        if w in emoticon_lst:
            w_output = meaning_lst[emoticon_lst.index(w)]
        else:
            w_output = w
        output_lst.append(w_output)
    
    output_string = ' '.join([str(x) for x in output_lst])         
    return output_string