/* Generated by drgndoc.docstrings. */

const char drgn_DOC[] =
	"libdrgn bindings\n"
	"\n"
	"Don't use this module directly. Instead, use the drgn package.";
const char drgn_IntegerLike_DOC[] =
	"Bases: Protocol\n"
	"\n"
	"An :class:`int` or integer-like object.\n"
	"\n"
	"Parameters annotated with this type expect an integer which may be given as\n"
	"a Python :class:`int` or an :class:`Object` with integer type.";
const char drgn_Path_DOC[] =
	"Filesystem path.\n"
	"\n"
	"Parameters annotated with this type accept a filesystem path as :class:`str`,\n"
	":class:`bytes`, or :class:`os.PathLike`.";
const char drgn_Program_DOC[] =
	"A ``Program`` represents a crashed or running program. It can be used to\n"
	"lookup type definitions, access variables, and read arbitrary memory.\n"
	"\n"
	"The main functionality of a ``Program`` is looking up objects (i.e.,\n"
	"variables, constants, or functions). This is usually done with the\n"
	":meth:`[] <.__getitem__>` operator.\n"
	"\n"
	"Program(platform: Optional[Platform] = None)\n"
	"\n"
	"Create a ``Program`` with no target program. It is usually more\n"
	"convenient to use one of the :ref:`api-program-constructors`.\n"
	"\n"
	":param platform: The platform of the program, or ``None`` if it should\n"
	"    be determined automatically when a core dump or symbol file is\n"
	"    added.";
const char drgn_Program_flags_DOC[] =
	"_drgn.ProgramFlags\n"
	"\n"
	"Flags which apply to this program.";
const char drgn_Program_platform_DOC[] =
	"Optional[_drgn.Platform]\n"
	"\n"
	"Platform that this program runs on, or ``None`` if it has not been\n"
	"determined yet.";
const char drgn_Program_language_DOC[] =
	"_drgn.Language\n"
	"\n"
	"Default programming language of the program.\n"
	"\n"
	"This is used for interpreting the type name given to :meth:`type()` and\n"
	"when creating an :class:`Object` without an explicit type.\n"
	"\n"
	"For the Linux kernel, this defaults to :attr:`Language.C`. For userspace\n"
	"programs, this defaults to the language of ``main`` in the program, falling\n"
	"back to :attr:`Language.C`. This heuristic may change in the future.\n"
	"\n"
	"This can be explicitly set to a different language (e.g., if the heuristic\n"
	"was incorrect).";
const char drgn_Program___getitem___DOC[] =
	"__getitem__(name: str) -> _drgn.Object\n"
	"\n"
	"Implement ``self[name]``. Get the object (variable, constant, or\n"
	"function) with the given name.\n"
	"\n"
	"This is equivalent to ``prog.object(name)`` except that this raises\n"
	":exc:`KeyError` instead of :exc:`LookupError` if no objects with the\n"
	"given name are found.\n"
	"\n"
	"If there are multiple objects with the same name, one is returned\n"
	"arbitrarily. In this case, the :meth:`variable()`, :meth:`constant()`,\n"
	":meth:`function()`, or :meth:`object()` methods can be used instead.\n"
	"\n"
	">>> prog['jiffies']\n"
	"Object(prog, 'volatile unsigned long', address=0xffffffff94c05000)\n"
	"\n"
	":param name: Object name.";
const char drgn_Program___contains___DOC[] =
	"__contains__(name: str) -> bool\n"
	"\n"
	"Implement ``name in self``. Return whether an object (variable,\n"
	"constant, or function) with the given name exists in the program.\n"
	"\n"
	":param name: Object name.";
const char drgn_Program_variable_DOC[] =
	"variable(name: str, filename: Optional[str] = None) -> _drgn.Object\n"
	"\n"
	"Get the variable with the given name.\n"
	"\n"
	">>> prog.variable('jiffies')\n"
	"Object(prog, 'volatile unsigned long', address=0xffffffff94c05000)\n"
	"\n"
	"This is equivalent to ``prog.object(name, FindObjectFlags.VARIABLE,\n"
	"filename)``.\n"
	"\n"
	":param name: The variable name.\n"
	":param filename: The source code file that contains the definition. See\n"
	"    :ref:`api-filenames`.\n"
	":raises LookupError: if no variables with the given name are found in\n"
	"    the given file";
const char drgn_Program_constant_DOC[] =
	"constant(name: str, filename: Optional[str] = None) -> _drgn.Object\n"
	"\n"
	"Get the constant (e.g., enumeration constant) with the given name.\n"
	"\n"
	"Note that support for macro constants is not yet implemented for DWARF\n"
	"files, and most compilers don't generate macro debugging information by\n"
	"default anyways.\n"
	"\n"
	">>> prog.constant('PIDTYPE_MAX')\n"
	"Object(prog, 'enum pid_type', value=4)\n"
	"\n"
	"This is equivalent to ``prog.object(name, FindObjectFlags.CONSTANT,\n"
	"filename)``.\n"
	"\n"
	":param name: The constant name.\n"
	":param filename: The source code file that contains the definition. See\n"
	"    :ref:`api-filenames`.\n"
	":raises LookupError: if no constants with the given name are found in\n"
	"    the given file";
const char drgn_Program_function_DOC[] =
	"function(name: str, filename: Optional[str] = None) -> _drgn.Object\n"
	"\n"
	"Get the function with the given name.\n"
	"\n"
	">>> prog.function('schedule')\n"
	"Object(prog, 'void (void)', address=0xffffffff94392370)\n"
	"\n"
	"This is equivalent to ``prog.object(name, FindObjectFlags.FUNCTION,\n"
	"filename)``.\n"
	"\n"
	":param name: The function name.\n"
	":param filename: The source code file that contains the definition. See\n"
	"    :ref:`api-filenames`.\n"
	":raises LookupError: if no functions with the given name are found in\n"
	"    the given file";
const char drgn_Program_object_DOC[] =
	"object(name: str, flags: _drgn.FindObjectFlags = _drgn.FindObjectFlags.ANY, filename: Optional[str] = None) -> _drgn.Object\n"
	"\n"
	"Get the object (variable, constant, or function) with the given name.\n"
	"\n"
	":param name: The object name.\n"
	":param flags: Flags indicating what kind of object to look for.\n"
	":param filename: The source code file that contains the definition. See\n"
	"    :ref:`api-filenames`.\n"
	":raises LookupError: if no objects with the given name are found in\n"
	"    the given file";
const char drgn_Program_symbol_DOC[] =
	"symbol(address_or_name: Union[_drgn.IntegerLike, str]) -> _drgn.Symbol\n"
	"\n"
	"Get a symbol containing the given address, or a symbol with the given\n"
	"name.\n"
	"\n"
	"Global symbols are preferred over weak symbols, and weak symbols are\n"
	"preferred over other symbols. In other words: if a matching\n"
	":attr:`SymbolBinding.GLOBAL` or :attr:`SymbolBinding.UNIQUE` symbol is\n"
	"found, it is returned. Otherwise, if a matching\n"
	":attr:`SymbolBinding.WEAK` symbol is found, it is returned. Otherwise,\n"
	"any matching symbol (e.g., :attr:`SymbolBinding.LOCAL`) is returned. If\n"
	"there are multiple matching symbols with the same binding, one is\n"
	"returned arbitrarily. To retrieve all matching symbols, use\n"
	":meth:`symbols()`.\n"
	"\n"
	":param address_or_name: Address or name to search for. This parameter\n"
	"    is positional-only.\n"
	":raises LookupError: if no symbol contains the given address or matches\n"
	"    the given name";
const char drgn_Program_symbols_DOC[] =
	"symbols(address_or_name: Union[None, _drgn.IntegerLike, str] = None) -> List[_drgn.Symbol]\n"
	"\n"
	"Get a list of global and local symbols, optionally matching a name or\n"
	"address.\n"
	"\n"
	"If a string argument is given, this returns all symbols matching that\n"
	"name. If an integer-like argument given, this returns a list of all\n"
	"symbols containing that address. If no argument is given, all symbols\n"
	"in the program are returned. In all cases, the symbols are returned in\n"
	"an unspecified order.\n"
	"\n"
	":param address_or_name: Address or name to search for. This parameter\n"
	"    is positional-only.";
const char drgn_Program_stack_trace_DOC[] =
	"stack_trace(thread: Union[_drgn.Object, _drgn.IntegerLike]) -> _drgn.StackTrace\n"
	"\n"
	"Get the stack trace for the given thread in the program.\n"
	"\n"
	"``thread`` may be a thread ID (as defined by `gettid(2)\n"
	"<http://man7.org/linux/man-pages/man2/gettid.2.html>`_), in which case\n"
	"this will unwind the stack for the thread with that ID. The ID may be a\n"
	"Python ``int`` or an integer :class:`Object`\n"
	"\n"
	"``thread`` may also be a ``struct pt_regs`` or ``struct pt_regs *``\n"
	"object, in which case the initial register values will be fetched from\n"
	"that object.\n"
	"\n"
	"Finally, if debugging the Linux kernel, ``thread`` may be a ``struct\n"
	"task_struct *`` object, in which case this will unwind the stack for\n"
	"that task. See :func:`drgn.helpers.linux.pid.find_task()`.\n"
	"\n"
	"This is implemented for the Linux kernel (both live and core dumps) as\n"
	"well as userspace core dumps; it is not yet implemented for live\n"
	"userspace processes.\n"
	"\n"
	":param thread: Thread ID, ``struct pt_regs`` object, or\n"
	"    ``struct task_struct *`` object.";
const char drgn_Program_type_DOC[] =
	"type(name: str, filename: Optional[str] = None) -> _drgn.Type\n"
	"\n"
	"Get the type with the given name.\n"
	"\n"
	">>> prog.type('long')\n"
	"prog.int_type(name='long', size=8, is_signed=True)\n"
	"\n"
	":param name: The type name.\n"
	":param filename: The source code file that contains the definition. See\n"
	"    :ref:`api-filenames`.\n"
	":raises LookupError: if no types with the given name are found in\n"
	"    the given file\n"
	"\n"
	"type(type: _drgn.Type) -> _drgn.Type\n"
	"\n"
	"Return the given type.\n"
	"\n"
	"This is mainly useful so that helpers can use ``prog.type()`` to get a\n"
	":class:`Type` regardless of whether they were given a :class:`str` or a\n"
	":class:`Type`. For example:\n"
	"\n"
	".. code-block:: python3\n"
	"\n"
	"    def my_helper(obj: Object, type: Union[str, Type]) -> bool:\n"
	"        # type may be str or Type.\n"
	"        type = obj.prog_.type(type)\n"
	"        # type is now always Type.\n"
	"        return sizeof(obj) > sizeof(type)\n"
	"\n"
	":param type: Type.\n"
	":return: The exact same type.";
const char drgn_Program_threads_DOC[] =
	"threads() -> Iterator[_drgn.Thread]\n"
	"\n"
	"Get an iterator over all of the threads in the program.";
const char drgn_Program_thread_DOC[] =
	"thread(tid: _drgn.IntegerLike) -> _drgn.Thread\n"
	"\n"
	"Get the thread with the given thread ID.\n"
	"\n"
	":param tid: Thread ID (as defined by `gettid(2)\n"
	"    <http://man7.org/linux/man-pages/man2/gettid.2.html>`_).\n"
	":raises LookupError: if no thread has the given thread ID";
const char drgn_Program_main_thread_DOC[] =
	"main_thread() -> _drgn.Thread\n"
	"\n"
	"Get the main thread of the program.\n"
	"\n"
	"This is only defined for userspace programs.\n"
	"\n"
	":raises ValueError: if the program is the Linux kernel";
const char drgn_Program_crashed_thread_DOC[] =
	"crashed_thread() -> _drgn.Thread\n"
	"\n"
	"Get the thread that caused the program to crash.\n"
	"\n"
	"For userspace programs, this is the thread that received the fatal\n"
	"signal (e.g., ``SIGSEGV`` or ``SIGQUIT``).\n"
	"\n"
	"For the kernel, this is the thread that panicked (either directly or as\n"
	"a result of an oops, ``BUG_ON()``, etc.).\n"
	"\n"
	":raises ValueError: if the program is live (i.e., not a core dump)";
const char drgn_Program_read_DOC[] =
	"read(address: _drgn.IntegerLike, size: _drgn.IntegerLike, physical: bool = False) -> bytes\n"
	"\n"
	"Read *size* bytes of memory starting at *address* in the program. The\n"
	"address may be virtual (the default) or physical if the program\n"
	"supports it.\n"
	"\n"
	">>> prog.read(0xffffffffbe012b40, 16)\n"
	"b'swapper/0\0\0\0\0\0\0\0'\n"
	"\n"
	":param address: The starting address.\n"
	":param size: The number of bytes to read.\n"
	":param physical: Whether *address* is a physical memory address. If\n"
	"    ``False``, then it is a virtual memory address. Physical memory can\n"
	"    usually only be read when the program is an operating system\n"
	"    kernel.\n"
	":raises FaultError: if the address range is invalid or the type of\n"
	"    address (physical or virtual) is not supported by the program\n"
	":raises ValueError: if *size* is negative";
const char drgn_Program_read_u8_DOC[] =
	"read_u8(address: _drgn.IntegerLike, physical: bool = False) -> int";
const char drgn_Program_read_u16_DOC[] =
	"read_u16(address: _drgn.IntegerLike, physical: bool = False) -> int";
const char drgn_Program_read_u32_DOC[] =
	"read_u32(address: _drgn.IntegerLike, physical: bool = False) -> int";
const char drgn_Program_read_u64_DOC[] =
	"read_u64(address: _drgn.IntegerLike, physical: bool = False) -> int";
const char drgn_Program_read_word_DOC[] =
	"read_word(address: _drgn.IntegerLike, physical: bool = False) -> int\n"
	"\n"
	"Read an unsigned integer from the program's memory in the program's\n"
	"byte order.\n"
	"\n"
	":meth:`read_u8()`, :meth:`read_u16()`, :meth:`read_u32()`, and\n"
	":meth:`read_u64()` read an 8-, 16-, 32-, or 64-bit unsigned integer,\n"
	"respectively. :meth:`read_word()` reads a program word-sized unsigned\n"
	"integer.\n"
	"\n"
	"For signed integers, alternate byte order, or other formats, you can\n"
	"use :meth:`read()` and :meth:`int.from_bytes()` or the :mod:`struct`\n"
	"module.\n"
	"\n"
	":param address: Address of the integer.\n"
	":param physical: Whether *address* is a physical memory address; see\n"
	"    :meth:`read()`.\n"
	":raises FaultError: if the address is invalid; see :meth:`read()`";
const char drgn_Program_add_memory_segment_DOC[] =
	"add_memory_segment(address: _drgn.IntegerLike, size: _drgn.IntegerLike, read_fn: Callable[[int, int, int, bool], bytes], physical: bool = False) -> None\n"
	"\n"
	"Define a region of memory in the program.\n"
	"\n"
	"If it overlaps a previously registered segment, the new segment takes\n"
	"precedence.\n"
	"\n"
	":param address: Address of the segment.\n"
	":param size: Size of the segment in bytes.\n"
	":param physical: Whether to add a physical memory segment. If\n"
	"    ``False``, then this adds a virtual memory segment.\n"
	":param read_fn: Callable to call to read memory from the segment. It is\n"
	"    passed the address being read from, the number of bytes to read,\n"
	"    the offset in bytes from the beginning of the segment, and whether\n"
	"    the address is physical: ``(address, count, offset, physical)``. It\n"
	"    should return the requested number of bytes as :class:`bytes` or\n"
	"    another :ref:`buffer <python:binaryseq>` type.";
const char drgn_Program_add_type_finder_DOC[] =
	"add_type_finder(fn: Callable[[_drgn.TypeKind, str, Optional[str]], _drgn.Type]) -> None\n"
	"\n"
	"Register a callback for finding types in the program.\n"
	"\n"
	"Callbacks are called in reverse order of the order they were added\n"
	"until the type is found. So, more recently added callbacks take\n"
	"precedence.\n"
	"\n"
	":param fn: Callable taking a :class:`TypeKind`, name, and filename:\n"
	"    ``(kind, name, filename)``. The filename should be matched with\n"
	"    :func:`filename_matches()`. This should return a :class:`Type`.";
const char drgn_Program_add_object_finder_DOC[] =
	"add_object_finder(fn: Callable[[_drgn.Program, str, _drgn.FindObjectFlags, Optional[str]], _drgn.Object]) -> None\n"
	"\n"
	"Register a callback for finding objects in the program.\n"
	"\n"
	"Callbacks are called in reverse order of the order they were added\n"
	"until the object is found. So, more recently added callbacks take\n"
	"precedence.\n"
	"\n"
	":param fn: Callable taking a program, name, :class:`FindObjectFlags`,\n"
	"    and filename: ``(prog, name, flags, filename)``. The filename\n"
	"    should be matched with :func:`filename_matches()`. This should\n"
	"    return an :class:`Object`.";
const char drgn_Program_set_core_dump_DOC[] =
	"set_core_dump(path: _drgn.Path) -> None\n"
	"\n"
	"Set the program to a core dump.\n"
	"\n"
	"This loads the memory segments from the core dump and determines the\n"
	"mapped executable and libraries. It does not load any debugging\n"
	"symbols; see :meth:`load_default_debug_info()`.\n"
	"\n"
	":param path: Core dump file path.";
const char drgn_Program_set_kernel_DOC[] =
	"set_kernel() -> None\n"
	"\n"
	"Set the program to the running operating system kernel.\n"
	"\n"
	"This loads the memory of the running kernel and thus requires root\n"
	"privileges. It does not load any debugging symbols; see\n"
	":meth:`load_default_debug_info()`.";
const char drgn_Program_set_pid_DOC[] =
	"set_pid(pid: int) -> None\n"
	"\n"
	"Set the program to a running process.\n"
	"\n"
	"This loads the memory of the process and determines the mapped\n"
	"executable and libraries. It does not load any debugging symbols; see\n"
	":meth:`load_default_debug_info()`.\n"
	"\n"
	":param pid: Process ID.";
const char drgn_Program_load_debug_info_DOC[] =
	"load_debug_info(paths: Optional[Iterable[_drgn.Path]] = None, default: bool = False, main: bool = False) -> None\n"
	"\n"
	"Load debugging information for a list of executable or library files.\n"
	"\n"
	"Note that this is parallelized, so it is usually faster to load\n"
	"multiple files at once rather than one by one.\n"
	"\n"
	":param paths: Paths of binary files.\n"
	":param default: Also load debugging information which can automatically\n"
	"    be determined from the program.\n"
	"\n"
	"    For the Linux kernel, this tries to load ``vmlinux`` and any loaded\n"
	"    kernel modules from a few standard locations.\n"
	"\n"
	"    For userspace programs, this tries to load the executable and any\n"
	"    loaded libraries.\n"
	"\n"
	"    This implies ``main=True``.\n"
	":param main: Also load debugging information for the main executable.\n"
	"\n"
	"    For the Linux kernel, this tries to load ``vmlinux``.\n"
	"\n"
	"    This is currently ignored for userspace programs.\n"
	":raises MissingDebugInfoError: if debugging information was not\n"
	"    available for some files; other files with debugging information\n"
	"    are still loaded";
const char drgn_Program_load_default_debug_info_DOC[] =
	"load_default_debug_info() -> None\n"
	"\n"
	"Load debugging information which can automatically be determined from\n"
	"the program.\n"
	"\n"
	"This is equivalent to ``load_debug_info(None, True)``.";
const char drgn_Program_cache_DOC[] =
	"Dict[Any, Any]\n"
	"\n"
	"Dictionary for caching program metadata.\n"
	"\n"
	"This isn't used by drgn itself. It is intended to be used by helpers to\n"
	"cache metadata about the program. For example, if a helper for a program\n"
	"depends on the program version or an optional feature, the helper can\n"
	"detect it and cache it for subsequent invocations:\n"
	"\n"
	".. code-block:: python3\n"
	"\n"
	"    def my_helper(prog):\n"
	"        try:\n"
	"            have_foo = prog.cache['have_foo']\n"
	"        except KeyError:\n"
	"            have_foo = detect_foo_feature(prog)\n"
	"            prog.cache['have_foo'] = have_foo\n"
	"        if have_foo:\n"
	"            return prog['foo']\n"
	"        else:\n"
	"            return prog['bar']";
const char drgn_Program_void_type_DOC[] =
	"void_type(*, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new void type. It has kind :attr:`TypeKind.VOID`.\n"
	"\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_int_type_DOC[] =
	"int_type(name: str, size: _drgn.IntegerLike, is_signed: bool, byteorder: Optional[str] = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new integer type. It has kind :attr:`TypeKind.INT`.\n"
	"\n"
	":param name: :attr:`Type.name`\n"
	":param size: :attr:`Type.size`\n"
	":param is_signed: :attr:`Type.is_signed`\n"
	":param byteorder: :attr:`Type.byteorder`, or ``None`` to use the\n"
	"    program's default byte order.\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_bool_type_DOC[] =
	"bool_type(name: str, size: _drgn.IntegerLike, byteorder: Optional[str] = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new boolean type. It has kind :attr:`TypeKind.BOOL`.\n"
	"\n"
	":param name: :attr:`Type.name`\n"
	":param size: :attr:`Type.size`\n"
	":param byteorder: :attr:`Type.byteorder`, or ``None`` to use the\n"
	"    program's default byte order.\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_float_type_DOC[] =
	"float_type(name: str, size: _drgn.IntegerLike, byteorder: Optional[str] = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new floating-point type. It has kind :attr:`TypeKind.FLOAT`.\n"
	"\n"
	":param name: :attr:`Type.name`\n"
	":param size: :attr:`Type.size`\n"
	":param byteorder: :attr:`Type.byteorder`, or ``None`` to use the\n"
	"    program's default byte order.\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_struct_type_DOC[] =
	"struct_type(tag: Optional[str], size: _drgn.IntegerLike, members: Sequence[_drgn.TypeMember], *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new structure type. It has kind :attr:`TypeKind.STRUCT`.\n"
	"\n"
	":param tag: :attr:`Type.tag`\n"
	":param size: :attr:`Type.size`\n"
	":param members: :attr:`Type.members`\n"
	":param template_parameters: :attr:`Type.template_parameters`\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`\n"
	"\n"
	"struct_type(tag: Optional[str], size: None = None, members: None = None, *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new incomplete structure type.";
const char drgn_Program_union_type_DOC[] =
	"union_type(tag: Optional[str], size: _drgn.IntegerLike, members: Sequence[_drgn.TypeMember], *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new union type. It has kind :attr:`TypeKind.UNION`. Otherwise,\n"
	"this is the same as as :meth:`struct_type()`.\n"
	"\n"
	"union_type(tag: Optional[str], size: None = None, members: None = None, *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new incomplete union type.";
const char drgn_Program_class_type_DOC[] =
	"class_type(tag: Optional[str], size: _drgn.IntegerLike, members: Sequence[_drgn.TypeMember], *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new class type. It has kind :attr:`TypeKind.CLASS`. Otherwise,\n"
	"this is the same as as :meth:`struct_type()`.\n"
	"\n"
	"class_type(tag: Optional[str], size: None = None, members: None = None, *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new incomplete class type.";
const char drgn_Program_enum_type_DOC[] =
	"enum_type(tag: Optional[str], type: _drgn.Type, enumerators: Sequence[_drgn.TypeEnumerator], *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new enumerated type. It has kind :attr:`TypeKind.ENUM`.\n"
	"\n"
	":param tag: :attr:`Type.tag`\n"
	":param type: The compatible integer type (:attr:`Type.type`)\n"
	":param enumerators: :attr:`Type.enumerators`\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`\n"
	"\n"
	"enum_type(tag: Optional[str], type: None = None, enumerators: None = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new incomplete enumerated type.";
const char drgn_Program_typedef_type_DOC[] =
	"typedef_type(name: str, type: _drgn.Type, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new typedef type. It has kind :attr:`TypeKind.TYPEDEF`.\n"
	"\n"
	":param name: :attr:`Type.name`\n"
	":param type: The aliased type (:attr:`Type.type`)\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_pointer_type_DOC[] =
	"pointer_type(type: _drgn.Type, size: Optional[int] = None, byteorder: Optional[str] = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new pointer type. It has kind :attr:`TypeKind.POINTER`,\n"
	"\n"
	":param type: The referenced type (:attr:`Type.type`)\n"
	":param size: :attr:`Type.size`, or ``None`` to use the program's\n"
	"    default pointer size.\n"
	":param byteorder: :attr:`Type.byteorder`, or ``None`` to use the\n"
	"    program's default byte order.\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_array_type_DOC[] =
	"array_type(type: _drgn.Type, length: Optional[int] = None, *, qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new array type. It has kind :attr:`TypeKind.ARRAY`.\n"
	"\n"
	":param type: The element type (:attr:`Type.type`)\n"
	":param length: :attr:`Type.length`\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_Program_function_type_DOC[] =
	"function_type(type: _drgn.Type, parameters: Sequence[_drgn.TypeParameter], is_variadic: bool = False, *, template_parameters: Sequence[_drgn.TypeTemplateParameter] = (), qualifiers: _drgn.Qualifiers = _drgn.Qualifiers.NONE, language: Optional[_drgn.Language] = None) -> _drgn.Type\n"
	"\n"
	"Create a new function type. It has kind :attr:`TypeKind.FUNCTION`.\n"
	"\n"
	":param type: The return type (:attr:`Type.type`)\n"
	":param parameters: :attr:`Type.parameters`\n"
	":param is_variadic: :attr:`Type.is_variadic`\n"
	":param template_parameters: :attr:`Type.template_parameters`\n"
	":param qualifiers: :attr:`Type.qualifiers`\n"
	":param lang: :attr:`Type.language`";
const char drgn_ProgramFlags_DOC[] =
	"Bases: enum.Flag\n"
	"\n"
	"``ProgramFlags`` are flags that can apply to a :class:`Program` (e.g.,\n"
	"about what kind of program it is).";
const char drgn_ProgramFlags_IS_LINUX_KERNEL_DOC[] =
	"The program is the Linux kernel.";
const char drgn_ProgramFlags_IS_LIVE_DOC[] =
	"The program is currently running (e.g., it is the running operating system\n"
	"kernel or a running process).";
const char drgn_FindObjectFlags_DOC[] =
	"Bases: enum.Flag\n"
	"\n"
	"``FindObjectFlags`` are flags for :meth:`Program.object()`. These can be\n"
	"combined to search for multiple kinds of objects at once.";
const char drgn_FindObjectFlags_CONSTANT_DOC[] = "";
const char drgn_FindObjectFlags_FUNCTION_DOC[] = "";
const char drgn_FindObjectFlags_VARIABLE_DOC[] = "";
const char drgn_FindObjectFlags_ANY_DOC[] = "";
const char drgn_Thread_DOC[] =
	"A thread in a program.";
const char drgn_Thread_tid_DOC[] =
	"int\n"
	"\n"
	"Thread ID (as defined by `gettid(2)\n"
	"<http://man7.org/linux/man-pages/man2/gettid.2.html>`_).";
const char drgn_Thread_object_DOC[] =
	"_drgn.Object\n"
	"\n"
	"If the program is the Linux kernel, the ``struct task_struct *`` object for\n"
	"this thread. Otherwise, not defined.";
const char drgn_Thread_stack_trace_DOC[] =
	"stack_trace() -> _drgn.StackTrace\n"
	"\n"
	"Get the stack trace for this thread.\n"
	"\n"
	"This is equivalent to ``prog.stack_trace(thread.tid)``. See\n"
	":meth:`Program.stack_trace()`.";
const char drgn_filename_matches_DOC[] =
	"filename_matches(haystack: Optional[str], needle: Optional[str]) -> bool\n"
	"\n"
	"Return whether a filename containing a definition (*haystack*) matches a\n"
	"filename being searched for (*needle*).\n"
	"\n"
	"The filename is matched from right to left, so ``'stdio.h'``,\n"
	"``'include/stdio.h'``, ``'usr/include/stdio.h'``, and\n"
	"``'/usr/include/stdio.h'`` would all match a definition in\n"
	"``/usr/include/stdio.h``. If *needle* is ``None`` or empty, it matches any\n"
	"definition. If *haystack* is ``None`` or empty, it only matches if *needle*\n"
	"is also ``None`` or empty.\n"
	"\n"
	":param haystack: Path of file containing definition.\n"
	":param needle: Filename to match.";
const char drgn_program_from_core_dump_DOC[] =
	"program_from_core_dump(path: Path) -> Program\n"
	"\n"
	"Create a :class:`Program` from a core dump file. The type of program (e.g.,\n"
	"userspace or kernel) is determined automatically.\n"
	"\n"
	":param path: Core dump file path.";
const char drgn_program_from_kernel_DOC[] =
	"program_from_kernel() -> Program\n"
	"\n"
	"Create a :class:`Program` from the running operating system kernel. This\n"
	"requires root privileges.";
const char drgn_program_from_pid_DOC[] =
	"program_from_pid(pid: int) -> Program\n"
	"\n"
	"Create a :class:`Program` from a running program with the given PID. This\n"
	"requires appropriate permissions (on Linux, :manpage:`ptrace(2)` attach\n"
	"permissions).\n"
	"\n"
	":param pid: Process ID of the program to debug.";
const char drgn_Platform_DOC[] =
	"A ``Platform`` represents the environment (i.e., architecture and ABI) that\n"
	"a program runs on.\n"
	"\n"
	"Platform(arch: Architecture, flags: Optional[PlatformFlags] = None)\n"
	"\n"
	"Create a ``Platform``.\n"
	"\n"
	":param arch: :attr:`Platform.arch`\n"
	":param flags: :attr:`Platform.flags`; if ``None``, default flags for\n"
	"    the architecture are used.";
const char drgn_Platform_arch_DOC[] =
	"_drgn.Architecture\n"
	"\n"
	"Instruction set architecture of this platform.";
const char drgn_Platform_flags_DOC[] =
	"_drgn.PlatformFlags\n"
	"\n"
	"Flags which apply to this platform.";
const char drgn_Platform_registers_DOC[] =
	"Sequence[_drgn.Register]\n"
	"\n"
	"Processor registers on this platform.";
const char drgn_Architecture_DOC[] =
	"Bases: enum.Enum\n"
	"\n"
	"An ``Architecture`` represents an instruction set architecture.";
const char drgn_Architecture_X86_64_DOC[] =
	"The x86-64 architecture, a.k.a. AMD64 or Intel 64.";
const char drgn_Architecture_I386_DOC[] =
	"The 32-bit x86 architecture, a.k.a. i386 or IA-32.";
const char drgn_Architecture_AARCH64_DOC[] =
	"The AArch64 architecture, a.k.a. ARM64.";
const char drgn_Architecture_ARM_DOC[] =
	"The 32-bit Arm architecture.";
const char drgn_Architecture_PPC64_DOC[] =
	"The 64-bit PowerPC architecture.";
const char drgn_Architecture_RISCV64_DOC[] =
	"The 64-bit RISC-V architecture.";
const char drgn_Architecture_RISCV32_DOC[] =
	"The 32-bit RISC-V architecture.";
const char drgn_Architecture_UNKNOWN_DOC[] =
	"An architecture which is not known to drgn. Certain features are not\n"
	"available when the architecture is unknown, but most of drgn will still\n"
	"work.";
const char drgn_PlatformFlags_DOC[] =
	"Bases: enum.Flag\n"
	"\n"
	"``PlatformFlags`` are flags describing a :class:`Platform`.";
const char drgn_PlatformFlags_IS_64_BIT_DOC[] =
	"Platform is 64-bit.";
const char drgn_PlatformFlags_IS_LITTLE_ENDIAN_DOC[] =
	"Platform is little-endian.";
const char drgn_Register_DOC[] =
	"A ``Register`` represents information about a processor register.";
const char drgn_Register_names_DOC[] =
	"Sequence[str]\n"
	"\n"
	"Names of this register.";
const char drgn_host_platform_DOC[] =
	"Platform\n"
	"\n"
	"The platform of the host which is running drgn.";
const char drgn_Language_DOC[] =
	"A ``Language`` represents a programming language supported by drgn.\n"
	"\n"
	"This class cannot be constructed; there are singletons for the supported\n"
	"languages.";
const char drgn_Language_name_DOC[] =
	"str\n"
	"\n"
	"Name of the programming language.";
const char drgn_Language_C_DOC[] =
	"_drgn.Language\n"
	"\n"
	"The C programming language.";
const char drgn_Language_CPP_DOC[] =
	"_drgn.Language\n"
	"\n"
	"The C++ programming language.";
const char drgn_Object_DOC[] =
	"An ``Object`` represents a symbol or value in a program. An object may\n"
	"exist in the memory of the program (a *reference*), it may be a constant or\n"
	"temporary computed value (a *value*), or it may be absent entirely (an\n"
	"*absent* object).\n"
	"\n"
	"All instances of this class have two attributes: :attr:`prog_`, the program\n"
	"that the object is from; and :attr:`type_`, the type of the object.\n"
	"Reference objects also have an :attr:`address_` and a :attr:`bit_offset_`.\n"
	"Objects may also have a :attr:`bit_field_size_`.\n"
	"\n"
	":func:`repr()` of an object returns a Python representation of the object:\n"
	"\n"
	">>> print(repr(prog['jiffies']))\n"
	"Object(prog, 'volatile unsigned long', address=0xffffffffbf005000)\n"
	"\n"
	":class:`str() <str>` returns a \"pretty\" representation of the object in\n"
	"programming language syntax:\n"
	"\n"
	">>> print(prog['jiffies'])\n"
	"(volatile unsigned long)4326237045\n"
	"\n"
	"The output format of ``str()`` can be modified by using the\n"
	":meth:`format_()` method instead:\n"
	"\n"
	">>> sysname = prog['init_uts_ns'].name.sysname\n"
	">>> print(sysname)\n"
	"(char [65])\"Linux\"\n"
	">>> print(sysname.format_(type_name=False))\n"
	"\"Linux\"\n"
	">>> print(sysname.format_(string=False))\n"
	"(char [65]){ 76, 105, 110, 117, 120 }\n"
	"\n"
	".. note::\n"
	"\n"
	"    The drgn CLI is set up so that objects are displayed in the \"pretty\"\n"
	"    format instead of with ``repr()`` (the latter is the default behavior\n"
	"    of Python's interactive mode). Therefore, it's usually not necessary to\n"
	"    call ``print()`` in the drgn CLI.\n"
	"\n"
	"Objects support the following operators:\n"
	"\n"
	"* Arithmetic operators: ``+``, ``-``, ``*``, ``/``, ``%``\n"
	"* Bitwise operators: ``<<``, ``>>``, ``&``, ``|``, ``^``, ``~``\n"
	"* Relational operators: ``==``, ``!=``, ``<``, ``>``, ``<=``, ``>=``\n"
	"* Subscripting: :meth:`[] <__getitem__>` (Python does not have a unary\n"
	"  ``*`` operator, so pointers are dereferenced with ``ptr[0]``)\n"
	"* Member access: :meth:`. <__getattribute__>` (Python does not have a\n"
	"  ``->`` operator, so ``.`` is also used to access members of pointers to\n"
	"  structures)\n"
	"* The address-of operator: :meth:`drgn.Object.address_of_()` (this is a\n"
	"  method because Python does not have a ``&`` operator)\n"
	"* Array length: :meth:`len() <__len__>`\n"
	"\n"
	"These operators all have the semantics of the program's programming\n"
	"language. For example, adding two objects from a program written in C\n"
	"results in an object with a type and value according to the rules of C:\n"
	"\n"
	">>> Object(prog, 'unsigned long', 2**64 - 1) + Object(prog, 'int', 1)\n"
	"Object(prog, 'unsigned long', value=0)\n"
	"\n"
	"If only one operand to a binary operator is an object, the other operand\n"
	"will be converted to an object according to the language's rules for\n"
	"literals:\n"
	"\n"
	">>> Object(prog, 'char', 0) - 1\n"
	"Object(prog, 'int', value=-1)\n"
	"\n"
	"The standard :class:`int() <int>`, :class:`float() <float>`, and\n"
	":class:`bool() <bool>` functions convert an object to that Python type.\n"
	"Conversion to ``bool`` uses the programming language's notion of\n"
	"\"truthiness\". Additionally, certain Python functions will automatically\n"
	"coerce an object to the appropriate Python type (e.g., :func:`hex()`,\n"
	":func:`round()`, and :meth:`list subscripting <object.__getitem__>`).\n"
	"\n"
	"Object attributes and methods are named with a trailing underscore to avoid\n"
	"conflicting with structure, union, or class members. The attributes and\n"
	"methods always take precedence; use :meth:`member_()` if there is a\n"
	"conflict.\n"
	"\n"
	"Objects are usually obtained directly from a :class:`Program`, but they can\n"
	"be constructed manually, as well (for example, if you got a variable\n"
	"address from a log file).\n"
	"\n"
	"Object(prog: Program, type: Union[str, Type], value: Union[IntegerLike, float, bool, Mapping[str, Any], Sequence[Any]], *, bit_field_size: Optional[IntegerLike] = None)\n"
	"\n"
	"Create a value object given its type and value.\n"
	"\n"
	":param prog: Program to create the object in.\n"
	":param type: Type of the object.\n"
	":param value: Value of the object. See :meth:`value_()`.\n"
	":param bit_field_size: Size in bits of the object if it is a bit field.\n"
	"    The default is ``None``, which means the object is not a bit field.\n"
	"\n"
	"Object(prog: Program, *, value: Union[int, float, bool])\n"
	"\n"
	"Create a value object from a \"literal\".\n"
	"\n"
	"This is used to emulate a literal number in the source code of the\n"
	"program. The type is deduced from *value* according to the language's\n"
	"rules for literals.\n"
	"\n"
	":param value: Value of the literal.\n"
	"\n"
	"Object(prog: Program, type: Union[str, Type], *, address: IntegerLike, bit_offset: IntegerLike = 0, bit_field_size: Optional[IntegerLike] = None)\n"
	"\n"
	"Create a reference object.\n"
	"\n"
	":param address: Address of the object in the program.\n"
	":param bit_offset: Offset in bits from *address* to the beginning of\n"
	"    the object.\n"
	"\n"
	"Object(prog: Program, type: Union[str, Type], *, bit_field_size: Optional[IntegerLike] = None)\n"
	"\n"
	"Create an absent object.";
const char drgn_Object_prog__DOC[] =
	"_drgn.Program\n"
	"\n"
	"Program that this object is from.";
const char drgn_Object_type__DOC[] =
	"_drgn.Type\n"
	"\n"
	"Type of this object.";
const char drgn_Object_absent__DOC[] =
	"bool\n"
	"\n"
	"Whether this object is absent.\n"
	"\n"
	"This is ``False`` for all values and references (even if the reference has\n"
	"an invalid address).";
const char drgn_Object_address__DOC[] =
	"Optional[int]\n"
	"\n"
	"Address of this object if it is a reference, ``None`` if it is a value or\n"
	"absent.";
const char drgn_Object_bit_offset__DOC[] =
	"Optional[int]\n"
	"\n"
	"Offset in bits from this object's address to the beginning of the object if\n"
	"it is a reference, ``None`` otherwise. This can only be non-zero for\n"
	"scalars.";
const char drgn_Object_bit_field_size__DOC[] =
	"Optional[int]\n"
	"\n"
	"Size in bits of this object if it is a bit field, ``None`` if it is not.";
const char drgn_Object___getattribute___DOC[] =
	"__getattribute__(name: str) -> _drgn.Object\n"
	"\n"
	"Implement ``self.name``.\n"
	"\n"
	"If *name* is an attribute of the :class:`Object` class, then this\n"
	"returns that attribute. Otherwise, it is equivalent to\n"
	":meth:`member_()`.\n"
	"\n"
	">>> print(prog['init_task'].pid)\n"
	"(pid_t)0\n"
	"\n"
	":param name: Attribute name.";
const char drgn_Object___getitem___DOC[] =
	"__getitem__(idx: _drgn.IntegerLike) -> _drgn.Object\n"
	"\n"
	"Implement ``self[idx]``. Get the array element at the given index.\n"
	"\n"
	">>> print(prog['init_task'].comm[0])\n"
	"(char)115\n"
	"\n"
	"This is only valid for pointers and arrays.\n"
	"\n"
	".. note::\n"
	"\n"
	"    Negative indices behave as they would in the object's language (as\n"
	"    opposed to the Python semantics of indexing from the end of the\n"
	"    array).\n"
	"\n"
	":param idx: The array index.\n"
	":raises TypeError: if this object is not a pointer or array";
const char drgn_Object___len___DOC[] =
	"__len__() -> int\n"
	"\n"
	"Implement ``len(self)``. Get the number of elements in this object.\n"
	"\n"
	">>> len(prog['init_task'].comm)\n"
	"16\n"
	"\n"
	"This is only valid for arrays.\n"
	"\n"
	":raises TypeError: if this object is not an array with complete type";
const char drgn_Object_value__DOC[] =
	"value_() -> Any\n"
	"\n"
	"Get the value of this object as a Python object.\n"
	"\n"
	"For basic types (integer, floating-point, boolean), this returns an\n"
	"object of the directly corresponding Python type (``int``, ``float``,\n"
	"``bool``). For pointers, this returns the address value of the pointer.\n"
	"For enums, this returns an ``int``. For structures and unions, this\n"
	"returns a ``dict`` of members. For arrays, this returns a ``list`` of\n"
	"values.\n"
	"\n"
	":raises FaultError: if reading the object causes a bad memory access\n"
	":raises TypeError: if this object has an unreadable type (e.g.,\n"
	"    ``void``)";
const char drgn_Object_string__DOC[] =
	"string_() -> bytes\n"
	"\n"
	"Read a null-terminated string pointed to by this object.\n"
	"\n"
	"This is only valid for pointers and arrays. The element type is\n"
	"ignored; this operates byte-by-byte.\n"
	"\n"
	"For pointers and flexible arrays, this stops at the first null byte.\n"
	"\n"
	"For complete arrays, this stops at the first null byte or at the end of\n"
	"the array.\n"
	"\n"
	":raises FaultError: if reading the string causes a bad memory access\n"
	":raises TypeError: if this object is not a pointer or array";
const char drgn_Object_member__DOC[] =
	"member_(name: str) -> _drgn.Object\n"
	"\n"
	"Get a member of this object.\n"
	"\n"
	"This is valid for structures, unions, and pointers to either.\n"
	"\n"
	"Normally the dot operator (``.``) can be used to accomplish the same\n"
	"thing, but this method can be used if there is a name conflict with an\n"
	"Object member or method.\n"
	"\n"
	":param name: Name of the member.\n"
	":raises TypeError: if this object is not a structure, union, class, or\n"
	"    a pointer to one of those\n"
	":raises LookupError: if this object does not have a member with the\n"
	"    given name";
const char drgn_Object_address_of__DOC[] =
	"address_of_() -> _drgn.Object\n"
	"\n"
	"Get a pointer to this object.\n"
	"\n"
	"This corresponds to the address-of (``&``) operator in C. It is only\n"
	"possible for reference objects, as value objects don't have an address\n"
	"in the program.\n"
	"\n"
	"As opposed to :attr:`address_`, this returns an ``Object``, not an\n"
	"``int``.\n"
	"\n"
	":raises ValueError: if this object is a value";
const char drgn_Object_read__DOC[] =
	"read_() -> _drgn.Object\n"
	"\n"
	"Read this object (which may be a reference or a value) and return it as\n"
	"a value object.\n"
	"\n"
	"This is useful if the object can change in the running program (but of\n"
	"course nothing stops the program from modifying the object while it is\n"
	"being read).\n"
	"\n"
	"As opposed to :meth:`value_()`, this returns an ``Object``, not a\n"
	"standard Python type.\n"
	"\n"
	":raises FaultError: if reading this object causes a bad memory access\n"
	":raises TypeError: if this object has an unreadable type (e.g.,\n"
	"    ``void``)";
const char drgn_Object_to_bytes__DOC[] =
	"to_bytes_() -> bytes\n"
	"\n"
	"Return the binary representation of this object's value.";
const char drgn_Object_from_bytes__DOC[] =
	"from_bytes_(prog: _drgn.Program, type: Union[str, _drgn.Type], bytes: bytes, *, bit_offset: _drgn.IntegerLike = 0, bit_field_size: Optional[_drgn.IntegerLike] = None) -> _drgn.Object\n"
	"\n"
	"Return a value object from its binary representation.\n"
	"\n"
	":param prog: Program to create the object in.\n"
	":param type: Type of the object.\n"
	":param bytes: Buffer containing value of the object.\n"
	":param bit_offset: Offset in bits from the beginning of *bytes* to the\n"
	"    beginning of the object.\n"
	":param bit_field_size: Size in bits of the object if it is a bit field.\n"
	"    The default is ``None``, which means the object is not a bit field.";
const char drgn_Object_format__DOC[] =
	"format_(*, columns: Optional[_drgn.IntegerLike] = None, dereference: Optional[bool] = None, symbolize: Optional[bool] = None, string: Optional[bool] = None, char: Optional[bool] = None, type_name: Optional[bool] = None, member_type_names: Optional[bool] = None, element_type_names: Optional[bool] = None, members_same_line: Optional[bool] = None, elements_same_line: Optional[bool] = None, member_names: Optional[bool] = None, element_indices: Optional[bool] = None, implicit_members: Optional[bool] = None, implicit_elements: Optional[bool] = None) -> str\n"
	"\n"
	"Format this object in programming language syntax.\n"
	"\n"
	"Various format options can be passed (as keyword arguments) to control\n"
	"the output. Options that aren't passed or are passed as ``None`` fall\n"
	"back to a default. Specifically, ``obj.format_()`` (i.e., with no\n"
	"passed options) is equivalent to ``str(obj)``.\n"
	"\n"
	">>> workqueues = prog['workqueues']\n"
	">>> print(workqueues)\n"
	"(struct list_head){\n"
	"        .next = (struct list_head *)0xffff932ecfc0ae10,\n"
	"        .prev = (struct list_head *)0xffff932e3818fc10,\n"
	"}\n"
	">>> print(workqueues.format_(type_name=False,\n"
	"...                          member_type_names=False,\n"
	"...                          member_names=False,\n"
	"...                          members_same_line=True))\n"
	"{ 0xffff932ecfc0ae10, 0xffff932e3818fc10 }\n"
	"\n"
	":param columns: Number of columns to limit output to when the\n"
	"    expression can be reasonably wrapped. Defaults to no limit.\n"
	":param dereference: If this object is a pointer, include the\n"
	"    dereferenced value. This does not apply to structure, union, or\n"
	"    class members, or array elements, as dereferencing those could lead\n"
	"    to an infinite loop. Defaults to ``True``.\n"
	":param symbolize: Include a symbol name and offset for pointer objects.\n"
	"    Defaults to ``True``.\n"
	":param string: Format the values of objects with string type as strings.\n"
	"    For C, this applies to pointers to and arrays of ``char``, ``signed\n"
	"    char``, and ``unsigned char``. Defaults to ``True``.\n"
	":param char: Format objects with character type as character literals.\n"
	"    For C, this applies to ``char``, ``signed char``, and ``unsigned\n"
	"    char``. Defaults to ``False``.\n"
	":param type_name: Include the type name of this object. Defaults to\n"
	"    ``True``.\n"
	":param member_type_names: Include the type names of structure, union,\n"
	"    and class members. Defaults to ``True``.\n"
	":param element_type_names: Include the type names of array elements.\n"
	"    Defaults to ``False``.\n"
	":param members_same_line: Place multiple structure, union, and class\n"
	"    members on the same line if they fit within the specified\n"
	"    number of ``columns``. Defaults to ``False``.\n"
	":param elements_same_line: Place multiple array elements on the same\n"
	"    line if they fit within the specified number of ``columns``.\n"
	"    Defaults to ``True``.\n"
	":param member_names: Include the names of structure, union, and class\n"
	"    members. Defaults to ``True``.\n"
	":param element_indices: Include the indices of array elements. Defaults\n"
	"    to ``False``.\n"
	":param implicit_members: Include structure, union, and class members\n"
	"    which have an implicit value (i.e., for C, zero-initialized).\n"
	"    Defaults to ``True``.\n"
	":param implicit_elements: Include array elements which have an implicit\n"
	"    value (i.e., for C, zero-initialized). Defaults to ``False``.";
const char drgn_NULL_DOC[] =
	"NULL(prog: Program, type: Union[str, Type]) -> Object\n"
	"\n"
	"Get an object representing ``NULL`` casted to the given type.\n"
	"\n"
	"This is equivalent to ``Object(prog, type, 0)``.\n"
	"\n"
	":param prog: The program.\n"
	":param type: The type.";
const char drgn_cast_DOC[] =
	"cast(type: Union[str, Type], obj: Object) -> Object\n"
	"\n"
	"Get the value of the given object casted to another type.\n"
	"\n"
	"Objects with a scalar type (integer, boolean, enumerated, floating-point,\n"
	"or pointer) can be casted to a different scalar type. Other objects can\n"
	"only be casted to the same type. This always results in a value object. See\n"
	"also :func:`drgn.reinterpret()`.\n"
	"\n"
	":param type: The type to cast to.\n"
	":param obj: The object to cast.";
const char drgn_reinterpret_DOC[] =
	"reinterpret(type: Union[str, Type], obj: Object) -> Object\n"
	"\n"
	"Get a copy of the given object reinterpreted as another type and/or byte\n"
	"order.\n"
	"\n"
	"This reinterprets the raw memory of the object, so an object can be\n"
	"reinterpreted as any other type. However, value objects with a scalar type\n"
	"cannot be reinterpreted, as their memory layout in the program is not\n"
	"known. Reinterpreting a reference results in a reference, and\n"
	"reinterpreting a value results in a value. See also :func:`drgn.cast()`.\n"
	"\n"
	":param type: The type to reinterpret as.\n"
	":param obj: The object to reinterpret.";
const char drgn_container_of_DOC[] =
	"container_of(ptr: Object, type: Union[str, Type], member: str) -> Object\n"
	"\n"
	"Get the containing object of a pointer object.\n"
	"\n"
	"This corresponds to the ``container_of()`` macro in C.\n"
	"\n"
	":param ptr: Pointer to member in containing object.\n"
	":param type: Type of containing object.\n"
	":param member: Name of member in containing object. May include one or more\n"
	"    member references and zero or more array subscripts.\n"
	":return: Pointer to containing object.\n"
	":raises TypeError: if *ptr* is not a pointer or *type* is not a structure,\n"
	"    union, or class type\n"
	":raises ValueError: if the member is not byte-aligned (e.g., because it is\n"
	"    a bit field)\n"
	":raises LookupError: if *type* does not have a member with the given name";
const char drgn_Symbol_DOC[] =
	"A ``Symbol`` represents an entry in the symbol table of a program, i.e., an\n"
	"identifier along with its corresponding address range in the program.";
const char drgn_Symbol_name_DOC[] =
	"str\n"
	"\n"
	"Name of this symbol.";
const char drgn_Symbol_address_DOC[] =
	"int\n"
	"\n"
	"Start address of this symbol.";
const char drgn_Symbol_size_DOC[] =
	"int\n"
	"\n"
	"Size of this symbol in bytes.";
const char drgn_Symbol_binding_DOC[] =
	"_drgn.SymbolBinding\n"
	"\n"
	"Linkage behavior and visibility of this symbol.";
const char drgn_Symbol_kind_DOC[] =
	"_drgn.SymbolKind\n"
	"\n"
	"Kind of entity represented by this symbol.";
const char drgn_SymbolBinding_DOC[] =
	"Bases: enum.Enum\n"
	"\n"
	"A ``SymbolBinding`` describes the linkage behavior and visibility of a\n"
	"symbol.";
const char drgn_SymbolBinding_UNKNOWN_DOC[] =
	"Unknown.";
const char drgn_SymbolBinding_LOCAL_DOC[] =
	"Not visible outside of the object file containing its definition.";
const char drgn_SymbolBinding_GLOBAL_DOC[] =
	"Globally visible.";
const char drgn_SymbolBinding_WEAK_DOC[] =
	"Globally visible but may be overridden by a non-weak global symbol.";
const char drgn_SymbolBinding_UNIQUE_DOC[] =
	"Globally visible even if dynamic shared object is loaded locally. See GCC's\n"
	"``-fno-gnu-unique`` `option\n"
	"<https://gcc.gnu.org/onlinedocs/gcc/Code-Gen-Options.html>`_.";
const char drgn_SymbolKind_DOC[] =
	"Bases: enum.Enum\n"
	"\n"
	"A ``SymbolKind`` describes the kind of entity that a symbol represents.";
const char drgn_SymbolKind_UNKNOWN_DOC[] =
	"Unknown or not defined.";
const char drgn_SymbolKind_OBJECT_DOC[] =
	"Data object (e.g., variable or array).";
const char drgn_SymbolKind_FUNC_DOC[] =
	"Function or other executable code.";
const char drgn_SymbolKind_SECTION_DOC[] =
	"Object file section.";
const char drgn_SymbolKind_FILE_DOC[] =
	"Source file.";
const char drgn_SymbolKind_COMMON_DOC[] =
	"Data object in common block.";
const char drgn_SymbolKind_TLS_DOC[] =
	"Thread-local storage entity.";
const char drgn_SymbolKind_IFUNC_DOC[] =
	"`Indirect function <https://sourceware.org/glibc/wiki/GNU_IFUNC>`_.";
const char drgn_StackTrace_DOC[] =
	"A ``StackTrace`` is a :ref:`sequence <python:typesseq-common>` of\n"
	":class:`StackFrame`.\n"
	"\n"
	"``len(trace)`` is the number of stack frames in the trace. ``trace[0]`` is\n"
	"the innermost stack frame, ``trace[1]`` is its caller, and\n"
	"``trace[len(trace) - 1]`` is the outermost frame. Negative indexing also\n"
	"works: ``trace[-1]`` is the outermost frame and ``trace[-len(trace)]`` is\n"
	"the innermost frame. It is also iterable:\n"
	"\n"
	".. code-block:: python3\n"
	"\n"
	"    for frame in trace:\n"
	"        if frame.name == 'io_schedule':\n"
	"            print('Thread is doing I/O')\n"
	"\n"
	":class:`str() <str>` returns a pretty-printed stack trace:\n"
	"\n"
	">>> prog.stack_trace(1)\n"
	"#0  context_switch (kernel/sched/core.c:4339:2)\n"
	"#1  __schedule (kernel/sched/core.c:5147:8)\n"
	"#2  schedule (kernel/sched/core.c:5226:3)\n"
	"#3  do_wait (kernel/exit.c:1534:4)\n"
	"#4  kernel_wait4 (kernel/exit.c:1678:8)\n"
	"#5  __do_sys_wait4 (kernel/exit.c:1706:13)\n"
	"#6  do_syscall_64 (arch/x86/entry/common.c:47:14)\n"
	"#7  entry_SYSCALL_64+0x7c/0x15b (arch/x86/entry/entry_64.S:112)\n"
	"#8  0x4d49dd\n"
	"\n"
	"The format is subject to change. The drgn CLI is set up so that stack\n"
	"traces are displayed with ``str()`` by default.";
const char drgn_StackFrame_DOC[] =
	"A ``StackFrame`` represents a single *frame* in a thread's call stack.\n"
	"\n"
	":class:`str() <str>` returns a pretty-printed stack frame:\n"
	"\n"
	">>> prog.stack_trace(1)[0]\n"
	"#0 at 0xffffffffb64ac287 (__schedule+0x227/0x606) in context_switch at kernel/sched/core.c:4339:2 (inlined)\n"
	"\n"
	"This includes more information than when printing the full stack trace. The\n"
	"format is subject to change. The drgn CLI is set up so that stack frames\n"
	"are displayed with ``str()`` by default.\n"
	"\n"
	"The :meth:`[] <.__getitem__>` operator can look up function parameters,\n"
	"local variables, and global variables in the scope of the stack frame:\n"
	"\n"
	">>> prog.stack_trace(1)[0]['prev'].pid\n"
	"(pid_t)1\n"
	">>> prog.stack_trace(1)[0]['scheduler_running']\n"
	"(int)1";
const char drgn_StackFrame_name_DOC[] =
	"Optional[str]\n"
	"\n"
	"Name of the function at this frame, or ``None`` if it could not be\n"
	"determined.\n"
	"\n"
	"The name cannot be determined if debugging information is not available for\n"
	"the function, e.g., because it is implemented in assembly. It may be\n"
	"desirable to use the symbol name or program counter as a fallback:\n"
	"\n"
	".. code-block:: python3\n"
	"\n"
	"    name = frame.name\n"
	"    if name is None:\n"
	"        try:\n"
	"            name = frame.symbol().name\n"
	"        except LookupError:\n"
	"            name = hex(frame.pc)";
const char drgn_StackFrame_is_inline_DOC[] =
	"bool\n"
	"\n"
	"Whether this frame is for an inlined call.\n"
	"\n"
	"An inline frame shares the same stack frame in memory as its caller.\n"
	"Therefore, it has the same registers (including program counter and thus\n"
	"symbol).";
const char drgn_StackFrame_interrupted_DOC[] =
	"bool\n"
	"\n"
	"Whether this stack frame was interrupted (for example, by a hardware\n"
	"interrupt, signal, trap, etc.).\n"
	"\n"
	"If this is ``True``, then the register values in this frame are the values\n"
	"at the time that the frame was interrupted.\n"
	"\n"
	"This is ``False`` if the frame is for a function call, in which case the\n"
	"register values are the values when control returns to this frame. In\n"
	"particular, the program counter is the return address, which is typically\n"
	"the instruction after the call instruction.";
const char drgn_StackFrame_pc_DOC[] =
	"int\n"
	"\n"
	"Program counter at this stack frame.";
const char drgn_StackFrame___getitem___DOC[] =
	"__getitem__(name: str) -> _drgn.Object\n"
	"\n"
	"Implement ``self[name]``. Get the object (variable, function parameter,\n"
	"constant, or function) with the given name in the scope of this frame.\n"
	"\n"
	"If the object exists but has been optimized out, this returns an\n"
	":ref:`absent object <absent-objects>`.\n"
	"\n"
	":param name: Object name.";
const char drgn_StackFrame___contains___DOC[] =
	"__contains__(name: str) -> bool\n"
	"\n"
	"Implement ``name in self``. Return whether an object with the given\n"
	"name exists in the scope of this frame.\n"
	"\n"
	":param name: Object name.";
const char drgn_StackFrame_source_DOC[] =
	"source() -> Tuple[str, int, int]\n"
	"\n"
	"Get the source code location of this frame.\n"
	"\n"
	":return: Location as a ``(filename, line, column)`` triple.\n"
	":raises LookupError: if the source code location is not available";
const char drgn_StackFrame_symbol_DOC[] =
	"symbol() -> _drgn.Symbol\n"
	"\n"
	"Get the function symbol at this stack frame.\n"
	"\n"
	"This is equivalent to:\n"
	"\n"
	".. code-block:: python3\n"
	"\n"
	"    prog.symbol(frame.pc - (0 if frame.interrupted else 1))";
const char drgn_StackFrame_register_DOC[] =
	"register(reg: str) -> int\n"
	"\n"
	"Get the value of the given register at this stack frame.\n"
	"\n"
	":param reg: Register name.\n"
	":raises ValueError: if the register name is not recognized\n"
	":raises LookupError: if the register value is not known";
const char drgn_StackFrame_registers_DOC[] =
	"registers() -> Dict[str, int]\n"
	"\n"
	"Get the values of all available registers at this stack frame as a\n"
	"dictionary with the register names as keys.";
const char drgn_Type_DOC[] =
	"A ``Type`` object describes a type in a program. Each kind of type (e.g.,\n"
	"integer, structure) has different attributes (e.g., name, size). Types can\n"
	"also have qualifiers (e.g., constant, atomic). Accessing an attribute which\n"
	"does not apply to a type raises an :exc:`AttributeError`.\n"
	"\n"
	":func:`repr()` of a ``Type`` returns a Python representation of the type:\n"
	"\n"
	">>> print(repr(prog.type('sector_t')))\n"
	"prog.typedef_type(name='sector_t', type=prog.int_type(name='unsigned long', size=8, is_signed=False))\n"
	"\n"
	":class:`str() <str>` returns a representation of the type in programming\n"
	"language syntax:\n"
	"\n"
	">>> print(prog.type('sector_t'))\n"
	"typedef unsigned long sector_t\n"
	"\n"
	"The drgn CLI is set up so that types are displayed with ``str()`` instead\n"
	"of ``repr()`` by default.\n"
	"\n"
	"This class cannot be constructed directly. Instead, use one of the\n"
	":ref:`api-type-constructors`.";
const char drgn_Type_prog_DOC[] =
	"_drgn.Program\n"
	"\n"
	"Program that this type is from.";
const char drgn_Type_kind_DOC[] =
	"_drgn.TypeKind\n"
	"\n"
	"Kind of this type.";
const char drgn_Type_primitive_DOC[] =
	"Optional[_drgn.PrimitiveType]\n"
	"\n"
	"If this is a primitive type (e.g., ``int`` or ``double``), the kind of\n"
	"primitive type. Otherwise, ``None``.";
const char drgn_Type_qualifiers_DOC[] =
	"_drgn.Qualifiers\n"
	"\n"
	"Bitmask of this type's qualifier.";
const char drgn_Type_language_DOC[] =
	"_drgn.Language\n"
	"\n"
	"Programming language of this type.";
const char drgn_Type_name_DOC[] =
	"str\n"
	"\n"
	"Name of this type. This is present for integer, boolean, floating-point,\n"
	"and typedef types.";
const char drgn_Type_tag_DOC[] =
	"Optional[str]\n"
	"\n"
	"Tag of this type, or ``None`` if this is an anonymous type. This is present\n"
	"for structure, union, class, and enumerated types.";
const char drgn_Type_size_DOC[] =
	"Optional[int]\n"
	"\n"
	"Size of this type in bytes, or ``None`` if this is an incomplete type. This\n"
	"is present for integer, boolean, floating-point, structure, union, class,\n"
	"and pointer types.";
const char drgn_Type_length_DOC[] =
	"Optional[int]\n"
	"\n"
	"Number of elements in this type, or ``None`` if this is an incomplete type.\n"
	"This is only present for array types.";
const char drgn_Type_is_signed_DOC[] =
	"bool\n"
	"\n"
	"Whether this type is signed. This is only present for integer types.";
const char drgn_Type_byteorder_DOC[] =
	"str\n"
	"\n"
	"Byte order of this type: ``'little'`` if it is little-endian, or ``'big'``\n"
	"if it is big-endian. This is present for integer, boolean, floating-point,\n"
	"and pointer types.";
const char drgn_Type_type_DOC[] =
	"_drgn.Type\n"
	"\n"
	"Type underlying this type, defined as follows:\n"
	"\n"
	"* For typedef types, the aliased type.\n"
	"* For enumerated types, the compatible integer type, which is ``None`` if\n"
	"  this is an incomplete type.\n"
	"* For pointer types, the referenced type.\n"
	"* For array types, the element type.\n"
	"* For function types, the return type.\n"
	"\n"
	"For other types, this attribute is not present.";
const char drgn_Type_members_DOC[] =
	"Optional[Sequence[_drgn.TypeMember]]\n"
	"\n"
	"List of members of this type, or ``None`` if this is an incomplete type.\n"
	"This is present for structure, union, and class types.";
const char drgn_Type_enumerators_DOC[] =
	"Optional[Sequence[_drgn.TypeEnumerator]]\n"
	"\n"
	"List of enumeration constants of this type, or ``None`` if this is an\n"
	"incomplete type. This is only present for enumerated types.";
const char drgn_Type_parameters_DOC[] =
	"Sequence[_drgn.TypeParameter]\n"
	"\n"
	"List of parameters of this type. This is only present for function types.";
const char drgn_Type_is_variadic_DOC[] =
	"bool\n"
	"\n"
	"Whether this type takes a variable number of arguments. This is only\n"
	"present for function types.";
const char drgn_Type_template_parameters_DOC[] =
	"Sequence[_drgn.TypeTemplateParameter]\n"
	"\n"
	"List of template parameters of this type. This is present for structure,\n"
	"union, class, and function types.";
const char drgn_Type_type_name_DOC[] =
	"type_name() -> str\n"
	"\n"
	"Get a descriptive full name of this type.";
const char drgn_Type_is_complete_DOC[] =
	"is_complete() -> bool\n"
	"\n"
	"Get whether this type is complete (i.e., the type definition is known).\n"
	"This is always ``False`` for void types. It may be ``False`` for\n"
	"structure, union, class, enumerated, and array types, as well as\n"
	"typedef types where the underlying type is one of those. Otherwise, it\n"
	"is always ``True``.";
const char drgn_Type_qualified_DOC[] =
	"qualified(qualifiers: _drgn.Qualifiers) -> _drgn.Type\n"
	"\n"
	"Get a copy of this type with different qualifiers.\n"
	"\n"
	"Note that the original qualifiers are replaced, not added to.\n"
	"\n"
	":param qualifiers: New type qualifiers.";
const char drgn_Type_unqualified_DOC[] =
	"unqualified() -> _drgn.Type\n"
	"\n"
	"Get a copy of this type with no qualifiers.";
const char drgn_Type_member_DOC[] =
	"member(name: str) -> _drgn.TypeMember\n"
	"\n"
	"Look up a member in this type by name.\n"
	"\n"
	"If this type has any unnamed members, this also matches members of\n"
	"those unnamed members, recursively. If the member is found in an\n"
	"unnamed member, :attr:`TypeMember.bit_offset` and\n"
	":attr:`TypeMember.offset` are adjusted accordingly.\n"
	"\n"
	":param name: Name of the member.\n"
	":raises TypeError: if this type is not a structure, union, or class\n"
	"    type\n"
	":raises LookupError: if this type does not have a member with the given\n"
	"    name";
const char drgn_Type_has_member_DOC[] =
	"has_member(name: str) -> bool\n"
	"\n"
	"Return whether this type has a member with the given name.\n"
	"\n"
	"If this type has any unnamed members, this also matches members of\n"
	"those unnamed members, recursively.\n"
	"\n"
	":param name: Name of the member.\n"
	":raises TypeError: if this type is not a structure, union, or class\n"
	"    type";
const char drgn_TypeMember_DOC[] =
	"A ``TypeMember`` represents a member of a structure, union, or class type.\n"
	"\n"
	"TypeMember(object_or_type: Union[Object, Type, Callable[[], Union[Object, Type]]], name: Optional[str] = None, bit_offset: int = 0)\n"
	"\n"
	"Create a ``TypeMember``.\n"
	"\n"
	":param object_or_type: One of:\n"
	"\n"
	"    1. :attr:`TypeMember.object` as an :class:`Object`.\n"
	"    2. :attr:`TypeMember.type` as a :class:`Type`. In this case,\n"
	"       ``object`` is set to an absent object with that type.\n"
	"    3. A callable that takes no arguments and returns one of the above.\n"
	"       It is called when ``object`` or ``type`` is first accessed, and\n"
	"       the result is cached.\n"
	":param name: :attr:`TypeMember.name`\n"
	":param bit_offset: :attr:`TypeMember.bit_offset`";
const char drgn_TypeMember_object_DOC[] =
	"_drgn.Object\n"
	"\n"
	"Member as an :class:`Object`.\n"
	"\n"
	"This is the default initializer for the member, or an absent object if the\n"
	"member has no default initializer. (However, the DWARF specification as of\n"
	"version 5 does not actually support default member initializers, so this is\n"
	"usually absent.)";
const char drgn_TypeMember_type_DOC[] =
	"_drgn.Type\n"
	"\n"
	"Member type.\n"
	"\n"
	"This is a shortcut for ``TypeMember.object.type``.";
const char drgn_TypeMember_name_DOC[] =
	"Optional[str]\n"
	"\n"
	"Member name, or ``None`` if the member is unnamed.";
const char drgn_TypeMember_bit_offset_DOC[] =
	"int\n"
	"\n"
	"Offset of the member from the beginning of the type in bits.";
const char drgn_TypeMember_offset_DOC[] =
	"int\n"
	"\n"
	"Offset of the member from the beginning of the type in bytes. If the offset\n"
	"is not byte-aligned, accessing this attribute raises :exc:`ValueError`.";
const char drgn_TypeMember_bit_field_size_DOC[] =
	"Optional[int]\n"
	"\n"
	"Size in bits of this member if it is a bit field, ``None`` if it is not.\n"
	"\n"
	"This is a shortcut for ``TypeMember.object.bit_field_size_``.";
const char drgn_TypeEnumerator_DOC[] =
	"A ``TypeEnumerator`` represents a constant in an enumerated type.\n"
	"\n"
	"Its name and value may be accessed as attributes or unpacked:\n"
	"\n"
	">>> prog.type('enum pid_type').enumerators[0].name\n"
	"'PIDTYPE_PID'\n"
	">>> name, value = prog.type('enum pid_type').enumerators[0]\n"
	">>> value\n"
	"0\n"
	"\n"
	"TypeEnumerator(name: str, value: int)\n"
	"\n"
	"Create a ``TypeEnumerator``.\n"
	"\n"
	":param name: :attr:`TypeEnumerator.name`\n"
	":param value: :attr:`TypeEnumerator.value`";
const char drgn_TypeEnumerator_name_DOC[] =
	"str\n"
	"\n"
	"Enumerator name.";
const char drgn_TypeEnumerator_value_DOC[] =
	"int\n"
	"\n"
	"Enumerator value.";
const char drgn_TypeParameter_DOC[] =
	"A ``TypeParameter`` represents a parameter of a function type.\n"
	"\n"
	"TypeParameter(default_argument_or_type: Union[Object, Type, Callable[[], Union[Object, Type]]], name: Optional[str] = None)\n"
	"\n"
	"Create a ``TypeParameter``.\n"
	"\n"
	":param default_argument_or_type: One of:\n"
	"\n"
	"    1. :attr:`TypeParameter.default_argument` as an :class:`Object`.\n"
	"    2. :attr:`TypeParameter.type` as a :class:`Type`. In this case,\n"
	"       ``default_argument`` is set to an absent object with that type.\n"
	"    3. A callable that takes no arguments and returns one of the above.\n"
	"       It is called when ``default_argument`` or ``type`` is first\n"
	"       accessed, and the result is cached.\n"
	":param name: :attr:`TypeParameter.name`";
const char drgn_TypeParameter_default_argument_DOC[] =
	"_drgn.Object\n"
	"\n"
	"Default argument for parameter.\n"
	"\n"
	"If the parameter does not have a default argument, then this is an absent\n"
	"object.\n"
	"\n"
	".. note::\n"
	"\n"
	"    Neither GCC nor Clang emits debugging information for default arguments\n"
	"    (as of GCC 10 and Clang 11), and drgn does not yet parse it, so this is\n"
	"    usually absent.";
const char drgn_TypeParameter_type_DOC[] =
	"_drgn.Type\n"
	"\n"
	"Parameter type.\n"
	"\n"
	"This is the same as ``TypeParameter.default_argument.type_``.";
const char drgn_TypeParameter_name_DOC[] =
	"Optional[str]\n"
	"\n"
	"Parameter name, or ``None`` if the parameter is unnamed.";
const char drgn_TypeTemplateParameter_DOC[] =
	"A ``TypeTemplateParameter`` represents a template parameter of a structure,\n"
	"union, class, or function type.\n"
	"\n"
	"TypeTemplateParameter(argument: Union[Type, Object, Callable[[], Union[Type, Object]]], name: Optional[str] = None, is_default: bool = False)\n"
	"\n"
	"Create a ``TypeTemplateParameter``.\n"
	"\n"
	":param argument: One of:\n"
	"\n"
	"    1. :attr:`TypeTemplateParameter.argument` as a :class:`Type` if the\n"
	"       parameter is a type template parameter.\n"
	"    2. :attr:`TypeTemplateParameter.argument` as a non-absent\n"
	"       :class:`Object` if the parameter is a non-type template\n"
	"       parameter.\n"
	"    3. A callable that takes no arguments and returns one of the above.\n"
	"       It is called when ``argument`` is first accessed, and the result\n"
	"       is cached.\n"
	":param name: :attr:`TypeTemplateParameter.name`\n"
	":param is_default: :attr:`TypeTemplateParameter.is_default`";
const char drgn_TypeTemplateParameter_argument_DOC[] =
	"Union[_drgn.Type, _drgn.Object]\n"
	"\n"
	"Template argument.\n"
	"\n"
	"If this is a type template parameter, then this is a :class:`Type`. If this\n"
	"is a non-type template parameter, then this is an :class:`Object`.";
const char drgn_TypeTemplateParameter_name_DOC[] =
	"Optional[str]\n"
	"\n"
	"Template parameter name, or ``None`` if the parameter is unnamed.";
const char drgn_TypeTemplateParameter_is_default_DOC[] =
	"bool\n"
	"\n"
	"Whether :attr:`argument` is the default for the template parameter.\n"
	"\n"
	".. note::\n"
	"\n"
	"    There are two ways to interpret this:\n"
	"\n"
	"        1. The argument was omitted entirely and thus defaulted to the\n"
	"           default argument.\n"
	"        2. The (specified or defaulted) argument is the same as the default\n"
	"           argument.\n"
	"\n"
	"    Compilers are inconsistent about which interpretation they use.\n"
	"\n"
	"    GCC added this information in version 4.9. Clang added it in version 11\n"
	"    (and only when emitting DWARF version 5). If the program was compiled\n"
	"    by an older version, this is always false.";
const char drgn_TypeKind_DOC[] =
	"Bases: enum.Enum\n"
	"\n"
	"A ``TypeKind`` represents a kind of type.";
const char drgn_TypeKind_VOID_DOC[] =
	"Void type.";
const char drgn_TypeKind_INT_DOC[] =
	"Integer type.";
const char drgn_TypeKind_BOOL_DOC[] =
	"Boolean type.";
const char drgn_TypeKind_FLOAT_DOC[] =
	"Floating-point type.";
const char drgn_TypeKind_COMPLEX_DOC[] =
	"Complex type.";
const char drgn_TypeKind_STRUCT_DOC[] =
	"Structure type.";
const char drgn_TypeKind_UNION_DOC[] =
	"Union type.";
const char drgn_TypeKind_CLASS_DOC[] =
	"Class type.";
const char drgn_TypeKind_ENUM_DOC[] =
	"Enumerated type.";
const char drgn_TypeKind_TYPEDEF_DOC[] =
	"Type definition (a.k.a. alias) type.";
const char drgn_TypeKind_POINTER_DOC[] =
	"Pointer type.";
const char drgn_TypeKind_ARRAY_DOC[] =
	"Array type.";
const char drgn_TypeKind_FUNCTION_DOC[] =
	"Function type.";
const char drgn_PrimitiveType_DOC[] =
	"Bases: enum.Enum\n"
	"\n"
	"A ``PrimitiveType`` represents a primitive type known to drgn.";
const char drgn_PrimitiveType_C_VOID_DOC[] = "";
const char drgn_PrimitiveType_C_CHAR_DOC[] = "";
const char drgn_PrimitiveType_C_SIGNED_CHAR_DOC[] = "";
const char drgn_PrimitiveType_C_UNSIGNED_CHAR_DOC[] = "";
const char drgn_PrimitiveType_C_SHORT_DOC[] = "";
const char drgn_PrimitiveType_C_UNSIGNED_SHORT_DOC[] = "";
const char drgn_PrimitiveType_C_INT_DOC[] = "";
const char drgn_PrimitiveType_C_UNSIGNED_INT_DOC[] = "";
const char drgn_PrimitiveType_C_LONG_DOC[] = "";
const char drgn_PrimitiveType_C_UNSIGNED_LONG_DOC[] = "";
const char drgn_PrimitiveType_C_LONG_LONG_DOC[] = "";
const char drgn_PrimitiveType_C_UNSIGNED_LONG_LONG_DOC[] = "";
const char drgn_PrimitiveType_C_BOOL_DOC[] = "";
const char drgn_PrimitiveType_C_FLOAT_DOC[] = "";
const char drgn_PrimitiveType_C_DOUBLE_DOC[] = "";
const char drgn_PrimitiveType_C_LONG_DOUBLE_DOC[] = "";
const char drgn_PrimitiveType_C_SIZE_T_DOC[] = "";
const char drgn_PrimitiveType_C_PTRDIFF_T_DOC[] = "";
const char drgn_Qualifiers_DOC[] =
	"Bases: enum.Flag\n"
	"\n"
	"``Qualifiers`` are modifiers on types.";
const char drgn_Qualifiers_NONE_DOC[] =
	"No qualifiers.";
const char drgn_Qualifiers_CONST_DOC[] =
	"Constant type.";
const char drgn_Qualifiers_VOLATILE_DOC[] =
	"Volatile type.";
const char drgn_Qualifiers_RESTRICT_DOC[] =
	"`Restrict <https://en.cppreference.com/w/c/language/restrict>`_ type.";
const char drgn_Qualifiers_ATOMIC_DOC[] =
	"Atomic type.";
const char drgn_sizeof_DOC[] =
	"sizeof(type_or_obj: Union[Type, Object]) -> int\n"
	"\n"
	"Get the size of a :class:`Type` or :class:`Object` in bytes.\n"
	"\n"
	":param type_or_obj: Entity to get the size of.\n"
	":raises TypeError: if the type does not have a size (e.g., because it is\n"
	"    incomplete or void)";
const char drgn_offsetof_DOC[] =
	"offsetof(type: Type, member: str) -> int\n"
	"\n"
	"Get the offset (in bytes) of a member in a :class:`Type`.\n"
	"\n"
	"This corresponds to |offsetof()|_ in C.\n"
	"\n"
	".. |offsetof()| replace:: ``offsetof()``\n"
	".. _offsetof(): https://en.cppreference.com/w/cpp/types/offsetof\n"
	"\n"
	":param type: Structure, union, or class type.\n"
	":param member: Name of member. May include one or more member references\n"
	"    and zero or more array subscripts.\n"
	":raises TypeError: if *type* is not a structure, union, or class type\n"
	":raises ValueError: if the member is not byte-aligned (e.g., because it is\n"
	"    a bit field)\n"
	":raises LookupError: if *type* does not have a member with the given name";
const char drgn_FaultError_DOC[] =
	"Bases: Exception\n"
	"\n"
	"This error is raised when a bad memory access is attempted (i.e., when\n"
	"accessing a memory address which is not valid in a program).\n"
	"\n"
	"FaultError(message: str, address: int)\n"
	"\n"
	":param message: :attr:`FaultError.message`\n"
	":param address: :attr:`FaultError.address`";
const char drgn_FaultError_message_DOC[] =
	"str\n"
	"\n"
	"Error message.";
const char drgn_FaultError_address_DOC[] =
	"int\n"
	"\n"
	"Address that couldn't be accessed.";
const char drgn_MissingDebugInfoError_DOC[] =
	"Bases: Exception\n"
	"\n"
	"This error is raised when one or more files in a program do not have debug\n"
	"information.";
const char drgn_ObjectAbsentError_DOC[] =
	"Bases: Exception\n"
	"\n"
	"This error is raised when attempting to use an absent object.";
const char drgn_OutOfBoundsError_DOC[] =
	"Bases: Exception\n"
	"\n"
	"This error is raised when attempting to access beyond the bounds of a value\n"
	"object.";
const char drgn__linux_helper_radix_tree_lookup_DOC[] =
	"_linux_helper_radix_tree_lookup(root: Object, index: IntegerLike) -> Object\n"
	"\n"
	"Look up the entry at a given index in a radix tree.\n"
	"\n"
	":param root: ``struct radix_tree_root *``\n"
	":param index: Entry index.\n"
	":return: ``void *`` found entry, or ``NULL`` if not found.";
const char drgn__linux_helper_per_cpu_ptr_DOC[] =
	"_linux_helper_per_cpu_ptr(ptr: Object, cpu: IntegerLike) -> Object\n"
	"\n"
	"Return the per-CPU pointer for a given CPU.\n"
	"\n"
	">>> prog[\"init_net\"].loopback_dev.pcpu_refcnt\n"
	"(int *)0x2c980\n"
	">>> per_cpu_ptr(prog[\"init_net\"].loopback_dev.pcpu_refcnt, 7)\n"
	"*(int *)0xffff925e3ddec980 = 4\n"
	"\n"
	":param ptr: Per-CPU pointer, i.e., ``type __percpu *``. For global\n"
	"    variables, it's usually easier to use :func:`per_cpu()`.\n"
	":param cpu: CPU number.\n"
	":return: ``type *`` object.";
const char drgn__linux_helper_idle_task_DOC[] =
	"_linux_helper_idle_task(prog: Program, cpu: IntegerLike) -> Object\n"
	"\n"
	"Return the idle thread (PID 0, a.k.a swapper) for the given CPU.\n"
	"\n"
	">>> idle_task(prog, 1).comm\n"
	"(char [16])\"swapper/1\"\n"
	"\n"
	":param cpu: CPU number.\n"
	":return: ``struct task_struct *``";
const char drgn__linux_helper_idr_find_DOC[] =
	"_linux_helper_idr_find(idr: Object, id: IntegerLike) -> Object\n"
	"\n"
	"Look up the entry with the given ID in an IDR.\n"
	"\n"
	":param idr: ``struct idr *``\n"
	":param id: Entry ID.\n"
	":return: ``void *`` found entry, or ``NULL`` if not found.";
const char drgn__linux_helper_find_pid_DOC[] =
	"_linux_helper_find_pid(prog_or_ns: Union[Program, Object], pid: IntegerLike) -> Object\n"
	"\n"
	"Return the ``struct pid *`` for the given PID number.\n"
	"\n"
	":param prog_or_ns: ``struct pid_namespace *`` object, or :class:`Program`\n"
	"    to use initial PID namespace.\n"
	":return: ``struct pid *``";
const char drgn__linux_helper_pid_task_DOC[] =
	"_linux_helper_pid_task(pid: Object, pid_type: IntegerLike) -> Object\n"
	"\n"
	"Return the ``struct task_struct *`` containing the given ``struct pid *``\n"
	"of the given type.\n"
	"\n"
	":param pid: ``struct pid *``\n"
	":param pid_type: ``enum pid_type``\n"
	":return: ``struct task_struct *``";
const char drgn__linux_helper_find_task_DOC[] =
	"_linux_helper_find_task(prog_or_ns: Union[Program, Object], pid: IntegerLike) -> Object\n"
	"\n"
	"Return the task with the given PID.\n"
	"\n"
	":param prog_or_ns: ``struct pid_namespace *`` object, or :class:`Program`\n"
	"    to use initial PID namespace.\n"
	":return: ``struct task_struct *``";
const char drgn__linux_helper_kaslr_offset_DOC[] =
	"_linux_helper_kaslr_offset(prog: Program) -> int\n"
	"\n"
	"Get the kernel address space layout randomization offset (zero if it is\n"
	"disabled).";
const char drgn__linux_helper_pgtable_l5_enabled_DOC[] =
	"_linux_helper_pgtable_l5_enabled(prog: Program) -> bool\n"
	"\n"
	"Return whether 5-level paging is enabled.";
