"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const memcache_generated_1 = require("./memcache.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return memcache_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::Memcache::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::Memcache::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new memcache_generated_1.RosInstance(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            couponNo: props.couponNo,
            privateIpAddress: props.privateIpAddress,
            resourceGroupId: props.resourceGroupId,
            zoneId: props.zoneId,
            config: props.config,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            instanceName: props.instanceName,
            vpcId: props.vpcId,
            capacity: props.capacity,
            autoUseCoupon: props.autoUseCoupon,
            chargeType: props.chargeType,
            networkType: props.networkType,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrConnectionDomain = rosInstance.attrConnectionDomain;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrPort = rosInstance.attrPort;
        this.attrQps = rosInstance.attrQps;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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