from setuptools import setup, Extension, find_packages
import sys

# the following line is modified by setver.bash
version = '0.7.0'

setup(
    name = "cute_mongo_forms",
    version = version,
    install_requires = [
        "pymongo>=3.6",
        "PySide2>=5.11.1"
    ],

    packages = find_packages(), # # includes python code from every directory that has an "__init__.py" file in it.  If no "__init__.py" is found, the directory is omitted.  Other directories / files to be included, are defined in the MANIFEST.in file

    include_package_data=True, # # conclusion: NEVER forget this : files get included but not installed
    # # "package_data" keyword is a practical joke: use MANIFEST.in instead

    # metadata for upload to PyPI
    author = "Sampsa Riikonen",
    author_email = "sampsa.riikonen@iki.fi",
    description = "Document database / Qt Widget integration",
    license = "LGPLv3+",
    keywords = "qt mongo",
    url = "https://elsampsa.github.io/cute_mongo_forms/",
    
    long_description ="""
    Cute Mongo Forms makes it easy to create Qt Widgets with associated document collection database schemas.

    Document collections are connected to autogenerated forms, lists, etc. GUI elements with a transparent API.
    """,
    long_description_content_type='text/plain',
    
    classifiers = [
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Topic :: Database',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
        'Programming Language :: Python :: 3'
    ],
    #project_urls={
    #    'Tutorial': 'https://elsampsa.github.io/cute_mongo_forms/'
    #}
)

