/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import librec.util.Lists;

public class Stats {
    public static double mean(Collection<? extends Number> data) {
        double sum = 0.0;
        int count = 0;
        for (Number number : data) {
            if (Double.isNaN(number.doubleValue())) continue;
            sum += number.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    public static double hMean(double a, double b) {
        return 2.0 * a * b / (a + b);
    }

    public static double mean(double[] data) {
        double sum = 0.0;
        int count = 0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (!Double.isNaN(d)) {
                sum += d;
                ++count;
            }
            ++n2;
        }
        return sum / (double)count;
    }

    public static double mode(double[] data) {
        HashMap<Double, Integer> modes = new HashMap<Double, Integer>();
        double mode = Double.NaN;
        int max = 0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            int count = 0;
            if (modes.containsKey(d)) {
                count = (Integer)modes.get(d);
            }
            if (max < ++count) {
                mode = d;
                max = count;
            }
            modes.put(d, count);
            ++n2;
        }
        return mode;
    }

    public static double weightedcMean(double[] a, double[] w) {
        double sum = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < a.length) {
            if (!Double.isNaN(a[i]) && !Double.isNaN(w[i])) {
                sum += a[i] * w[i];
                ws += w[i];
            }
            ++i;
        }
        return sum / ws;
    }

    public static double average(List<Double> data, List<Double> weights) {
        double sum = 0.0;
        double ws = 0.0;
        int i = 0;
        while (i < data.size()) {
            double value = data.get(i);
            double weight = weights.get(i);
            sum += value * weight;
            ws += weight;
            ++i;
        }
        return sum / ws;
    }

    public static double median(double[] data) {
        double median = 0.0;
        double[] clones = (double[])data.clone();
        Arrays.sort(clones);
        int size = clones.length;
        int index = 0;
        if (size % 2 == 0) {
            index = clones.length / 2 - 1;
            median = (clones[index] + clones[index + 1]) / 2.0;
        } else {
            index = (clones.length + 1) / 2 - 1;
            median = clones[index];
        }
        return median;
    }

    public static double median(Collection<? extends Number> data) {
        return Stats.median(Lists.toArray(data));
    }

    public static double var(double[] data) {
        return Stats.var(data, Stats.mean(data));
    }

    public static double var(double[] data, double mean) {
        if (data.length == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += (data[i] - mean) * (data[i] - mean);
            ++i;
        }
        return sum / (double)data.length;
    }

    public static double sd(Collection<? extends Number> data) {
        return Stats.sd(data, Stats.mean(data));
    }

    public static double sd(Collection<? extends Number> data, double mean) {
        double sum = 0.0;
        for (Number number : data) {
            sum += Math.pow(number.doubleValue() - mean, 2.0);
        }
        return Math.sqrt(sum / (double)data.size());
    }

    public static double sd(double[] data) {
        return Stats.sd(data, Stats.mean(data));
    }

    public static double sd(double[] data, double mean) {
        return Math.sqrt(Stats.var(data, mean));
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            ++i;
        }
        return sum;
    }

    public static double sum(Collection<? extends Number> data) {
        double sum = 0.0;
        for (Number number : data) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static int sum(int[] data) {
        int sum = 0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            ++i;
        }
        return sum;
    }

    public static int sum(int n) {
        return n * (n - 1) / 2;
    }

    public static double sumSquare(int n) {
        return (double)n * ((double)n + 0.5) * (double)(n + 1) / 3.0;
    }

    public static double[] max(double[] data) {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                max = data[i];
                index = i;
            }
            ++i;
        }
        return new double[]{max, index};
    }

    public static int[] max(int[] data) {
        int max = Integer.MIN_VALUE;
        int index = -1;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                max = data[i];
                index = i;
            }
            ++i;
        }
        return new int[]{max, index};
    }

    public static int[] min(int[] data) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        int i = 0;
        while (i < data.length) {
            if (min > data[i]) {
                min = data[i];
                index = i;
            }
            ++i;
        }
        return new int[]{min, index};
    }

    public static double[] min(double[] data) {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        int i = 0;
        while (i < data.length) {
            if (min > data[i]) {
                min = data[i];
                index = i;
            }
            ++i;
        }
        return new double[]{min, index};
    }
}

