/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import librec.util.Systems;

public class Debug {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final String dirPath = Systems.getDesktop();

    public static double memory(Object obj, Method method, Object ... args) throws Exception {
        double mem = 0.0;
        Runtime runtime = Runtime.getRuntime();
        double start = runtime.freeMemory();
        method.invoke(obj, args);
        double end = runtime.freeMemory();
        mem = end - start;
        return mem /= 1000.0;
    }

    public static void pipeErrors() {
        Debug.pipeErrors(String.valueOf(dirPath) + "errors.txt");
    }

    public static void pipeErrors(String filePath) {
        try {
            System.setErr(new PrintStream(new File(filePath)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopHere() {
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void pipeConsoles() {
        Debug.pipeConsoles(String.valueOf(dirPath) + "console.txt");
    }

    public static void pipeConsoles(String filePath) {
        try {
            System.setOut(new PrintStream(new File(filePath)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

