/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import java.util.Iterator;
import java.util.List;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.SocialRecommender;

public class TrustSVD
extends SocialRecommender {
    private DenseMatrix W;
    private DenseMatrix Y;
    private DenseVector wlr_j;
    private DenseVector wlr_tc;
    private DenseVector wlr_tr;

    public TrustSVD(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        int count;
        super.initModel();
        this.userBias = new DenseVector(numUsers);
        this.itemBias = new DenseVector(numItems);
        this.W = new DenseMatrix(numUsers, numFactors);
        this.Y = new DenseMatrix(numItems, numFactors);
        if (this.initByNorm) {
            this.userBias.init(initMean, initStd);
            this.itemBias.init(initMean, initStd);
            this.W.init(initMean, initStd);
            this.Y.init(initMean, initStd);
        } else {
            this.userBias.init();
            this.itemBias.init();
            this.W.init();
            this.Y.init();
        }
        this.wlr_tc = new DenseVector(numUsers);
        this.wlr_tr = new DenseVector(numUsers);
        this.wlr_j = new DenseVector(numItems);
        this.userItemsCache = this.trainMatrix.rowColumnsCache(cacheSpec);
        this.userFriendsCache = socialMatrix.rowColumnsCache(cacheSpec);
        int u = 0;
        while (u < numUsers) {
            count = socialMatrix.columnSize(u);
            this.wlr_tc.set(u, count > 0 ? 1.0 / Math.sqrt(count) : 1.0);
            count = socialMatrix.rowSize(u);
            this.wlr_tr.set(u, count > 0 ? 1.0 / Math.sqrt(count) : 1.0);
            ++u;
        }
        int j = 0;
        while (j < numItems) {
            count = this.trainMatrix.columnSize(j);
            this.wlr_j.set(j, count > 0 ? 1.0 / Math.sqrt(count) : 1.0);
            ++j;
        }
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            int u;
            this.loss = 0.0;
            DenseMatrix PS = new DenseMatrix(numUsers, numFactors);
            DenseMatrix WS = new DenseMatrix(numUsers, numFactors);
            for (MatrixEntry me : this.trainMatrix) {
                List tu;
                u = me.row();
                int j = me.column();
                double ruj = me.get();
                double bu = this.userBias.get(u);
                double bj = this.itemBias.get(j);
                double pred = this.globalMean + bu + bj + DenseMatrix.rowMult(this.P, u, this.Q, j);
                List nu = (List)this.userItemsCache.get(u);
                if (nu.size() > 0) {
                    double sum = 0.0;
                    Iterator iterator = nu.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        sum += DenseMatrix.rowMult(this.Y, i, this.Q, j);
                    }
                    pred += sum / Math.sqrt(nu.size());
                }
                if ((tu = (List)this.userFriendsCache.get(u)).size() > 0) {
                    double sum = 0.0;
                    Iterator iterator = tu.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        sum += DenseMatrix.rowMult(this.W, v, this.Q, j);
                    }
                    pred += sum / Math.sqrt(tu.size());
                }
                double euj = pred - ruj;
                this.loss += euj * euj;
                double w_nu = Math.sqrt(nu.size());
                double w_tu = Math.sqrt(tu.size());
                double reg_u = 1.0 / w_nu;
                double reg_j = this.wlr_j.get(j);
                double sgd = euj + (double)regB * reg_u * bu;
                this.userBias.add(u, -this.lRate * sgd);
                sgd = euj + (double)regB * reg_j * bj;
                this.itemBias.add(j, -this.lRate * sgd);
                this.loss += (double)regB * reg_u * bu * bu;
                this.loss += (double)regB * reg_j * bj * bj;
                double[] sum_ys = new double[numFactors];
                int f = 0;
                while (f < numFactors) {
                    double sum = 0.0;
                    Iterator iterator = nu.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        sum += this.Y.get(i, f);
                    }
                    sum_ys[f] = w_nu > 0.0 ? sum / w_nu : sum;
                    ++f;
                }
                double[] sum_ts = new double[numFactors];
                int f2 = 0;
                while (f2 < numFactors) {
                    double sum = 0.0;
                    Iterator iterator = tu.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        sum += this.W.get(v, f2);
                    }
                    sum_ts[f2] = w_tu > 0.0 ? sum / w_tu : sum;
                    ++f2;
                }
                f2 = 0;
                while (f2 < numFactors) {
                    double puf = this.P.get(u, f2);
                    double qjf = this.Q.get(j, f2);
                    double delta_u = euj * qjf + (double)regU * reg_u * puf;
                    double delta_j = euj * (puf + sum_ys[f2] + sum_ts[f2]) + (double)regI * reg_j * qjf;
                    PS.add(u, f2, delta_u);
                    this.Q.add(j, f2, -this.lRate * delta_j);
                    this.loss += (double)regU * reg_u * puf * puf + (double)regI * reg_j * qjf * qjf;
                    Iterator iterator = nu.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        double yif = this.Y.get(i, f2);
                        double reg_yi = this.wlr_j.get(i);
                        double delta_y = euj * qjf / w_nu + (double)regI * reg_yi * yif;
                        this.Y.add(i, f2, -this.lRate * delta_y);
                        this.loss += (double)regI * reg_yi * yif * yif;
                    }
                    iterator = tu.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        double wvf = this.W.get(v, f2);
                        double reg_v = this.wlr_tc.get(v);
                        double delta_t = euj * qjf / w_tu + (double)regU * reg_v * wvf;
                        WS.add(v, f2, delta_t);
                        this.loss += (double)regU * reg_v * wvf * wvf;
                    }
                    ++f2;
                }
            }
            for (MatrixEntry me : socialMatrix) {
                u = me.row();
                int v = me.column();
                double tuv = me.get();
                if (tuv == 0.0) continue;
                double pred = DenseMatrix.rowMult(this.P, u, this.W, v);
                double eut = pred - tuv;
                this.loss += (double)regS * eut * eut;
                double csgd = (double)regS * eut;
                double reg_u = this.wlr_tr.get(u);
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double wvf = this.W.get(v, f);
                    PS.add(u, f, csgd * wvf + (double)regS * reg_u * puf);
                    WS.add(v, f, csgd * puf);
                    this.loss += (double)regS * reg_u * puf * puf;
                    ++f;
                }
            }
            this.P = this.P.add(PS.scale(-this.lRate));
            this.W = this.W.add(WS.scale(-this.lRate));
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        List tu;
        double pred = this.globalMean + this.userBias.get(u) + this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
        List nu = (List)this.userItemsCache.get(u);
        if (nu.size() > 0) {
            double sum = 0.0;
            Iterator iterator = nu.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sum += DenseMatrix.rowMult(this.Y, i, this.Q, j);
            }
            pred += sum / Math.sqrt(nu.size());
        }
        if ((tu = (List)this.userFriendsCache.get(u)).size() > 0) {
            double sum = 0.0;
            Iterator iterator = tu.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                sum += DenseMatrix.rowMult(this.W, v, this.Q, j);
            }
            pred += sum / Math.sqrt(tu.size());
        }
        return pred;
    }
}

