/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.Configuration;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.SymmMatrix;
import librec.intf.Recommender;
import librec.util.Lists;
import librec.util.Stats;
import librec.util.Strings;

@Configuration(value="knn, similarity, shrinkage")
public class ItemKNN
extends Recommender {
    private SymmMatrix itemCorrs;
    private DenseVector itemMeans;

    public ItemKNN(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.itemCorrs = this.buildCorrs(false);
        this.itemMeans = new DenseVector(numItems);
        int i = 0;
        while (i < numItems) {
            SparseVector vs = this.trainMatrix.column(i);
            this.itemMeans.set(i, vs.getCount() > 0 ? vs.mean() : this.globalMean);
            ++i;
        }
    }

    @Override
    protected double predict(int u, int j) {
        HashMap<Integer, Double> nns = new HashMap<Integer, Double>();
        SparseVector dv = this.itemCorrs.row(j);
        Object object = dv.getIndex();
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            int i = object[n2];
            double sim = dv.get(i);
            double rate = this.trainMatrix.get(u, i);
            if (isRankingPred && rate > 0.0) {
                nns.put(i, sim);
            } else if (sim > 0.0 && rate > 0.0) {
                nns.put(i, sim);
            }
            ++n2;
        }
        if (knn > 0 && knn < nns.size()) {
            List sorted = Lists.sortMap(nns, true);
            List subset = sorted.subList(0, knn);
            nns.clear();
            object = subset.iterator();
            while (object.hasNext()) {
                Map.Entry kv = (Map.Entry)object.next();
                nns.put((Integer)kv.getKey(), (Double)kv.getValue());
            }
        }
        if (nns.size() == 0) {
            return isRankingPred ? 0.0 : this.globalMean;
        }
        if (isRankingPred) {
            return Stats.sum(nns.values());
        }
        double sum = 0.0;
        double ws = 0.0;
        for (Map.Entry en : nns.entrySet()) {
            int i = (Integer)en.getKey();
            double sim = (Double)en.getValue();
            double rate = this.trainMatrix.get(u, i);
            sum += sim * (rate - this.itemMeans.get(i));
            ws += Math.abs(sim);
        }
        return ws > 0.0 ? this.itemMeans.get(j) + sum / ws : this.globalMean;
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{knn, similarityMeasure, similarityShrinkage});
    }
}

