/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import librec.data.Configuration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.DiagMatrix;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;
import librec.util.Logs;
import librec.util.Strings;

@Configuration(value="binThold, alpha, factors, regU, regI, numIters")
public class WRMF
extends IterativeRecommender {
    private float alpha;

    public WRMF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.alpha = algoOptions.getFloat("-alpha");
    }

    @Override
    protected void buildModel() throws Exception {
        DenseMatrix X = this.P;
        DenseMatrix Y = this.Q;
        int iter = 1;
        while (iter <= numIters) {
            DenseMatrix Yt = Y.transpose();
            DenseMatrix YtY = Yt.mult(Y);
            int u = 0;
            while (u < numUsers) {
                if (verbose && (u + 1) % 200 == 0) {
                    Logs.debug("{}{} runs at iteration = {}, user = {}/{}", this.algoName, this.foldInfo, iter, u + 1, numUsers);
                }
                DiagMatrix Cu = DiagMatrix.eye(numItems);
                SparseVector pu = this.trainMatrix.row(u);
                for (VectorEntry ve : pu) {
                    int i = ve.index();
                    Cu.add(i, i, (double)this.alpha * ve.get());
                }
                for (VectorEntry ve : pu) {
                    ve.set(ve.get() > 0.0 ? 1 : 0);
                }
                DiagMatrix CuI = Cu.minus(1.0);
                DenseMatrix YtCuY = YtY.add(Yt.mult(CuI).mult(Y));
                DenseMatrix Wu = YtCuY.add(DiagMatrix.eye(numFactors).scale(regU)).inv();
                DenseMatrix YtCu = Yt.mult(Cu);
                DenseVector xu = Wu.mult(YtCu).mult(pu);
                X.setRow(u, xu);
                ++u;
            }
            DenseMatrix Xt = X.transpose();
            DenseMatrix XtX = Xt.mult(X);
            int i = 0;
            while (i < numItems) {
                if (verbose && (i + 1) % 200 == 0) {
                    Logs.debug("{}{} runs at iteration = {}, item = {}/{}", this.algoName, this.foldInfo, iter, i + 1, numItems);
                }
                DiagMatrix Ci = DiagMatrix.eye(numUsers);
                SparseVector pi = this.trainMatrix.column(i);
                for (VectorEntry ve : pi) {
                    int u2 = ve.index();
                    Ci.add(u2, u2, (double)this.alpha * ve.get());
                }
                for (VectorEntry ve : pi) {
                    ve.set(ve.get() > 0.0 ? 1 : 0);
                }
                DiagMatrix CiI = Ci.minus(1.0);
                DenseMatrix XtCiX = XtX.add(Xt.mult(CiI).mult(X));
                DenseMatrix Wi = XtCiX.add(DiagMatrix.eye(numFactors).scale(regI)).inv();
                DenseMatrix XtCi = Xt.mult(Ci);
                DenseVector yi = Wi.mult(XtCi).mult(pi);
                Y.setRow(i, yi);
                ++i;
            }
            ++iter;
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), Float.valueOf(this.alpha), numFactors, Float.valueOf(regU), Float.valueOf(regI), numIters}, ",");
    }
}

