/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.intf.IterativeRecommender;
import librec.util.Lists;
import librec.util.Randoms;
import librec.util.Strings;

public class WBPR
extends IterativeRecommender {
    private List<Map.Entry<Integer, Double>> sortedItemPops;
    private LoadingCache<Integer, List<Map.Entry<Integer, Double>>> cacheItemProbs;

    public WBPR(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.itemBias = new DenseVector(numItems);
        this.itemBias.init(smallValue);
        this.userItemsCache = this.trainMatrix.rowColumnsCache(cacheSpec);
        this.sortedItemPops = new ArrayList<Map.Entry<Integer, Double>>();
        int i = 0;
        while (i < numItems) {
            this.sortedItemPops.add(new AbstractMap.SimpleEntry<Integer, Double>(i, (double)this.trainMatrix.columnSize(i) + 0.0));
            ++i;
        }
        Lists.sortList(this.sortedItemPops, true);
        this.cacheItemProbs = CacheBuilder.from(cacheSpec).build(new CacheLoader<Integer, List<Map.Entry<Integer, Double>>>(){

            @Override
            public List<Map.Entry<Integer, Double>> load(Integer u) throws Exception {
                ArrayList<Map.Entry<Integer, Double>> itemProbs = new ArrayList<Map.Entry<Integer, Double>>();
                List ratedItems = (List)WBPR.this.userItemsCache.get(u);
                double sum = 0.0;
                for (Map.Entry entry : WBPR.this.sortedItemPops) {
                    Integer item = (Integer)entry.getKey();
                    double popularity = (Double)entry.getValue();
                    if (ratedItems.contains(item) || !(popularity > 0.0)) continue;
                    itemProbs.add(new AbstractMap.SimpleEntry(entry));
                    sum += popularity;
                }
                for (Map.Entry entry : itemProbs) {
                    entry.setValue((Double)entry.getValue() / sum);
                }
                return itemProbs;
            }
        });
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            int s = 0;
            int smax = numUsers * 100;
            while (s < smax) {
                int u = 0;
                int i = 0;
                int j = 0;
                List ratedItems = null;
                List<Map.Entry<Integer, Double>> itemProbs = null;
                while ((ratedItems = (List)this.userItemsCache.get(u = Randoms.uniform(numUsers))).size() == 0) {
                }
                i = (Integer)Randoms.random(ratedItems);
                itemProbs = this.cacheItemProbs.get(u);
                double rand = Randoms.random();
                double sum = 0.0;
                for (Map.Entry<Integer, Double> itemProb : itemProbs) {
                    if (!((sum += itemProb.getValue().doubleValue()) >= rand)) continue;
                    j = itemProb.getKey();
                    break;
                }
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                double bi = this.itemBias.get(i);
                double bj = this.itemBias.get(j);
                this.itemBias.add(i, this.lRate * (cmg - (double)regB * bi));
                this.itemBias.add(j, this.lRate * (-cmg - (double)regB * bj));
                this.loss += (double)regB * (bi * bi + bj * bj);
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double qif = this.Q.get(i, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (cmg * (qif - qjf) - (double)regU * puf));
                    this.Q.add(i, f, this.lRate * (cmg * puf - (double)regI * qif));
                    this.Q.add(j, f, this.lRate * (cmg * -puf - (double)regI * qjf));
                    this.loss += (double)regU * puf * puf + (double)regI * qif * qif + (double)regI * qjf * qjf;
                    ++f;
                }
                ++s;
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(regU), Float.valueOf(regI), Float.valueOf(regB), numIters});
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        return this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }
}

