/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;
import librec.util.Lists;
import librec.util.Randoms;
import librec.util.Strings;

public class RankSGD
extends IterativeRecommender {
    protected List<Map.Entry<Integer, Double>> itemProbs;

    public RankSGD(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.checkBinary();
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        HashMap<Integer, Double> itemProbsMap = new HashMap<Integer, Double>();
        int j = 0;
        while (j < numItems) {
            int users = this.trainMatrix.columnSize(j);
            double prob = ((double)users + 0.0) / (double)numRates;
            if (prob > 0.0) {
                itemProbsMap.put(j, prob);
            }
            ++j;
        }
        this.itemProbs = Lists.sortMap(itemProbsMap);
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            for (int u : this.trainMatrix.rows()) {
                SparseVector Ru = this.trainMatrix.row(u);
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    double rui = ve.get();
                    int j = -1;
                    block3: do {
                        double sum = 0.0;
                        double rand = Randoms.random();
                        for (Map.Entry<Integer, Double> en : this.itemProbs) {
                            int k = en.getKey();
                            double prob = en.getValue();
                            if (!((sum += prob) >= rand)) continue;
                            j = k;
                            continue block3;
                        }
                    } while (Ru.contains(j));
                    double ruj = 0.0;
                    double pui = this.predict(u, i);
                    double puj = this.predict(u, j);
                    double e = pui - puj - (rui - ruj);
                    this.loss += e * e;
                    double ye = this.lRate * e;
                    int f = 0;
                    while (f < numFactors) {
                        double puf = this.P.get(u, f);
                        double qif = this.Q.get(i, f);
                        double qjf = this.Q.get(j, f);
                        this.P.add(u, f, -ye * (qif - qjf));
                        this.Q.add(i, f, -ye * puf);
                        this.Q.add(j, f, ye * puf);
                        ++f;
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), Float.valueOf(initLRate), numIters}, ",");
    }
}

