/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.List;
import librec.data.Configuration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.IterativeRecommender;
import librec.util.Strings;

@Configuration(value="binThold, numFactors, initLRate, maxLRate, regU, regI, numIters")
public class LRMF
extends IterativeRecommender {
    public DenseVector userExp;

    public LRMF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.userExp = new DenseVector(numUsers);
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            double ruj = me.get();
            this.userExp.add(u, Math.exp(ruj));
        }
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = DenseMatrix.rowMult(this.P, u, this.Q, j);
                double uexp = 0.0;
                List<Integer> items = this.trainMatrix.getColumns(u);
                for (int i : items) {
                    uexp += Math.exp(DenseMatrix.rowMult(this.P, u, this.Q, i));
                }
                this.loss -= Math.exp(ruj) / this.userExp.get(u) * Math.log(Math.exp(pred) / uexp);
                int f = 0;
                while (f < numFactors) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    double delta_u = (Math.exp(ruj) / this.userExp.get(u) - Math.exp(pred) / uexp) * this.gd(pred) * qjf - (double)regU * puf;
                    double delta_j = (Math.exp(ruj) / this.userExp.get(u) - Math.exp(pred) / uexp) * this.gd(pred) * puf - (double)regI * qjf;
                    this.P.add(u, f, this.lRate * delta_u);
                    this.Q.add(j, f, this.lRate * delta_j);
                    this.loss += 0.5 * (double)regU * puf * puf + 0.5 * (double)regI * qjf * qjf;
                    ++f;
                }
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(regU), Float.valueOf(regI), numIters}, ",");
    }
}

