/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.HashBasedTable;
import librec.data.AddConfiguration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.GraphicRecommender;
import librec.util.Gamma;
import librec.util.Strings;

@AddConfiguration(before="factors, alpha, beta")
public class LDA
extends GraphicRecommender {
    public LDA(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
    }

    @Override
    protected void initModel() throws Exception {
        this.PukSum = new DenseMatrix(numUsers, numFactors);
        this.PkiSum = new DenseMatrix(numFactors, numItems);
        this.Nuk = new DenseMatrix(numUsers, numFactors);
        this.Nu = new DenseVector(numUsers);
        this.Nki = new DenseMatrix(numFactors, numItems);
        this.Nk = new DenseVector(numFactors);
        this.alpha = new DenseVector(numFactors);
        this.alpha.setAll(initAlpha);
        this.beta = new DenseVector(numItems);
        this.beta.setAll(initBeta);
        this.z = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            int t = (int)(Math.random() * (double)numFactors);
            this.z.put(u, i, t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            int t = (Integer)this.z.get(u, i);
            this.Nuk.add(u, t, -1.0);
            this.Nu.add(u, -1.0);
            this.Nki.add(t, i, -1.0);
            this.Nk.add(t, -1.0);
            double[] p = new double[numFactors];
            int k = 0;
            while (k < numFactors) {
                p[k] = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha) * (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
                ++k;
            }
            k = 1;
            while (k < p.length) {
                int n = k;
                p[n] = p[n] + p[k - 1];
                ++k;
            }
            double rand = Math.random() * p[numFactors - 1];
            t = 0;
            while (t < p.length) {
                if (rand < p[t]) break;
                ++t;
            }
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
            this.z.put(u, i, t);
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        int k = 0;
        while (k < numFactors) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            int u = 0;
            while (u < numUsers) {
                numerator += Gamma.digamma(this.Nuk.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.Nu.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
                ++u;
            }
            if (numerator != 0.0) {
                this.alpha.set(k, ak * (numerator / denominator));
            }
            ++k;
        }
        int i = 0;
        while (i < numItems) {
            double bi = this.beta.get(i);
            numerator = 0.0;
            denominator = 0.0;
            int k2 = 0;
            while (k2 < numFactors) {
                numerator += Gamma.digamma(this.Nki.get(k2, i) + bi) - Gamma.digamma(bi);
                denominator += Gamma.digamma(this.Nk.get(k2) + sumBeta) - Gamma.digamma(sumBeta);
                ++k2;
            }
            if (numerator != 0.0) {
                this.beta.set(i, bi * (numerator / denominator));
            }
            ++i;
        }
    }

    @Override
    protected void readoutParams() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        double val = 0.0;
        int u = 0;
        while (u < numUsers) {
            int k = 0;
            while (k < numFactors) {
                val = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha);
                this.PukSum.add(u, k, val);
                ++k;
            }
            ++u;
        }
        int k = 0;
        while (k < numFactors) {
            int i = 0;
            while (i < numItems) {
                val = (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
                this.PkiSum.add(k, i, val);
                ++i;
            }
            ++k;
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.Puk = this.PukSum.scale(1.0 / (double)this.numStats);
        this.Pki = this.PkiSum.scale(1.0 / (double)this.numStats);
    }

    @Override
    protected double ranking(int u, int j) throws Exception {
        return DenseMatrix.product(this.Puk, u, this.Pki, j);
    }

    @Override
    public String toString() {
        return String.valueOf(Strings.toString(new Object[]{numFactors, Float.valueOf(initAlpha), Float.valueOf(initBeta)})) + ", " + super.toString();
    }
}

