/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;

public class CLiMF
extends IterativeRecommender {
    public CLiMF(SparseMatrix rm, SparseMatrix tm, int fold) {
        super(rm, tm, fold);
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            int u = 0;
            while (u < numUsers) {
                int j;
                SparseVector uv = this.trainMatrix.row(u);
                double[] sgds = new double[numFactors];
                int f = 0;
                while (f < numFactors) {
                    double sgd = (double)(-regU) * this.P.get(u, f);
                    int[] nArray = uv.getIndex();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        j = nArray[n2];
                        double fuj = this.predict(u, j);
                        double qjf = this.Q.get(j, f);
                        sgd += this.g(-fuj) * qjf;
                        int[] nArray2 = uv.getIndex();
                        int n3 = nArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int k = nArray2[n4];
                            if (k != j) {
                                double fuk = this.predict(u, k);
                                double qkf = this.Q.get(k, f);
                                double x = fuk - fuj;
                                sgd += this.gd(x) / (1.0 - this.g(x)) * (qjf - qkf);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    sgds[f] = sgd;
                    ++f;
                }
                HashMap itemSgds = new HashMap();
                int[] nArray = uv.getIndex();
                j = nArray.length;
                int n = 0;
                while (n < j) {
                    int j2 = nArray[n];
                    double fuj2 = this.predict(u, j2);
                    ArrayList<Double> jSgds = new ArrayList<Double>();
                    int f2 = 0;
                    while (f2 < numFactors) {
                        double puf = this.P.get(u, f2);
                        double qjf = this.Q.get(j2, f2);
                        double yuj = uv.contains(j2) ? 1.0 : 0.0;
                        double sgd = yuj * this.g(-fuj2) * puf - (double)regI * qjf;
                        int[] nArray3 = uv.getIndex();
                        int n5 = nArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            int k = nArray3[n6];
                            if (k != j2) {
                                double fuk = this.predict(u, k);
                                double x = fuk - fuj2;
                                sgd += this.gd(-x) * (1.0 / (1.0 - this.g(x)) - 1.0 / (1.0 - this.g(-x))) * puf;
                            }
                            ++n6;
                        }
                        jSgds.add(sgd);
                        ++f2;
                    }
                    itemSgds.put(j2, jSgds);
                    ++n;
                }
                int f3 = 0;
                while (f3 < numFactors) {
                    this.P.add(u, f3, this.lRate * sgds[f3]);
                    ++f3;
                }
                int j3 = 0;
                while (j3 < numItems) {
                    List jSgds = (List)itemSgds.get(j3);
                    int f4 = 0;
                    while (f4 < numFactors) {
                        this.Q.add(j3, f4, this.lRate * (Double)jSgds.get(f4));
                        ++f4;
                    }
                    ++j3;
                }
                j3 = 0;
                while (j3 < numItems) {
                    if (uv.contains(j3)) {
                        double fuj = this.predict(u, j3);
                        this.loss += Math.log(this.g(fuj));
                        int[] nArray4 = uv.getIndex();
                        int n7 = nArray4.length;
                        int fuj2 = 0;
                        while (fuj2 < n7) {
                            int k = nArray4[fuj2];
                            double fuk = this.predict(u, k);
                            this.loss += Math.log(1.0 - this.g(fuk - fuj));
                            ++fuj2;
                        }
                    }
                    int f5 = 0;
                    while (f5 < numFactors) {
                        double puf = this.P.get(u, f5);
                        double qjf = this.Q.get(j3, f5);
                        this.loss += -0.5 * ((double)regU * puf * puf + (double)regI * qjf * qjf);
                        ++f5;
                    }
                    ++j3;
                }
                ++u;
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }
}

