/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import librec.data.AddConfiguration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.intf.GraphicRecommender;
import librec.util.Strings;

@AddConfiguration(before="K, L, alpha, beta, gamma, sigma")
public class BHfree
extends GraphicRecommender {
    private float initGamma;
    private float initSigma;
    private int K;
    private int L;
    private DenseMatrix Nkl;
    private int[][][] Nklr;
    private int[][][] Nkli;
    private Table<Integer, Integer, Integer> Zk;
    private Table<Integer, Integer, Integer> Zl;
    private DenseMatrix Puk;
    private DenseMatrix Pkl;
    private DenseMatrix PukSum;
    private DenseMatrix PklSum;
    private double[][][] Pklr;
    private double[][][] Pkli;
    private double[][][] PklrSum;
    private double[][][] PkliSum;

    public BHfree(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.K = algoOptions.getInt("-k");
        this.L = algoOptions.getInt("-l");
        initAlpha = pgmOptions.getFloat("-alpha", 1.0f / (float)this.K);
        initBeta = pgmOptions.getFloat("-beta", 1.0f / (float)this.L);
        this.initGamma = algoOptions.getFloat("-gamma", 1.0f / (float)numLevels);
        this.initSigma = algoOptions.getFloat("-sigma", 1.0f / (float)numItems);
        this.Nuk = new DenseMatrix(numUsers, this.K);
        this.Nu = new DenseVector(numUsers);
        this.Nkl = new DenseMatrix(this.K, this.L);
        this.Nk = new DenseVector(this.K);
        this.Nklr = new int[this.K][this.L][numLevels];
        this.Nkli = new int[this.K][this.L][numItems];
        this.Zk = HashBasedTable.create();
        this.Zl = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rate = me.get();
            int r = ratingScale.indexOf(rate);
            int k = (int)((double)this.K * Math.random());
            int l = (int)((double)this.L * Math.random());
            this.Nuk.add(u, k, 1.0);
            this.Nu.add(u, 1.0);
            this.Nkl.add(k, l, 1.0);
            this.Nk.add(k, 1.0);
            int[] nArray = this.Nklr[k][l];
            int n = r;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.Nkli[k][l];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + 1;
            this.Zk.put(u, i, k);
            this.Zl.put(u, i, l);
        }
        this.PukSum = new DenseMatrix(numUsers, this.K);
        this.PklSum = new DenseMatrix(this.K, this.L);
        this.PklrSum = new double[this.K][this.L][numLevels];
        this.Pklr = new double[this.K][this.L][numLevels];
        this.PkliSum = new double[this.K][this.L][numItems];
        this.Pkli = new double[this.K][this.L][numItems];
    }

    @Override
    protected void eStep() {
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rate = me.get();
            int r = ratingScale.indexOf(rate);
            int k = this.Zk.get(u, i);
            int l = this.Zl.get(u, i);
            this.Nuk.add(u, k, -1.0);
            this.Nu.add(u, -1.0);
            this.Nkl.add(k, l, -1.0);
            this.Nk.add(k, -1.0);
            int[] nArray = this.Nklr[k][l];
            int n = r;
            nArray[n] = nArray[n] - 1;
            int[] nArray2 = this.Nkli[k][l];
            int n2 = i;
            nArray2[n2] = nArray2[n2] - 1;
            DenseMatrix Pzw = new DenseMatrix(this.K, this.L);
            double sum = 0.0;
            int z = 0;
            while (z < this.K) {
                int w = 0;
                while (w < this.L) {
                    double v1 = (this.Nuk.get(u, k) + (double)initAlpha) / (this.Nu.get(u) + (double)((float)this.K * initAlpha));
                    double v2 = (this.Nkl.get(k, l) + (double)initBeta) / (this.Nk.get(k) + (double)((float)this.L * initBeta));
                    double v3 = (double)((float)this.Nklr[k][l][r] + this.initGamma) / (this.Nkl.get(k, l) + (double)((float)numLevels * this.initGamma));
                    double v4 = (double)((float)this.Nkli[k][l][i] + this.initSigma) / (this.Nkl.get(k, l) + (double)((float)numItems * this.initSigma));
                    double val = v1 * v2 * v3 * v4;
                    Pzw.set(z, w, val);
                    sum += val;
                    ++w;
                }
                ++z;
            }
            Pzw = Pzw.scale(1.0 / sum);
            double[] Pz = new double[this.K];
            int z2 = 0;
            while (z2 < this.K) {
                Pz[z2] = Pzw.sumOfRow(z2);
                ++z2;
            }
            z2 = 1;
            while (z2 < this.K) {
                int n3 = z2;
                Pz[n3] = Pz[n3] + Pz[z2 - 1];
                ++z2;
            }
            double rand = Math.random();
            k = 0;
            while (k < this.K) {
                if (rand < Pz[k]) break;
                ++k;
            }
            double[] Pw = new double[this.L];
            int w = 0;
            while (w < this.L) {
                Pw[w] = Pzw.sumOfColumn(w);
                ++w;
            }
            w = 1;
            while (w < this.L) {
                int n4 = w;
                Pw[n4] = Pw[n4] + Pw[w - 1];
                ++w;
            }
            rand = Math.random();
            l = 0;
            while (l < this.L) {
                if (rand < Pw[l]) break;
                ++l;
            }
            this.Nuk.add(u, k, 1.0);
            this.Nu.add(u, 1.0);
            this.Nkl.add(k, l, 1.0);
            this.Nk.add(k, 1.0);
            int[] nArray3 = this.Nklr[k][l];
            int n5 = r;
            nArray3[n5] = nArray3[n5] + 1;
            int[] nArray4 = this.Nkli[k][l];
            int n6 = i;
            nArray4[n6] = nArray4[n6] + 1;
            this.Zk.put(u, i, k);
            this.Zl.put(u, i, l);
        }
    }

    @Override
    protected void readoutParams() {
        int l;
        int u = 0;
        while (u < numUsers) {
            int k = 0;
            while (k < this.K) {
                this.PukSum.add(u, k, (this.Nuk.get(u, k) + (double)initAlpha) / (this.Nu.get(u) + (double)((float)this.K * initAlpha)));
                ++k;
            }
            ++u;
        }
        int k = 0;
        while (k < this.K) {
            l = 0;
            while (l < this.L) {
                this.PklSum.add(k, l, (this.Nkl.get(k, l) + (double)initBeta) / (this.Nk.get(k) + (double)((float)this.L * initBeta)));
                ++l;
            }
            ++k;
        }
        k = 0;
        while (k < this.K) {
            l = 0;
            while (l < this.L) {
                int r = 0;
                while (r < numLevels) {
                    double[] dArray = this.PklrSum[k][l];
                    int n = r;
                    dArray[n] = dArray[n] + (double)((float)this.Nklr[k][l][r] + this.initGamma) / (this.Nkl.get(k, l) + (double)((float)numLevels * this.initGamma));
                    ++r;
                }
                ++l;
            }
            ++k;
        }
        k = 0;
        while (k < this.K) {
            l = 0;
            while (l < this.L) {
                int i = 0;
                while (i < numItems) {
                    double[] dArray = this.PkliSum[k][l];
                    int n = i;
                    dArray[n] = dArray[n] + (double)((float)this.Nkli[k][l][i] + this.initSigma) / (this.Nkl.get(k, l) + (double)((float)numItems * this.initSigma));
                    ++i;
                }
                ++l;
            }
            ++k;
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        int l;
        double scale = 1.0 / (double)this.numStats;
        this.Puk = this.PukSum.scale(scale);
        this.Pkl = this.PklSum.scale(scale);
        int k = 0;
        while (k < this.K) {
            l = 0;
            while (l < this.L) {
                int r = 0;
                while (r < numLevels) {
                    this.Pklr[k][l][r] = this.PklrSum[k][l][r] * scale;
                    ++r;
                }
                ++l;
            }
            ++k;
        }
        k = 0;
        while (k < this.K) {
            l = 0;
            while (l < this.L) {
                int i = 0;
                while (i < numItems) {
                    this.Pkli[k][l][i] = this.PkliSum[k][l][i] * scale;
                    ++i;
                }
                ++l;
            }
            ++k;
        }
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        double sum = 0.0;
        double probs = 0.0;
        int r = 0;
        while (r < numLevels) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            int k = 0;
            while (k < this.K) {
                int l = 0;
                while (l < this.L) {
                    prob += this.Puk.get(u, k) * this.Pkl.get(k, l) * this.Pklr[k][l][r];
                    ++l;
                }
                ++k;
            }
            sum += rate * prob;
            probs += prob;
            ++r;
        }
        return sum / probs;
    }

    @Override
    protected double ranking(int u, int j) throws Exception {
        double rank = 0.0;
        int r = 0;
        while (r < numLevels) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            int k = 0;
            while (k < this.K) {
                int l = 0;
                while (l < this.L) {
                    prob += this.Puk.get(u, k) * this.Pkl.get(k, l) * this.Pkli[k][l][j] * this.Pklr[k][l][r];
                    ++l;
                }
                ++k;
            }
            rank += rate * prob;
            ++r;
        }
        return rank;
    }

    @Override
    public String toString() {
        return String.valueOf(Strings.toString(new Object[]{this.K, this.L, Float.valueOf(initAlpha), Float.valueOf(initBeta), Float.valueOf(this.initGamma), Float.valueOf(this.initSigma)})) + ", " + super.toString();
    }
}

