/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import java.util.List;
import librec.data.Configuration;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseTensor;
import librec.intf.IterativeRecommender;
import librec.util.Strings;

@Configuration(value="factors, lRate, maxLRate, reg, iters, boldDriver")
public class TensorRecommender
extends IterativeRecommender {
    protected static SparseTensor rateTensor = rateDao.getRateTensor();
    protected static int numDimensions = rateTensor.numDimensions();
    protected static int userDimension;
    protected static int itemDimension;
    protected static int[] dimensions;
    protected SparseTensor trainTensor = rateTensor.clone();
    protected SparseTensor testTensor = new SparseTensor(dimensions);

    static {
        dimensions = rateTensor.dimensions();
        userDimension = rateTensor.getUserDimension();
        itemDimension = rateTensor.getItemDimension();
    }

    public TensorRecommender(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) throws Exception {
        super(trainMatrix, testMatrix, fold);
        this.testTensor.setUserDimension(userDimension);
        this.testTensor.setItemDimension(itemDimension);
        for (MatrixEntry me : testMatrix) {
            int u = me.row();
            int i = me.column();
            List<Integer> indices = rateTensor.getIndices(u, i);
            for (int index : indices) {
                int[] keys = rateTensor.keys(index);
                this.testTensor.set(rateTensor.value(index), keys);
                this.trainTensor.remove(keys);
            }
        }
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(reg), numIters, isBoldDriver});
    }
}

