/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import librec.data.AddConfiguration;
import librec.data.Configuration;
import librec.data.DataDAO;
import librec.data.DataSplitter;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.SymmMatrix;
import librec.util.Dates;
import librec.util.FileConfiger;
import librec.util.FileIO;
import librec.util.LineConfiger;
import librec.util.Lists;
import librec.util.Logs;
import librec.util.Measures;
import librec.util.Stats;

@Configuration
public abstract class Recommender
implements Runnable {
    public static FileConfiger cf;
    public static SparseMatrix rateMatrix;
    public static SparseMatrix timeMatrix;
    public static String tempDirPath;
    public static Map<String, List<Float>> params;
    protected static String cacheSpec;
    protected static int numCPUs;
    protected static boolean verbose;
    protected static LineConfiger rankOptions;
    protected static LineConfiger algoOptions;
    public static boolean isRankingPred;
    public static float binThold;
    public static float validationRatio;
    protected static boolean isDiverseUsed;
    protected static Measure earlyStopMeasure;
    protected static boolean isSaveModel;
    protected static boolean isSplitByDate;
    public static String view;
    public static DataDAO rateDao;
    protected static int numUsers;
    protected static int numItems;
    protected static int numRates;
    protected static int numRecs;
    protected static int numIgnore;
    protected static List<Double> ratingScale;
    protected static int numLevels;
    protected static double maxRate;
    protected static double minRate;
    public static SparseMatrix testTimeMatrix;
    protected static long minTimestamp;
    protected static long maxTimestamp;
    protected static double initMean;
    protected static double initStd;
    protected static double smallValue;
    protected static int knn;
    protected static String similarityMeasure;
    protected static int similarityShrinkage;
    public static boolean resetStatics;
    public String algoName;
    protected int fold;
    protected String foldInfo;
    protected boolean isResultsOut = true;
    protected LoadingCache<Integer, SparseVector> userCache;
    protected LoadingCache<Integer, SparseVector> itemCache;
    protected LoadingCache<Integer, List<Integer>> userItemsCache;
    protected LoadingCache<Integer, List<Integer>> itemUsersCache;
    protected SparseMatrix trainMatrix;
    protected SparseMatrix validationMatrix;
    protected SparseMatrix testMatrix;
    protected SymmMatrix corrs;
    public Map<Measure, Double> measures;
    protected double globalMean;

    static {
        params = new HashMap<String, List<Float>>();
        verbose = true;
        earlyStopMeasure = null;
        isSaveModel = false;
        smallValue = 0.01;
        resetStatics = true;
    }

    public Recommender(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        if (cf == null || rateMatrix == null) {
            Logs.error("Recommender is not well configed");
            System.exit(-1);
        }
        if (resetStatics) {
            resetStatics = false;
            ratingScale = rateDao.getRatingScale();
            minRate = ratingScale.get(0);
            maxRate = ratingScale.get(ratingScale.size() - 1);
            numLevels = ratingScale.size();
            numUsers = rateDao.numUsers();
            numItems = rateDao.numItems();
            minTimestamp = rateDao.getMinTimestamp();
            maxTimestamp = rateDao.getMaxTimestamp();
            if (testTimeMatrix == null) {
                testTimeMatrix = timeMatrix;
            }
            initMean = 0.0;
            initStd = 0.1;
            cacheSpec = cf.getString("guava.cache.spec", "maximumSize=200,expireAfterAccess=2m");
            rankOptions = cf.getParamOptions("item.ranking");
            isRankingPred = rankOptions.isMainOn();
            isDiverseUsed = rankOptions.contains("-diverse");
            numRecs = rankOptions.getInt("-topN", -1);
            numIgnore = rankOptions.getInt("-ignore", -1);
            LineConfiger evalOptions = cf.getParamOptions("evaluation.setup");
            view = evalOptions.getString("--test-view", "all");
            validationRatio = evalOptions.getFloat("-v", 0.0f);
            isSplitByDate = evalOptions.contains("--by-date");
            String earlyStop = evalOptions.getString("--early-stop");
            if (earlyStop != null) {
                Measure[] measureArray = Measure.values();
                int n = measureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Measure m = measureArray[n2];
                    if (m.name().equalsIgnoreCase(earlyStop)) {
                        earlyStopMeasure = m;
                        break;
                    }
                    ++n2;
                }
            }
            int numProcessors = Runtime.getRuntime().availableProcessors();
            numCPUs = evalOptions.getInt("-cpu", numProcessors);
            LineConfiger outputOptions = cf.getParamOptions("output.setup");
            if (outputOptions != null) {
                verbose = outputOptions.isOn("-verbose", true);
                isSaveModel = outputOptions.contains("--save-model");
            }
            knn = cf.getInt("num.neighbors", 20);
            similarityMeasure = cf.getString("similarity", "PCC");
            similarityShrinkage = cf.getInt("num.shrinkage", 30);
        }
        if (validationRatio > 0.0f && validationRatio < 1.0f) {
            DataSplitter ds = new DataSplitter(trainMatrix);
            double ratio = 1.0f - validationRatio;
            SparseMatrix[] trainSubsets = isSplitByDate ? ds.getRatioByRatingDate(ratio, timeMatrix) : ds.getRatioByRating(ratio);
            this.trainMatrix = trainSubsets[0];
            this.validationMatrix = trainSubsets[1];
        } else {
            this.trainMatrix = trainMatrix;
        }
        this.testMatrix = testMatrix;
        this.fold = fold;
        this.foldInfo = fold > 0 ? " fold [" + fold + "]" : "";
        LineConfiger outputOptions = cf.getParamOptions("output.setup");
        if (outputOptions != null) {
            this.isResultsOut = outputOptions.isMainOn();
        }
        numRates = trainMatrix.size();
        this.globalMean = trainMatrix.sum() / (double)numRates;
        this.setAlgoName(this.getClass().getSimpleName());
        if (isRankingPred && isDiverseUsed) {
            this.corrs = new SymmMatrix(numItems);
        }
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            Logs.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public void execute() throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        this.initModel();
        this.printAlgoConfig();
        this.buildModel();
        this.postModel();
        long trainTime = sw.elapsed(TimeUnit.MILLISECONDS);
        if (validationRatio > 0.0f && validationRatio < 1.0f) {
            this.validateModel();
            trainTime = sw.elapsed(TimeUnit.MILLISECONDS);
        }
        if (verbose) {
            Logs.debug("{}{} evaluate test data ... ", this.algoName, this.foldInfo);
        }
        this.measures = isRankingPred ? this.evalRankings() : this.evalRatings();
        String measurements = Recommender.getEvalInfo(this.measures);
        sw.stop();
        long testTime = sw.elapsed(TimeUnit.MILLISECONDS) - trainTime;
        this.measures.put(Measure.TrainTime, Double.valueOf(trainTime));
        this.measures.put(Measure.TestTime, Double.valueOf(testTime));
        String evalInfo = String.valueOf(this.algoName) + this.foldInfo + ": " + measurements + "\tTime: " + Dates.parse(this.measures.get((Object)Measure.TrainTime).longValue()) + ", " + Dates.parse(this.measures.get((Object)Measure.TestTime).longValue());
        if (!isRankingPred) {
            evalInfo = String.valueOf(evalInfo) + "\tView: " + view;
        }
        if (this.fold > 0) {
            Logs.debug(evalInfo);
        }
        if (isSaveModel) {
            this.saveModel();
        }
    }

    private void printAlgoConfig() {
        String algoInfo = this.toString();
        Class<?> cl = this.getClass();
        String algoConfig = cl.getAnnotation(Configuration.class).value();
        if (cl.isAnnotationPresent(AddConfiguration.class)) {
            String after;
            AddConfiguration add = cl.getAnnotation(AddConfiguration.class);
            String before = add.before();
            if (!Strings.isNullOrEmpty(before)) {
                algoConfig = String.valueOf(before) + ", " + algoConfig;
            }
            if (!Strings.isNullOrEmpty(after = add.after())) {
                algoConfig = String.valueOf(algoConfig) + ", " + after;
            }
        }
        if (!algoInfo.isEmpty()) {
            if (!algoConfig.isEmpty()) {
                Logs.debug("{}: [{}] = [{}]", this.algoName, algoConfig, algoInfo);
            } else {
                Logs.debug("{}: {}", this.algoName, algoInfo);
            }
        }
    }

    protected void validateModel() {
    }

    public static String getEvalInfo(Map<Measure, Double> measures) {
        String evalInfo = null;
        if (isRankingPred) {
            evalInfo = isDiverseUsed ? String.format("%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.AUC), measures.get((Object)Measure.MAP), measures.get((Object)Measure.NDCG), measures.get((Object)Measure.MRR), measures.get((Object)Measure.D5), measures.get((Object)Measure.D10)) : String.format("%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.AUC), measures.get((Object)Measure.MAP), measures.get((Object)Measure.NDCG), measures.get((Object)Measure.MRR));
        } else {
            evalInfo = String.format("%.6f,%.6f,%.6f,%.6f,%.6f,%.6f", measures.get((Object)Measure.MAE), measures.get((Object)Measure.RMSE), measures.get((Object)Measure.NMAE), measures.get((Object)Measure.rMAE), measures.get((Object)Measure.rRMSE), measures.get((Object)Measure.MPE));
            if (measures.containsKey((Object)Measure.Perplexity)) {
                evalInfo = String.valueOf(evalInfo) + String.format(",%.6f", measures.get((Object)Measure.Perplexity));
            }
        }
        return evalInfo;
    }

    protected void initModel() throws Exception {
    }

    protected LineConfiger getModelParams(String algoName) {
        return cf.contains(algoName) ? cf.getParamOptions(algoName) : null;
    }

    protected SymmMatrix buildCorrs(boolean isUser) {
        Logs.debug("Build {} similarity matrix ...", (Object)(isUser ? "user" : "item"));
        int count = isUser ? numUsers : numItems;
        SymmMatrix corrs = new SymmMatrix(count);
        int i = 0;
        while (i < count) {
            SparseVector iv;
            SparseVector sparseVector = iv = isUser ? this.trainMatrix.row(i) : this.trainMatrix.column(i);
            if (iv.getCount() != 0) {
                int j = i + 1;
                while (j < count) {
                    SparseVector jv = isUser ? this.trainMatrix.row(j) : this.trainMatrix.column(j);
                    double sim = this.correlation(iv, jv);
                    if (!Double.isNaN(sim)) {
                        corrs.set(i, j, sim);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return corrs;
    }

    protected double correlation(SparseVector iv, SparseVector jv) {
        return this.correlation(iv, jv, similarityMeasure);
    }

    /*
     * Exception decompiling
     */
    protected double correlation(SparseVector iv, SparseVector jv, String method) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl73 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl73 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void buildModel() throws Exception {
    }

    protected void postModel() throws Exception {
    }

    protected void saveModel() throws Exception {
    }

    protected void loadModel() throws Exception {
    }

    /*
     * Exception decompiling
     */
    protected boolean isTestable(int u, int j) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Map<Measure, Double> evalRatings() throws Exception {
        ArrayList<String> preds = null;
        String toFile = null;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("# userId itemId rating prediction");
            toFile = String.valueOf(tempDirPath) + this.algoName + "-rating-predictions" + this.foldInfo + ".txt";
            FileIO.deleteFile(toFile);
        }
        double sum_maes = 0.0;
        double sum_mses = 0.0;
        double sum_r_maes = 0.0;
        double sum_r_rmses = 0.0;
        double sum_perps = 0.0;
        int numCount = 0;
        int numPEs = 0;
        for (MatrixEntry me : this.testMatrix) {
            double pred;
            int j;
            double rate = me.get();
            int u = me.row();
            if (!this.isTestable(u, j = me.column()) || Double.isNaN(pred = this.predict(u, j, true))) continue;
            double perp = this.perplexity(u, j, pred);
            sum_perps += perp;
            double rPred = (double)Math.round(pred / minRate) * minRate;
            double err = Math.abs(rate - pred);
            double r_err = Math.abs(rate - rPred);
            sum_maes += err;
            sum_mses += err * err;
            sum_r_maes += r_err;
            sum_r_rmses += r_err * r_err;
            ++numCount;
            if (r_err > 1.0E-5) {
                ++numPEs;
            }
            if (!this.isResultsOut) continue;
            preds.add(String.valueOf(rateDao.getUserId(u)) + " " + rateDao.getItemId(j) + " " + rate + " " + (float)pred);
            if (preds.size() < 1000) continue;
            FileIO.writeList(toFile, preds, true);
            preds.clear();
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen rating predictions to {}", this.algoName, this.foldInfo, toFile);
        }
        double mae = sum_maes / (double)numCount;
        double rmse = Math.sqrt(sum_mses / (double)numCount);
        double r_mae = sum_r_maes / (double)numCount;
        double r_rmse = Math.sqrt(sum_r_rmses / (double)numCount);
        HashMap<Measure, Double> measures = new HashMap<Measure, Double>();
        measures.put(Measure.MAE, mae);
        measures.put(Measure.NMAE, mae / (maxRate - minRate));
        measures.put(Measure.RMSE, rmse);
        measures.put(Measure.rMAE, r_mae);
        measures.put(Measure.rRMSE, r_rmse);
        measures.put(Measure.MPE, ((double)numPEs + 0.0) / (double)numCount);
        if (sum_perps > 0.0) {
            measures.put(Measure.Perplexity, Math.exp(sum_perps / (double)numCount));
        }
        return measures;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<Measure, Double> evalRankings() throws Exception {
        int numTopNRanks;
        int capacity = Lists.initSize(this.testMatrix.numRows());
        ArrayList<Double> ds5 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> ds10 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> precs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> precs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls5 = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls10 = new ArrayList<Double>(capacity);
        ArrayList<Double> aps = new ArrayList<Double>(capacity);
        ArrayList<Double> rrs = new ArrayList<Double>(capacity);
        ArrayList<Double> aucs = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgs = new ArrayList<Double>(capacity);
        HashSet<Integer> candItems = new HashSet<Integer>(this.trainMatrix.columns());
        ArrayList<String> preds = null;
        String toFile = null;
        int n = numTopNRanks = numRecs < 0 ? 10 : numRecs;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("# userId: recommendations in (itemId, ranking score) pairs, where a correct recommendation is denoted by symbol *.");
            toFile = String.valueOf(tempDirPath) + String.format("%s-top-%d-items%s.txt", this.algoName, numTopNRanks, this.foldInfo);
            FileIO.deleteFile(toFile);
        }
        if (verbose) {
            Logs.debug("{}{} has candidate items: {}", this.algoName, this.foldInfo, candItems.size());
        }
        if (numIgnore > 0) {
            ArrayList itemDegs = new ArrayList();
            for (Integer j : candItems) {
                itemDegs.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(j, this.trainMatrix.columnSize(j)));
            }
            Lists.sortList(itemDegs, true);
            int k = 0;
            for (Map.Entry entry : itemDegs) {
                candItems.remove(entry.getKey());
                if (++k >= numIgnore) break;
            }
        }
        int u = 0;
        int um = this.testMatrix.numRows();
        while (u < um) {
            if (verbose && (u + 1) % 100 == 0) {
                Logs.debug("{}{} evaluates progress: {} / {}", this.algoName, this.foldInfo, u + 1, um);
            }
            int n2 = candItems.size();
            List<Integer> testItems = this.testMatrix.getColumns(u);
            ArrayList<Integer> correctItems = new ArrayList<Integer>();
            for (Integer j : testItems) {
                if (!candItems.contains(j)) continue;
                correctItems.add(j);
            }
            if (correctItems.size() != 0) {
                void var18_23;
                List<Integer> ratedItems = this.trainMatrix.getColumns(u);
                ArrayList itemScores = new ArrayList(Lists.initSize(candItems));
                for (Integer j : candItems) {
                    if (!ratedItems.contains(j)) {
                        double rank = this.ranking(u, j);
                        if (Double.isNaN(rank)) continue;
                        itemScores.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(j, rank));
                        continue;
                    }
                    --var18_23;
                }
                if (itemScores.size() != 0) {
                    Lists.sortList(itemScores, true);
                    ArrayList recomd = numRecs <= 0 || itemScores.size() <= numRecs ? itemScores : itemScores.subList(0, numRecs);
                    ArrayList<Integer> rankedItems = new ArrayList<Integer>();
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (Map.Entry entry : recomd) {
                        Integer item = (Integer)entry.getKey();
                        rankedItems.add(item);
                        if (!this.isResultsOut || count >= numTopNRanks) continue;
                        sb.append("(").append(rateDao.getItemId(item));
                        if (testItems.contains(item)) {
                            sb.append("*");
                        }
                        sb.append(", ").append(((Double)entry.getValue()).floatValue()).append(")");
                        if (++count >= numTopNRanks) continue;
                        sb.append(", ");
                    }
                    void var27_35 = var18_23 - rankedItems.size();
                    double AUC = Measures.AUC(rankedItems, correctItems, (int)var27_35);
                    double AP = Measures.AP(rankedItems, correctItems);
                    double nDCG = Measures.nDCG(rankedItems, correctItems);
                    double RR = Measures.RR(rankedItems, correctItems);
                    List<Integer> cutoffs = Arrays.asList(5, 10);
                    Map<Integer, Double> precs = Measures.PrecAt(rankedItems, correctItems, cutoffs);
                    Map<Integer, Double> recalls = Measures.RecallAt(rankedItems, correctItems, cutoffs);
                    precs5.add(precs.get(5));
                    precs10.add(precs.get(10));
                    recalls5.add(recalls.get(5));
                    recalls10.add(recalls.get(10));
                    aucs.add(AUC);
                    aps.add(AP);
                    rrs.add(RR);
                    ndcgs.add(nDCG);
                    if (isDiverseUsed) {
                        double d5 = this.diverseAt(rankedItems, 5);
                        double d10 = this.diverseAt(rankedItems, 10);
                        ds5.add(d5);
                        ds10.add(d10);
                    }
                    if (this.isResultsOut) {
                        preds.add(String.valueOf(rateDao.getUserId(u)) + ": " + sb.toString());
                        if (preds.size() >= 1000) {
                            FileIO.writeList(toFile, preds, true);
                            preds.clear();
                        }
                    }
                }
            }
            ++u;
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen item recommendations to {}", this.algoName, this.foldInfo, toFile);
        }
        HashMap<Measure, Double> measures = new HashMap<Measure, Double>();
        measures.put(Measure.D5, isDiverseUsed ? Stats.mean(ds5) : 0.0);
        measures.put(Measure.D10, isDiverseUsed ? Stats.mean(ds10) : 0.0);
        measures.put(Measure.Pre5, Stats.mean(precs5));
        measures.put(Measure.Pre10, Stats.mean(precs10));
        measures.put(Measure.Rec5, Stats.mean(recalls5));
        measures.put(Measure.Rec10, Stats.mean(recalls10));
        measures.put(Measure.AUC, Stats.mean(aucs));
        measures.put(Measure.NDCG, Stats.mean(ndcgs));
        measures.put(Measure.MAP, Stats.mean(aps));
        measures.put(Measure.MRR, Stats.mean(rrs));
        return measures;
    }

    protected double predict(int u, int j, boolean bound) throws Exception {
        double pred = this.predict(u, j);
        if (bound) {
            if (pred > maxRate) {
                pred = maxRate;
            }
            if (pred < minRate) {
                pred = minRate;
            }
        }
        return pred;
    }

    protected double predict(int u, int j) throws Exception {
        return this.globalMean;
    }

    protected double perplexity(int u, int j, double r) throws Exception {
        return 0.0;
    }

    protected double ranking(int u, int j) throws Exception {
        return this.predict(u, j, false);
    }

    protected double diverseAt(List<Integer> rankedItems, int cutoff) {
        int num = 0;
        double sum = 0.0;
        int id = 0;
        while (id < cutoff) {
            int i = rankedItems.get(id);
            SparseVector iv = this.trainMatrix.column(i);
            int jd = id + 1;
            while (jd < cutoff) {
                int j = rankedItems.get(jd);
                double corr = this.corrs.get(i, j);
                if (corr == 0.0 && !Double.isNaN(corr = this.correlation(iv, this.trainMatrix.column(j)))) {
                    this.corrs.set(i, j, corr);
                }
                if (!Double.isNaN(corr)) {
                    sum += 1.0 - corr;
                    ++num;
                }
                ++jd;
            }
            ++id;
        }
        return 0.5 * (sum / (double)num);
    }

    protected double g(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    protected double gd(double x) {
        return this.g(x) * this.g(-x);
    }

    protected double gaussian(double x, double mu, double sigma) {
        return Math.exp(-0.5 * Math.pow(x - mu, 2.0) / (sigma * sigma));
    }

    protected double normalize(double rate) {
        return (rate - minRate) / (maxRate - minRate);
    }

    protected void checkBinary() {
        if (binThold < 0.0f) {
            Logs.error("val.binary.threshold={}, ratings must be binarized first! Try set a non-negative value.", (Object)Float.valueOf(binThold));
            System.exit(-1);
        }
    }

    protected double denormalize(double pred) {
        return minRate + pred * (maxRate - minRate);
    }

    public String toString() {
        return "";
    }

    protected void setAlgoName(String algoName) {
        this.algoName = algoName;
        algoOptions = this.getModelParams(algoName);
    }

    public static enum Measure {
        MAE,
        RMSE,
        NMAE,
        rMAE,
        rRMSE,
        MPE,
        Perplexity,
        D5,
        D10,
        Pre5,
        Pre10,
        Rec5,
        Rec10,
        MAP,
        MRR,
        NDCG,
        AUC,
        TrainTime,
        TestTime,
        Loss;

    }
}

