/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.google.common.collect.Table;
import librec.data.Configuration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.intf.Recommender;
import librec.util.LineConfiger;
import librec.util.Logs;
import librec.util.Strings;

@Configuration(value="iters, burn.in, sample.lag")
public class GraphicRecommender
extends Recommender {
    protected static LineConfiger pgmOptions;
    protected static int numFactors;
    protected static float initAlpha;
    protected static float initBeta;
    protected static int burnIn;
    protected static int sampleLag;
    protected static int numIters;
    protected static int numIntervals;
    public static boolean isInitialized;
    protected Table<Integer, Integer, Integer> z;
    protected DenseMatrix Nik;
    protected DenseMatrix Nki;
    protected DenseMatrix Nuk;
    protected DenseVector Nk;
    protected DenseVector Nu;
    protected DenseVector Ni;
    protected DenseVector alpha;
    protected DenseVector beta;
    protected DenseMatrix PukSum;
    protected DenseMatrix PikSum;
    protected DenseMatrix PkiSum;
    protected DenseMatrix Puk;
    protected DenseMatrix Pki;
    protected DenseMatrix Pik;
    protected int numStats = 0;
    protected double loss;
    protected double lastLoss;

    static {
        isInitialized = false;
    }

    public GraphicRecommender(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        if (!isInitialized) {
            isInitialized = true;
            numFactors = cf.getInt("num.factors", 10);
            numIters = cf.getInt("num.max.iter", 30);
            pgmOptions = cf.getParamOptions("pgm.setup");
            if (pgmOptions != null) {
                burnIn = pgmOptions.getInt("-burn-in");
                sampleLag = pgmOptions.getInt("-sample-lag");
                numIntervals = pgmOptions.getInt("-interval");
                initAlpha = pgmOptions.getFloat("-alpha", 1.0f / (float)numFactors);
                initBeta = pgmOptions.getFloat("-beta", 1.0f / (float)numFactors);
                assert (burnIn > 0);
                assert (sampleLag > 0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.eStep();
            this.mStep();
            if (iter > burnIn && iter % sampleLag == 0) {
                this.readoutParams();
                if (this.isConverged(iter)) break;
            }
            if (verbose && iter % numIntervals == 0) {
                Logs.debug("{}{} runs at iter {}/{}", this.algoName, this.foldInfo, iter, numIters);
            }
            ++iter;
        }
        this.estimateParams();
    }

    protected void mStep() {
    }

    protected boolean isConverged(int iter) throws Exception {
        return false;
    }

    protected void estimateParams() {
    }

    protected void eStep() {
    }

    protected void inference() {
    }

    protected void readoutParams() {
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{numIters, burnIn, sampleLag}, ", ");
    }
}

