/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import librec.data.Configuration;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;
import librec.util.Strings;

@Configuration(value="factors, numIters")
public class NMF
extends IterativeRecommender {
    protected DenseMatrix W;
    protected DenseMatrix H;
    protected SparseMatrix V;

    public NMF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        this.lRate = -1.0;
    }

    @Override
    protected void initModel() throws Exception {
        this.W = new DenseMatrix(numUsers, numFactors);
        this.H = new DenseMatrix(numFactors, numItems);
        this.W.init(0.01);
        this.H.init(0.01);
        this.V = this.trainMatrix;
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            int u = 0;
            while (u < this.W.numRows()) {
                SparseVector uv = this.V.row(u);
                if (uv.getCount() > 0) {
                    SparseVector euv = new SparseVector(this.V.numColumns());
                    int[] nArray = uv.getIndex();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int j = nArray[n2];
                        euv.set(j, this.predict(u, j));
                        ++n2;
                    }
                    int f = 0;
                    while (f < this.W.numColumns()) {
                        DenseVector fv = this.H.row(f, false);
                        double real = fv.inner(uv);
                        double estm = fv.inner(euv) + 1.0E-9;
                        this.W.set(u, f, this.W.get(u, f) * (real / estm));
                        ++f;
                    }
                }
                ++u;
            }
            DenseMatrix trW = this.W.transpose();
            int j = 0;
            while (j < this.H.numColumns()) {
                SparseVector jv = this.V.column(j);
                if (jv.getCount() > 0) {
                    SparseVector ejv = new SparseVector(this.V.numRows());
                    int[] estm = jv.getIndex();
                    int n = estm.length;
                    int real = 0;
                    while (real < n) {
                        int u2 = estm[real];
                        ejv.set(u2, this.predict(u2, j));
                        ++real;
                    }
                    int f = 0;
                    while (f < this.H.numRows()) {
                        DenseVector fv = trW.row(f, false);
                        double real2 = fv.inner(jv);
                        double estm2 = fv.inner(ejv) + 1.0E-9;
                        this.H.set(f, j, this.H.get(f, j) * (real2 / estm2));
                        ++f;
                    }
                }
                ++j;
            }
            this.loss = 0.0;
            for (MatrixEntry me : this.V) {
                int u3 = me.row();
                int j2 = me.column();
                double ruj = me.get();
                if (!(ruj > 0.0)) continue;
                double euj = this.predict(u3, j2) - ruj;
                this.loss += euj * euj;
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j) {
        return DenseMatrix.product(this.W, u, this.H, j);
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{numFactors, numIters});
    }
}

