/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.Recommender;
import librec.util.Lists;

public class Hybrid
extends Recommender {
    Table<Integer, Integer, Double> userItemRanks = HashBasedTable.create();
    Table<Integer, Integer, Double> heatScores = HashBasedTable.create();
    Table<Integer, Integer, Double> probScores = HashBasedTable.create();
    protected float lambda;
    Map<Integer, Integer> userDegrees = new HashMap<Integer, Integer>();
    Map<Integer, Integer> itemDegrees = new HashMap<Integer, Integer>();
    double maxProb = Double.MIN_VALUE;
    double maxHeat = Double.MIN_VALUE;

    public Hybrid(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        this.algoName = "Hybrid (HeatS+ProbS)";
        isRankingPred = true;
        this.lambda = algoOptions.getFloat("-lambda");
    }

    @Override
    protected void initModel() throws Exception {
        int j = 0;
        while (j < numItems) {
            this.itemDegrees.put(j, this.trainMatrix.columnSize(j));
            ++j;
        }
    }

    protected double ranking_basic(int u, int j) {
        if (!this.heatScores.containsRow(u)) {
            int n;
            SparseVector iv;
            int n2;
            int n3;
            int[] nArray;
            int kj;
            double sum;
            SparseVector vv;
            this.heatScores.clear();
            this.probScores.clear();
            SparseVector uv = this.trainMatrix.row(u);
            List<Integer> items = Lists.toList(uv.getIndex());
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            int v = 0;
            while (v < numUsers) {
                vv = this.trainMatrix.row(v);
                sum = 0.0;
                kj = vv.getCount();
                nArray = vv.getIndex();
                n3 = nArray.length;
                n2 = 0;
                while (n2 < n3) {
                    int item = nArray[n2];
                    sum += items.contains(item) ? 1.0 : 0.0;
                    ++n2;
                }
                userResources.put(v, kj > 0 ? sum / (double)kj : 0.0);
                ++v;
            }
            this.maxHeat = Double.MIN_VALUE;
            int i = 0;
            while (i < numItems) {
                iv = this.trainMatrix.column(i);
                sum = 0.0;
                kj = iv.getCount();
                nArray = iv.getIndex();
                n3 = nArray.length;
                n2 = 0;
                while (n2 < n3) {
                    int user = nArray[n2];
                    sum += ((Double)userResources.get(user)).doubleValue();
                    ++n2;
                }
                double score = kj > 0 ? sum / (double)kj : 0.0;
                this.heatScores.put(u, i, score);
                if (score > this.maxHeat) {
                    this.maxHeat = score;
                }
                ++i;
            }
            userResources.clear();
            v = 0;
            while (v < numUsers) {
                vv = this.trainMatrix.row(v);
                sum = 0.0;
                int[] nArray2 = vv.getIndex();
                n2 = nArray2.length;
                n = 0;
                while (n < n2) {
                    int item = nArray2[n];
                    sum += items.contains(item) ? 1.0 / (double)this.itemDegrees.get(item).intValue() : 0.0;
                    ++n;
                }
                userResources.put(v, sum);
                ++v;
            }
            this.maxProb = Double.MIN_VALUE;
            i = 0;
            while (i < numItems) {
                iv = this.trainMatrix.column(i);
                double score = 0.0;
                int[] nArray3 = iv.getIndex();
                n2 = nArray3.length;
                n = 0;
                while (n < n2) {
                    int user = nArray3[n];
                    score += (Double)userResources.get(user) / (double)this.userDegrees.get(user).intValue();
                    ++n;
                }
                this.probScores.put(u, i, score);
                if (score > this.maxProb) {
                    this.maxProb = score;
                }
                ++i;
            }
        }
        return this.heatScores.contains(u, j) ? this.heatScores.get(u, j) / this.maxHeat * (double)(1.0f - this.lambda) + this.probScores.get(u, j) / this.maxProb * (double)this.lambda : 0.0;
    }

    @Override
    protected double ranking(int u, int j) {
        if (!this.userItemRanks.containsRow(u)) {
            int n;
            double sum;
            this.userItemRanks.clear();
            SparseVector uv = this.trainMatrix.row(u);
            List<Integer> items = Lists.toList(uv.getIndex());
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            int v = 0;
            while (v < numUsers) {
                SparseVector vv = this.trainMatrix.row(v);
                sum = 0.0;
                int kj = vv.getCount();
                int[] nArray = vv.getIndex();
                int n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    int item = nArray[n];
                    if (items.contains(item)) {
                        sum += 1.0 / Math.pow(this.itemDegrees.get(item).intValue(), this.lambda);
                    }
                    ++n;
                }
                if (kj > 0) {
                    userResources.put(v, sum / (double)kj);
                }
                ++v;
            }
            int i = 0;
            while (i < numItems) {
                if (!items.contains(i)) {
                    SparseVector iv = this.trainMatrix.column(i);
                    sum = 0.0;
                    int[] nArray = iv.getIndex();
                    n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int user = nArray[n3];
                        sum += userResources.containsKey(user) ? (Double)userResources.get(user) : 0.0;
                        ++n3;
                    }
                    double score = sum / Math.pow(this.itemDegrees.get(i).intValue(), 1.0f - this.lambda);
                    this.userItemRanks.put(u, i, score);
                }
                ++i;
            }
        }
        return this.userItemRanks.contains(u, j) ? this.userItemRanks.get(u, j) : 0.0;
    }

    protected double ProbS(int u, int j) {
        if (!this.userItemRanks.containsRow(u)) {
            int n;
            int n2;
            int[] nArray;
            double sum;
            this.userItemRanks.clear();
            SparseVector uv = this.trainMatrix.row(u);
            List<Integer> items = Lists.toList(uv.getIndex());
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            int v = 0;
            while (v < numUsers) {
                SparseVector vv = this.trainMatrix.row(v);
                sum = 0.0;
                nArray = vv.getIndex();
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    int item = nArray[n];
                    if (items.contains(item)) {
                        sum += 1.0 / (double)this.itemDegrees.get(item).intValue();
                    }
                    ++n;
                }
                userResources.put(v, sum);
                ++v;
            }
            int i = 0;
            while (i < numItems) {
                if (!items.contains(i)) {
                    SparseVector iv = this.trainMatrix.column(i);
                    sum = 0.0;
                    nArray = iv.getIndex();
                    n2 = nArray.length;
                    n = 0;
                    while (n < n2) {
                        int user = nArray[n];
                        sum += (Double)userResources.get(user) / (double)this.userDegrees.get(user).intValue();
                        ++n;
                    }
                    double score = sum;
                    this.userItemRanks.put(u, i, score);
                }
                ++i;
            }
        }
        return this.userItemRanks.contains(u, j) ? this.userItemRanks.get(u, j) : 0.0;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "," + this.lambda;
    }
}

