/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import librec.data.SparseVector;

public class SymmMatrix
implements Serializable {
    private static final long serialVersionUID = -6138247653152029007L;
    protected int dim;
    Table<Integer, Integer, Double> data;

    public SymmMatrix(int dim) {
        this.dim = dim;
        this.data = HashBasedTable.create();
    }

    public SymmMatrix(SymmMatrix mat) {
        this.dim = mat.dim;
        this.data = HashBasedTable.create(mat.data);
    }

    public SymmMatrix clone() {
        return new SymmMatrix(this);
    }

    public double get(int row, int col) {
        if (this.data.contains(row, col)) {
            return this.data.get(row, col);
        }
        if (this.data.contains(col, row)) {
            return this.data.get(col, row);
        }
        return 0.0;
    }

    public void set(int row, int col, double val) {
        if (row >= col) {
            this.data.put(row, col, val);
        } else {
            this.data.put(col, row, val);
        }
    }

    public void add(int row, int col, double val) {
        if (row >= col) {
            this.data.put(row, col, val + this.get(row, col));
        } else {
            this.data.put(col, row, val + this.get(col, row));
        }
    }

    public SparseVector row(int row) {
        SparseVector res = new SparseVector(this.dim);
        int col = 0;
        while (col < this.dim) {
            double val = this.get(row, col);
            if (val != 0.0) {
                res.set(col, val);
            }
            ++col;
        }
        return res;
    }

    public String toString() {
        return "Dimension: " + this.dim + " x " + this.dim + "\n" + this.data.toString();
    }
}

