/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import librec.data.DenseMatrix;
import librec.util.Maths;

public class SVD {
    private double[][] U;
    private double[][] V;
    private double[] sigma;
    private int m;
    private int n;

    public SVD(DenseMatrix mat) {
        int i;
        double t;
        int j;
        DenseMatrix matClone = mat.clone();
        double[][] A = matClone.data;
        this.m = matClone.numRows;
        this.n = matClone.numColumns;
        int nu = Math.min(this.m, this.n);
        this.sigma = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k = 0;
        while (k < Math.max(nct, nrt)) {
            int i2;
            int i3;
            if (k < nct) {
                this.sigma[k] = 0.0;
                i3 = k;
                while (i3 < this.m) {
                    this.sigma[k] = Maths.hypot(this.sigma[k], A[i3][k]);
                    ++i3;
                }
                if (this.sigma[k] != 0.0) {
                    if (A[k][k] < 0.0) {
                        this.sigma[k] = -this.sigma[k];
                    }
                    i3 = k;
                    while (i3 < this.m) {
                        double[] dArray = A[i3];
                        int n = k;
                        dArray[n] = dArray[n] / this.sigma[k];
                        ++i3;
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.sigma[k] = -this.sigma[k];
            }
            j = k + 1;
            while (j < this.n) {
                if (k < nct & this.sigma[k] != 0.0) {
                    double t2 = 0.0;
                    i2 = k;
                    while (i2 < this.m) {
                        t2 += A[i2][k] * A[i2][j];
                        ++i2;
                    }
                    t2 = -t2 / A[k][k];
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k];
                        ++i2;
                    }
                }
                e[j] = A[k][j];
                ++j;
            }
            if (k < nct) {
                i3 = k;
                while (i3 < this.m) {
                    this.U[i3][k] = A[i3][k];
                    ++i3;
                }
            }
            if (k < nrt) {
                e[k] = 0.0;
                i3 = k + 1;
                while (i3 < this.n) {
                    e[k] = Maths.hypot(e[k], e[i3]);
                    ++i3;
                }
                if (e[k] != 0.0) {
                    if (e[k + 1] < 0.0) {
                        e[k] = -e[k];
                    }
                    i3 = k + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k];
                    }
                    int n = k + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k] = -e[k];
                if (k + 1 < this.m & e[k] != 0.0) {
                    i3 = k + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0;
                        ++i3;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        int i4 = k + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        double t3 = -e[j] / e[k + 1];
                        i2 = k + 1;
                        while (i2 < this.m) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * work[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                i3 = k + 1;
                while (i3 < this.n) {
                    this.V[i3][k] = e[i3];
                    ++i3;
                }
            }
            ++k;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.sigma[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.sigma[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        j = nct;
        while (j < nu) {
            int i5 = 0;
            while (i5 < this.m) {
                this.U[i5][j] = 0.0;
                ++i5;
            }
            this.U[j][j] = 1.0;
            ++j;
        }
        int k2 = nct - 1;
        while (k2 >= 0) {
            int i6;
            if (this.sigma[k2] != 0.0) {
                int j2 = k2 + 1;
                while (j2 < nu) {
                    t = 0.0;
                    i = k2;
                    while (i < this.m) {
                        t += this.U[i][k2] * this.U[i][j2];
                        ++i;
                    }
                    t = -t / this.U[k2][k2];
                    i = k2;
                    while (i < this.m) {
                        double[] dArray = this.U[i];
                        int n = j2;
                        dArray[n] = dArray[n] + t * this.U[i][k2];
                        ++i;
                    }
                    ++j2;
                }
                i6 = k2;
                while (i6 < this.m) {
                    this.U[i6][k2] = -this.U[i6][k2];
                    ++i6;
                }
                this.U[k2][k2] = 1.0 + this.U[k2][k2];
                i6 = 0;
                while (i6 < k2 - 1) {
                    this.U[i6][k2] = 0.0;
                    ++i6;
                }
            } else {
                i6 = 0;
                while (i6 < this.m) {
                    this.U[i6][k2] = 0.0;
                    ++i6;
                }
                this.U[k2][k2] = 1.0;
            }
            --k2;
        }
        k2 = this.n - 1;
        while (k2 >= 0) {
            if (k2 < nrt & e[k2] != 0.0) {
                int j3 = k2 + 1;
                while (j3 < nu) {
                    t = 0.0;
                    i = k2 + 1;
                    while (i < this.n) {
                        t += this.V[i][k2] * this.V[i][j3];
                        ++i;
                    }
                    t = -t / this.V[k2 + 1][k2];
                    i = k2 + 1;
                    while (i < this.n) {
                        double[] dArray = this.V[i];
                        int n = j3;
                        dArray[n] = dArray[n] + t * this.V[i][k2];
                        ++i;
                    }
                    ++j3;
                }
            }
            int i7 = 0;
            while (i7 < this.n) {
                this.V[i7][k2] = 0.0;
                ++i7;
            }
            this.V[k2][k2] = 1.0;
            --k2;
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= -1) {
                if (k3 == -1) break;
                if (Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.sigma[k3]) + Math.abs(this.sigma[k3 + 1]))) {
                    e[k3] = 0.0;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (Math.abs(this.sigma[ks]) <= tiny + eps * t4) {
                        this.sigma[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    int j4 = p - 2;
                    while (j4 >= k3) {
                        t5 = Maths.hypot(this.sigma[j4], f);
                        cs = this.sigma[j4] / t5;
                        sn = f / t5;
                        this.sigma[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        i8 = 0;
                        while (i8 < this.n) {
                            t5 = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                            this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                            this.V[i8][j4] = t5;
                            ++i8;
                        }
                        --j4;
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    int j5 = k3;
                    while (j5 < p) {
                        t5 = Maths.hypot(this.sigma[j5], f);
                        cs = this.sigma[j5] / t5;
                        sn = f / t5;
                        this.sigma[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        i8 = 0;
                        while (i8 < this.m) {
                            t5 = cs * this.U[i8][j5] + sn * this.U[i8][k3 - 1];
                            this.U[i8][k3 - 1] = -sn * this.U[i8][j5] + cs * this.U[i8][k3 - 1];
                            this.U[i8][j5] = t5;
                            ++i8;
                        }
                        ++j5;
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.sigma[p - 1]), Math.abs(this.sigma[p - 2])), Math.abs(e[p - 2])), Math.abs(this.sigma[k3])), Math.abs(e[k3]));
                    double sp = this.sigma[p - 1] / scale;
                    double spm1 = this.sigma[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.sigma[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    int j6 = k3;
                    while (j6 < p - 1) {
                        double t6 = Maths.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.sigma[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.sigma[j6];
                        g = sn * this.sigma[j6 + 1];
                        this.sigma[j6 + 1] = cs * this.sigma[j6 + 1];
                        int i9 = 0;
                        while (i9 < this.n) {
                            t6 = cs * this.V[i9][j6] + sn * this.V[i9][j6 + 1];
                            this.V[i9][j6 + 1] = -sn * this.V[i9][j6] + cs * this.V[i9][j6 + 1];
                            this.V[i9][j6] = t6;
                            ++i9;
                        }
                        t6 = Maths.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.sigma[j6] = t6;
                        f = cs * e[j6] + sn * this.sigma[j6 + 1];
                        this.sigma[j6 + 1] = -sn * e[j6] + cs * this.sigma[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (j6 < this.m - 1) {
                            i9 = 0;
                            while (i9 < this.m) {
                                t6 = cs * this.U[i9][j6] + sn * this.U[i9][j6 + 1];
                                this.U[i9][j6 + 1] = -sn * this.U[i9][j6] + cs * this.U[i9][j6 + 1];
                                this.U[i9][j6] = t6;
                                ++i9;
                            }
                        }
                        ++j6;
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.sigma[k3] <= 0.0) {
                        this.sigma[k3] = this.sigma[k3] < 0.0 ? -this.sigma[k3] : 0.0;
                        int i10 = 0;
                        while (i10 <= pp) {
                            this.V[i10][k3] = -this.V[i10][k3];
                            ++i10;
                        }
                    }
                    while (k3 < pp) {
                        int i11;
                        if (this.sigma[k3] >= this.sigma[k3 + 1]) break;
                        double t7 = this.sigma[k3];
                        this.sigma[k3] = this.sigma[k3 + 1];
                        this.sigma[k3 + 1] = t7;
                        if (k3 < this.n - 1) {
                            i11 = 0;
                            while (i11 < this.n) {
                                t7 = this.V[i11][k3 + 1];
                                this.V[i11][k3 + 1] = this.V[i11][k3];
                                this.V[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        if (k3 < this.m - 1) {
                            i11 = 0;
                            while (i11 < this.m) {
                                t7 = this.U[i11][k3 + 1];
                                this.U[i11][k3 + 1] = this.U[i11][k3];
                                this.U[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public DenseMatrix getU() {
        return new DenseMatrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public DenseMatrix getV() {
        return new DenseMatrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.sigma;
    }

    public DenseMatrix getS() {
        DenseMatrix res = new DenseMatrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            res.set(i, i, this.sigma[i]);
            ++i;
        }
        return res;
    }

    public double norm2() {
        return this.sigma[0];
    }

    public double cond() {
        return this.sigma[0] / this.sigma[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.sigma[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.sigma.length) {
            if (this.sigma[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }
}

