/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import librec.data.SparseMatrix;

public class DiagMatrix
extends SparseMatrix {
    private static final long serialVersionUID = -9186836460633909994L;

    public DiagMatrix(int rows, int cols, Table<Integer, Integer, Double> dataTable, Multimap<Integer, Integer> colMap) {
        super(rows, cols, dataTable, colMap);
    }

    public DiagMatrix(DiagMatrix mat) {
        super(mat);
    }

    @Override
    public DiagMatrix clone() {
        return new DiagMatrix(this);
    }

    public DiagMatrix scale(double val) {
        DiagMatrix res = this.clone();
        int i = 0;
        while (i < res.numRows) {
            res.set(i, i, this.get(i, i) * val);
            ++i;
        }
        return res;
    }

    public DiagMatrix add(DiagMatrix that) {
        DiagMatrix res = this.clone();
        int i = 0;
        while (i < res.numRows) {
            res.set(i, i, this.get(i, i) + that.get(i, i));
            ++i;
        }
        return res;
    }

    public DiagMatrix add(double val) {
        DiagMatrix res = this.clone();
        int i = 0;
        while (i < res.numRows) {
            res.set(i, i, this.get(i, i) + val);
            ++i;
        }
        return res;
    }

    public DiagMatrix minus(DiagMatrix that) {
        DiagMatrix res = this.clone();
        int i = 0;
        while (i < res.numRows) {
            res.set(i, i, this.get(i, i) - that.get(i, i));
            ++i;
        }
        return res;
    }

    public DiagMatrix minus(double val) {
        DiagMatrix res = this.clone();
        int i = 0;
        while (i < res.numRows) {
            res.set(i, i, this.get(i, i) - val);
            ++i;
        }
        return res;
    }

    public static DiagMatrix eye(int n) {
        HashBasedTable<Integer, Integer, Double> vals = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int i = 0;
        while (i < n) {
            vals.put(i, i, 1.0);
            colMap.put(i, i);
            ++i;
        }
        return new DiagMatrix(n, n, (Table<Integer, Integer, Double>)vals, (Multimap<Integer, Integer>)colMap);
    }
}

