/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import java.io.Serializable;
import librec.data.DenseMatrix;
import librec.data.SparseVector;
import librec.util.Randoms;
import librec.util.Stats;
import librec.util.Strings;

public class DenseVector
implements Serializable {
    private static final long serialVersionUID = -2930574547913792430L;
    protected int size;
    protected double[] data;

    public DenseVector(int size) {
        this.size = size;
        this.data = new double[size];
    }

    public DenseVector(double[] array) {
        this(array, true);
    }

    public DenseVector(double[] array, boolean deep) {
        this.size = array.length;
        if (deep) {
            this.data = new double[array.length];
            int i = 0;
            while (i < this.size) {
                this.data[i] = array[i];
                ++i;
            }
        } else {
            this.data = array;
        }
    }

    public DenseVector(DenseVector vec) {
        this(vec.data);
    }

    public DenseVector clone() {
        return new DenseVector(this);
    }

    public void init(double mean, double sigma) {
        int i = 0;
        while (i < this.size) {
            this.data[i] = Randoms.gaussian(mean, sigma);
            ++i;
        }
    }

    public void init() {
        int i = 0;
        while (i < this.size) {
            this.data[i] = Randoms.uniform();
            ++i;
        }
    }

    public void init(double range) {
        int i = 0;
        while (i < this.size) {
            this.data[i] = Randoms.uniform(0.0, range);
            ++i;
        }
    }

    public double get(int idx) {
        return this.data[idx];
    }

    public double[] getData() {
        return this.data;
    }

    public double mean() {
        return Stats.mean(this.data);
    }

    public double sum() {
        return Stats.sum(this.data);
    }

    public void set(int idx, double val) {
        this.data[idx] = val;
    }

    public void setAll(double val) {
        int i = 0;
        while (i < this.size) {
            this.data[i] = val;
            ++i;
        }
    }

    public void add(int idx, double val) {
        int n = idx;
        this.data[n] = this.data[n] + val;
    }

    public void minus(int idx, double val) {
        int n = idx;
        this.data[n] = this.data[n] - val;
    }

    public DenseVector add(double val) {
        DenseVector result = new DenseVector(this.size);
        int i = 0;
        while (i < this.size) {
            result.data[i] = this.data[i] + val;
            ++i;
        }
        return result;
    }

    public DenseVector minus(double val) {
        DenseVector result = new DenseVector(this.size);
        int i = 0;
        while (i < this.size) {
            result.data[i] = this.data[i] - val;
            ++i;
        }
        return result;
    }

    public DenseVector scale(double val) {
        DenseVector result = new DenseVector(this.size);
        int i = 0;
        while (i < this.size) {
            result.data[i] = this.data[i] * val;
            ++i;
        }
        return result;
    }

    public DenseVector add(DenseVector vec) {
        assert (this.size == vec.size);
        DenseVector result = new DenseVector(this.size);
        int i = 0;
        while (i < result.size) {
            result.data[i] = this.data[i] + vec.data[i];
            ++i;
        }
        return result;
    }

    public DenseVector minus(DenseVector vec) {
        assert (this.size == vec.size);
        DenseVector result = new DenseVector(this.size);
        int i = 0;
        while (i < vec.size) {
            result.data[i] = this.data[i] - vec.data[i];
            ++i;
        }
        return result;
    }

    public double inner(DenseVector vec) {
        assert (this.size == vec.size);
        double result = 0.0;
        int i = 0;
        while (i < vec.size) {
            result += this.get(i) * vec.get(i);
            ++i;
        }
        return result;
    }

    public double inner(SparseVector vec) {
        double result = 0.0;
        int[] nArray = vec.getIndex();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            result += vec.get(j) * this.get(j);
            ++n2;
        }
        return result;
    }

    public DenseMatrix outer(DenseVector vec) {
        DenseMatrix mat = new DenseMatrix(this.size, vec.size);
        int i = 0;
        while (i < mat.numRows) {
            int j = 0;
            while (j < mat.numColumns) {
                mat.set(i, j, this.get(i) * vec.get(j));
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public String toString() {
        return Strings.toString(this.data);
    }
}

