/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseTensor;
import librec.util.Dates;
import librec.util.FileIO;
import librec.util.Logs;
import librec.util.Stats;
import librec.util.Strings;

public class DataDAO {
    private String dataName;
    private String dataDir;
    private String dataPath;
    private SparseMatrix rateMatrix;
    private SparseMatrix timeMatrix;
    private SparseTensor rateTensor;
    private boolean isItemAsUser;
    private boolean isHeadline = false;
    private List<Double> ratingScale;
    private Multiset<Double> scaleDist;
    private int numRatings;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;
    private BiMap<Integer, String> idUsers;
    private BiMap<Integer, String> idItems;
    private TimeUnit timeUnit;
    private long minTimestamp;
    private long maxTimestamp;

    public DataDAO(String path, BiMap<String, Integer> userIds, BiMap<String, Integer> itemIds) {
        this.dataPath = path;
        this.userIds = userIds == null ? HashBiMap.create() : userIds;
        this.itemIds = itemIds == null ? HashBiMap.create() : itemIds;
        this.scaleDist = HashMultiset.create();
        this.isItemAsUser = this.userIds == this.itemIds;
        this.timeUnit = TimeUnit.SECONDS;
    }

    public DataDAO(String path) {
        this(path, null, null);
    }

    public DataDAO(String path, BiMap<String, Integer> userIds) {
        this(path, userIds, userIds);
    }

    public SparseMatrix[] readData() throws Exception {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        return this.readData(nArray, -1.0);
    }

    public SparseMatrix[] readData(double binThold) throws Exception {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        return this.readData(nArray, binThold);
    }

    public SparseMatrix[] readData(int[] cols, double binThold) throws Exception {
        double epsilon;
        Logs.info(String.format("Dataset: %s", Strings.last(this.dataPath, 38)));
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashBasedTable<Integer, Integer, Long> timeTable = null;
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        BufferedReader br = FileIO.getReader(this.dataPath);
        String line = null;
        this.minTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        while ((line = br.readLine()) != null) {
            if (this.isHeadline()) {
                this.setHeadline(false);
                continue;
            }
            String[] data = line.trim().split("[ \t,]+");
            String user = data[cols[0]];
            String item = data[cols[1]];
            Double rate = cols.length >= 3 && data.length >= 3 ? Double.valueOf(data[cols[2]]) : 1.0;
            if (binThold >= 0.0) {
                rate = rate > binThold ? 1.0 : 0.0;
            }
            this.scaleDist.add(rate);
            int row = this.userIds.containsKey(user) ? ((Integer)this.userIds.get(user)).intValue() : this.userIds.size();
            this.userIds.put(user, row);
            int col = this.itemIds.containsKey(item) ? ((Integer)this.itemIds.get(item)).intValue() : this.itemIds.size();
            this.itemIds.put(item, col);
            dataTable.put(row, col, rate);
            colMap.put(col, row);
            if (cols.length < 4 || data.length < 4) continue;
            if (timeTable == null) {
                timeTable = HashBasedTable.create();
            }
            long mms = 0L;
            try {
                mms = Long.parseLong(data[cols[3]]);
            }
            catch (NumberFormatException e) {
                mms = (long)Double.parseDouble(data[cols[3]]);
            }
            long timestamp = this.timeUnit.toMillis(mms);
            if (this.minTimestamp > timestamp) {
                this.minTimestamp = timestamp;
            }
            if (this.maxTimestamp < timestamp) {
                this.maxTimestamp = timestamp;
            }
            timeTable.put(row, col, timestamp);
        }
        br.close();
        this.numRatings = this.scaleDist.size();
        this.ratingScale = new ArrayList<Double>(this.scaleDist.elementSet());
        Collections.sort(this.ratingScale);
        int numRows = this.numUsers();
        int numCols = this.numItems();
        double minRate = this.ratingScale.get(0);
        double d = epsilon = minRate == 0.0 ? this.ratingScale.get(1) - minRate : 0.0;
        if (epsilon > 0.0) {
            int i = 0;
            int im = this.ratingScale.size();
            while (i < im) {
                double val = this.ratingScale.get(i);
                this.ratingScale.set(i, val + epsilon);
                ++i;
            }
            int row = 0;
            while (row < numRows) {
                int col = 0;
                while (col < numCols) {
                    if (dataTable.contains(row, col)) {
                        dataTable.put(row, col, (Double)dataTable.get(row, col) + epsilon);
                    }
                    ++col;
                }
                ++row;
            }
        }
        String dateRange = "";
        if (cols.length >= 4) {
            dateRange = String.format(", Timestamps = {%s, %s}", Dates.toString(this.minTimestamp), Dates.toString(this.maxTimestamp));
        }
        Logs.debug("With Specs: {Users, {}} = {{}, {}, {}}, Scale = {{}}{}", this.isItemAsUser ? "Users, Links" : "Items, Ratings", numRows, numCols, this.numRatings, Strings.toString(this.ratingScale), dateRange);
        this.rateMatrix = new SparseMatrix(numRows, numCols, dataTable, colMap);
        if (timeTable != null) {
            this.timeMatrix = new SparseMatrix(numRows, numCols, timeTable, colMap);
        }
        dataTable = null;
        timeTable = null;
        return new SparseMatrix[]{this.rateMatrix, this.timeMatrix};
    }

    /*
     * Unable to fully structure code
     */
    public SparseMatrix[] readTensor(int[] cols, double binThold) throws Exception {
        if (cols.length < 3) {
            throw new Exception("Column length cannot be smaller than 3. Usage: user, item, rating columns.");
        }
        Logs.info(String.format("Dataset: %s", new Object[]{Strings.last(this.dataPath, 38)}));
        dims = null;
        numDims = 0;
        ndLists = null;
        ndSets = null;
        vals = new ArrayList<Double>();
        br = FileIO.getReader(this.dataPath);
        line = null;
        while ((line = br.readLine()) != null) {
            if (this.isHeadline()) {
                this.setHeadline(false);
                continue;
            }
            data = line.trim().split("[ \t,]+");
            if (dims == null) {
                numDims = data.length - 1;
                dims = new int[numDims];
                ndLists = new List[numDims];
                ndSets = new Set[numDims];
                d = 0;
                while (d < numDims) {
                    ndLists[d] = new ArrayList<E>();
                    ndSets[d] = new HashSet<E>();
                    ++d;
                }
            }
            d = 0;
            while (d < data.length) {
                block14: {
                    block13: {
                        val = data[d];
                        feature = -1;
                        if (d != cols[0]) break block13;
                        feature = this.userIds.containsKey(val) != false ? ((Integer)this.userIds.get(val)).intValue() : this.userIds.size();
                        this.userIds.put(val, feature);
                        ** GOTO lbl53
                    }
                    if (d != cols[1]) break block14;
                    feature = this.itemIds.containsKey(val) != false ? ((Integer)this.itemIds.get(val)).intValue() : this.itemIds.size();
                    this.itemIds.put(val, feature);
                    ** GOTO lbl53
                }
                if (d == cols[2]) {
                    rate = Double.parseDouble(val);
                    if (binThold >= 0.0) {
                        rate = rate > binThold ? 1.0 : 0.0;
                    }
                    vals.add(rate);
                    this.scaleDist.add(rate);
                } else {
                    feature = val.equalsIgnoreCase("na") != false ? 0 : Integer.parseInt(val);
lbl53:
                    // 3 sources

                    dim = d > cols[2] ? d - 1 : d;
                    ndLists[dim].add(feature);
                    ndSets[dim].add(feature);
                }
                ++d;
            }
        }
        br.close();
        this.numRatings = this.scaleDist.size();
        this.ratingScale = new ArrayList<Double>(this.scaleDist.elementSet());
        Collections.sort(this.ratingScale);
        minRate = this.ratingScale.get(0);
        v0 = epsilon = minRate == 0.0 ? this.ratingScale.get(1) - minRate : 0.0;
        if (epsilon > 0.0) {
            i = 0;
            im = this.ratingScale.size();
            while (i < im) {
                val = this.ratingScale.get(i);
                this.ratingScale.set(i, val + epsilon);
                ++i;
            }
            i = 0;
            while (i < vals.size()) {
                vals.set(i, (Double)vals.get(i) + epsilon);
                ++i;
            }
        }
        numRows = this.numUsers();
        numCols = this.numItems();
        d = 0;
        while (d < numDims) {
            dims[d] = ndSets[d].size();
            ++d;
        }
        Logs.debug("With Specs: {Users, Items, Ratings, Features} = {{}, {}, {}, {}}, Scale = {{}}", new Object[]{numRows, numCols, this.numRatings, numDims - 2, Strings.toString(this.ratingScale)});
        this.rateTensor = new SparseTensor(dims, ndLists, vals);
        this.rateTensor.setUserDimension(cols[0]);
        this.rateTensor.setItemDimension(cols[1]);
        v1 = new SparseMatrix[2];
        v1[0] = this.rateTensor.rateMatrix();
        return v1;
    }

    public void writeData(String toPath, String sep) throws Exception {
        FileIO.deleteFile(toPath);
        ArrayList<String> lines = new ArrayList<String>(1500);
        for (MatrixEntry me : this.rateMatrix) {
            String line = Strings.toString(new Object[]{me.row() + 1, me.column() + 1, Float.valueOf((float)me.get())}, sep);
            lines.add(line);
            if (lines.size() < 1000) continue;
            FileIO.writeList(toPath, lines, null, true);
            lines.clear();
        }
        if (lines.size() > 0) {
            FileIO.writeList(toPath, lines, null, true);
        }
        Logs.debug("Data has been exported to {}", (Object)toPath);
    }

    public void writeData(String toPath) throws Exception {
        this.writeData(toPath, " ");
    }

    public void writeArff(String relation, String toPath) throws Exception {
        FileIO.deleteFile(toPath);
        BufferedWriter bw = FileIO.getWriter(toPath);
        bw.write("@RELATION " + relation + "\n\n");
        bw.write("@ATTRIBUTE UserId NUMERIC\n\n");
        bw.write("@DATA\n");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int u = 0;
        int um = this.numUsers();
        while (u < um) {
            sb.append("{0 " + (u + 1));
            int j = 0;
            int jm = this.numItems();
            while (j < jm) {
                double rate = this.rateMatrix.get(u, j);
                if (rate != 0.0) {
                    sb.append(", " + (j + 1) + " " + rate);
                }
                if (j == jm - 1) {
                    sb.append("}\n");
                }
                ++j;
            }
            if (count++ >= 500) {
                bw.write(sb.toString());
                count = 0;
                sb = new StringBuilder();
            }
            ++u;
        }
        if (count > 0) {
            bw.write(sb.toString());
        }
        bw.close();
        Logs.debug("Data has been exported to {}", (Object)toPath);
    }

    public void printSpecs() throws Exception {
        if (this.rateMatrix == null) {
            this.readData();
        }
        ArrayList<String> sps = new ArrayList<String>();
        int users = this.numUsers();
        int items = this.numItems();
        int numRates = this.rateMatrix.size();
        sps.add(String.format("Dataset: %s", this.dataPath));
        sps.add("User amount: " + users + ", " + FileIO.formatSize(users));
        if (!this.isItemAsUser) {
            sps.add("Item amount: " + items + ", " + FileIO.formatSize(items));
        }
        sps.add("Rate amount: " + numRates + ", " + FileIO.formatSize(numRates));
        sps.add(String.format("Data density: %.4f%%", ((double)numRates + 0.0) / (double)users / (double)items * 100.0));
        sps.add("Scale distribution: " + this.scaleDist.toString());
        double[] data = this.rateMatrix.getData();
        float mean = (float)(Stats.sum(data) / (double)numRates);
        float std = (float)Stats.sd(data);
        float mode = (float)Stats.mode(data);
        float median = (float)Stats.median(data);
        sps.add("");
        sps.add(String.format("Average value of all ratings: %f", Float.valueOf(mean)));
        sps.add(String.format("Standard deviation of all ratings: %f", Float.valueOf(std)));
        sps.add(String.format("Mode of all rating values: %f", Float.valueOf(mode)));
        sps.add(String.format("Median of all rating values: %f", Float.valueOf(median)));
        ArrayList<Integer> userCnts = new ArrayList<Integer>();
        int userMax = 0;
        int userMin = Integer.MAX_VALUE;
        int u = 0;
        int um = this.numUsers();
        while (u < um) {
            int size = this.rateMatrix.rowSize(u);
            if (size > 0) {
                userCnts.add(size);
                if (size > userMax) {
                    userMax = size;
                }
                if (size < userMin) {
                    userMin = size;
                }
            }
            ++u;
        }
        sps.add("");
        sps.add(String.format("Max number of ratings per user: %d", userMax));
        sps.add(String.format("Min number of ratings per user: %d", userMin));
        sps.add(String.format("Average number of ratings per user: %f", Float.valueOf((float)Stats.mean(userCnts))));
        sps.add(String.format("Standard deviation of number of ratings per user: %f", Float.valueOf((float)Stats.sd(userCnts))));
        if (!this.isItemAsUser) {
            ArrayList<Integer> itemCnts = new ArrayList<Integer>();
            int itemMax = 0;
            int itemMin = Integer.MAX_VALUE;
            int j = 0;
            int jm = this.numItems();
            while (j < jm) {
                int size = this.rateMatrix.columnSize(j);
                if (size > 0) {
                    itemCnts.add(size);
                    if (size > itemMax) {
                        itemMax = size;
                    }
                    if (size < itemMin) {
                        itemMin = size;
                    }
                }
                ++j;
            }
            sps.add("");
            sps.add(String.format("Max number of ratings per item: %d", itemMax));
            sps.add(String.format("Min number of ratings per item: %d", itemMin));
            sps.add(String.format("Average number of ratings per item: %f", Float.valueOf((float)Stats.mean(itemCnts))));
            sps.add(String.format("Standard deviation of number of ratings per item: %f", Float.valueOf((float)Stats.sd(itemCnts))));
        }
        Logs.info(Strings.toSection(sps));
    }

    public void printDistr(boolean isWriteOut) throws Exception {
        int numRates;
        if (this.rateMatrix == null) {
            this.readData();
        }
        HashMultiset<Integer> numURates = HashMultiset.create();
        HashMultiset<Integer> numIRates = HashMultiset.create();
        int r = 0;
        int rm = this.rateMatrix.numRows;
        while (r < rm) {
            numRates = this.rateMatrix.rowSize(r);
            numURates.add(numRates);
            ++r;
        }
        int c = 0;
        int cm = this.rateMatrix.numColumns;
        while (c < cm) {
            numRates = this.rateMatrix.columnSize(c);
            numIRates.add(numRates);
            ++c;
        }
        String ustrs = Strings.toString(numURates);
        String istrs = Strings.toString(numIRates);
        if (isWriteOut) {
            FileIO.writeString(String.valueOf(FileIO.desktop) + "user-distr.txt", ustrs);
            FileIO.writeString(String.valueOf(FileIO.desktop) + "item-distr.txt", istrs);
        } else {
            Logs.debug("#ratings (x) ~ #users (y): \n" + ustrs);
            Logs.debug("#ratings (x) ~ #items (y): \n" + istrs);
        }
        Logs.debug("Done!");
    }

    public int numUsers() {
        return this.userIds.size();
    }

    public int numItems() {
        return this.itemIds.size();
    }

    public int numRatings() {
        return this.numRatings;
    }

    public int numDays() {
        return (int)TimeUnit.MILLISECONDS.toDays(this.maxTimestamp - this.minTimestamp);
    }

    public int getUserId(String rawId) {
        return (Integer)this.userIds.get(rawId);
    }

    public String getUserId(int innerId) {
        if (this.idUsers == null) {
            this.idUsers = this.userIds.inverse();
        }
        return (String)this.idUsers.get(innerId);
    }

    public int getItemId(String rawId) {
        return (Integer)this.itemIds.get(rawId);
    }

    public String getItemId(int innerId) {
        if (this.idItems == null) {
            this.idItems = this.itemIds.inverse();
        }
        return (String)this.idItems.get(innerId);
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public SparseMatrix getRateMatrix() {
        return this.rateMatrix;
    }

    public boolean isItemAsUser() {
        return this.isItemAsUser;
    }

    public List<Double> getRatingScale() {
        return this.ratingScale;
    }

    public BiMap<String, Integer> getUserIds() {
        return this.userIds;
    }

    public BiMap<String, Integer> getItemIds() {
        return this.itemIds;
    }

    public String getDataName() {
        if (this.dataName == null) {
            this.dataName = this.dataPath.substring(this.dataPath.lastIndexOf(File.separator) + 1, this.dataPath.lastIndexOf("."));
        }
        return this.dataName;
    }

    public String getDataDirectory() {
        if (this.dataDir == null) {
            int pos = this.dataPath.lastIndexOf(File.separator);
            this.dataDir = pos > 0 ? this.dataPath.substring(0, pos + 1) : "." + File.separator;
        }
        return this.dataDir;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public SparseTensor getRateTensor() {
        return this.rateTensor;
    }

    public boolean isHeadline() {
        return this.isHeadline;
    }

    public void setHeadline(boolean isHeadline) {
        this.isHeadline = isHeadline;
    }
}

