/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import java.io.BufferedReader;
import java.util.ArrayList;
import librec.util.FileIO;

public class DataConvertor {
    private String sourcePath;
    private String targetPath;

    public DataConvertor(String sourcePath, String targetPath) throws Exception {
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        FileIO.deleteFile(targetPath);
    }

    public void cvtSeparator(String sep, String toSep) throws Exception {
        BufferedReader br = FileIO.getReader(this.sourcePath);
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            String newline = line.replaceAll(sep, toSep);
            lines.add(newline);
            if (lines.size() < 1000) continue;
            FileIO.writeList(this.targetPath, lines, true);
            lines.clear();
        }
        if (lines.size() > 0) {
            FileIO.writeList(this.targetPath, lines, true);
        }
        br.close();
    }

    public void cvtFirstLines(String sep1, String sep2) throws Exception {
        BufferedReader br = FileIO.getReader(this.sourcePath);
        String line = null;
        String userId = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            String[] vals = line.split(sep1);
            if (vals.length > 1) {
                userId = line.split(sep1)[0];
            } else {
                String newLine;
                vals = line.split(sep2);
                if (vals.length > 1) {
                    newLine = String.valueOf(userId) + " " + vals[0] + " " + vals[1];
                    lines.add(newLine);
                } else {
                    newLine = String.valueOf(userId) + " " + vals[0];
                    lines.add(newLine);
                }
            }
            if (lines.size() < 1000) continue;
            FileIO.writeList(this.targetPath, lines, true);
            lines.clear();
        }
        if (lines.size() > 0) {
            FileIO.writeList(this.targetPath, lines, true);
        }
        br.close();
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }
}

