/*
 * Decompiled with CFR 0.152.
 */
package librec.baseline;

import java.util.HashMap;
import java.util.Map;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.Recommender;

public class UserAverage
extends Recommender {
    private Map<Integer, Double> userMeans;

    public UserAverage(SparseMatrix rm, SparseMatrix tm, int fold) {
        super(rm, tm, fold);
        this.algoName = "UserAvg";
        this.userMeans = new HashMap<Integer, Double>();
    }

    @Override
    protected double predict(int u, int j) {
        if (!this.userMeans.containsKey(u)) {
            SparseVector uv = this.trainMatrix.row(u);
            this.userMeans.put(u, uv.getCount() > 0 ? uv.mean() : this.globalMean);
        }
        return this.userMeans.get(u);
    }
}

