/*
 * Decompiled with CFR 0.152.
 */
package librec.baseline;

import java.util.HashMap;
import java.util.Map;
import librec.data.SparseMatrix;
import librec.intf.Recommender;

public class MostPopular
extends Recommender {
    private Map<Integer, Integer> itemPops;

    public MostPopular(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.setAlgoName("MostPop");
    }

    @Override
    protected void initModel() {
        this.itemPops = new HashMap<Integer, Integer>();
    }

    @Override
    protected double ranking(int u, int j) {
        if (!this.itemPops.containsKey(j)) {
            this.itemPops.put(j, this.trainMatrix.columnSize(j));
        }
        return this.itemPops.get(j).intValue();
    }
}

